/*
 * Decompiled with CFR 0.152.
 */
package ix.itest;

import ix.Release;
import ix.ichat.ChatMessage;
import ix.icore.Sendable;
import ix.icore.event.AgentNameEvent;
import ix.iface.ui.HelpFrame;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.ip2.Ip2Frame;
import ix.ip2.PanelFrame;
import ix.ispace.ISpaceTool;
import ix.itest.Itest;
import ix.itest.ReceivePanel;
import ix.itest.SendPanel;
import ix.util.Debug;
import ix.util.ISODateFormat;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.xml.XML;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class ItestFrame
extends PanelFrame
implements ActionListener {
    protected Itest itest;
    protected SendPanel sendPanel;
    protected ReceivePanel receivePanel;
    protected JPanel logoPanel;
    ToolController helpController = new ToolController("I-Test Help"){

        public Object createTool() {
            return new HelpFrame("ix-info.html");
        }
    };
    ToolController aboutITestController = new ToolController("About I-Test"){

        public Object createTool() {
            String string = ItestFrame.this.itest.getAgentDisplayName() + " About I-Test";
            Ip2Frame.Ip2AboutFrame ip2AboutFrame = new Ip2Frame.Ip2AboutFrame(string);
            ((TextAreaFrame)ip2AboutFrame).setText(ItestFrame.this.makeAboutText());
            return ip2AboutFrame;
        }

        public Object ensureToolVisible() {
            TextAreaFrame textAreaFrame = (TextAreaFrame)this.ensureTool();
            textAreaFrame.setText(ItestFrame.this.makeAboutText());
            return super.ensureToolVisible();
        }
    };

    ItestFrame(Itest itest) {
        super(itest);
        this.itest = itest;
    }

    void setup() {
        this.sendPanel = new ITestSendPanel(this.itest);
        this.receivePanel = new ReceivePanel(this.itest);
        this.logoPanel = this.itest.makeLogoPanel();
        this.setIconImage(IconImage.getIconImage(this));
        this.setJMenuBar(this.makeMenuBar());
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.receivePanel);
        container.add(this.sendPanel);
        container.add(this.logoPanel);
    }

    public void setupFrame() {
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("Exit"));
        jMenuBar.add(this.toolManager.getToolsMenu());
        this.addItestTools();
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        jMenu2.add(this.makeMenuItem("Help"));
        jMenu2.add(this.makeMenuItem("About I-Test"));
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.testMenu);
        this.testMenu.setEnabled(false);
        return jMenuBar;
    }

    public void symbolNameChanged(AgentNameEvent agentNameEvent) {
        super.symbolNameChanged(agentNameEvent);
        Container container = this.getContentPane();
        container.remove(this.logoPanel);
        this.logoPanel = this.itest.makeLogoPanel();
        container.add(this.logoPanel);
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-Test action:", string);
        if (string.equals("Exit")) {
            if (Util.dialogConfirms(null, "Are you sure you want to exit?")) {
                System.exit(0);
            }
        } else if (string.equals("Help")) {
            this.helpController.ensureToolVisible();
        } else if (string.equals("About I-Test")) {
            this.aboutITestController.ensureToolVisible();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    protected void addItestTools() {
        this.addTool(new ToolController("I-Space"){

            public Object createTool() {
                return new ISpaceTool(ItestFrame.this.agent);
            }
        });
    }

    public SendPanel ensureSendPanelExists() {
        return this.sendPanel;
    }

    String makeAboutText() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("I-X version: " + Release.version + ", release date " + Release.date);
        linkedList.add("Agent class: " + this.itest.getClass().getName());
        linkedList.add("Started running: " + new ISODateFormat().formatDateTime(this.itest.getAgentStartupDate()));
        linkedList.add("Java version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"));
        Properties properties = Parameters.getParameters();
        TreeSet treeSet = new TreeSet(((Hashtable)properties).keySet());
        linkedList.add("");
        if (treeSet.isEmpty()) {
            linkedList.add("Parameters: none");
        } else {
            linkedList.add("Parameters: ");
            for (String string : treeSet) {
                String string2 = (String)((Hashtable)properties).get(string);
                linkedList.add("   " + string + " = " + string2 + (Parameters.usedParameter(string) ? "" : " [unused]"));
            }
        }
        XML.fileSyntaxManager().addAboutInfo(linkedList);
        return Strings.joinLines(linkedList);
    }

    class ITestSendPanel
    extends SendPanel {
        ITestSendPanel(Itest itest) {
            super(itest);
        }

        protected void sending(String string, Sendable sendable) {
            if (sendable instanceof ChatMessage) {
                ItestFrame.this.receivePanel.newMessage((ChatMessage)sendable);
            }
        }
    }
}

