/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.ispace.AbstractAgentGroup;
import ix.ispace.AgentData;
import ix.ispace.AgentGroup;
import ix.ispace.AgentRelationship;
import ix.ispace.Capability;
import ix.ispace.ListOfCapability;
import ix.ispace.RelationshipGroup;
import ix.ispace.VerbCapability;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Collect;
import ix.util.ColorGenerator;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.MultiHashMap;
import ix.util.MultiMap;
import ix.util.Parameters;
import ix.util.Strings;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContactManager {
    protected List listeners = new LinkedList();
    protected List agentData = new LinkedList();
    protected MultiMap relMap = new MultiHashMap();
    protected List groups = new LinkedList();
    protected Map nameToGroup = new HashMap();
    protected ColorGenerator colorGen = new ColorGenerator();

    public ContactManager() {
        this.addStandardAgentGroups();
    }

    public void addAgent(String string) {
        this.addAgent(string, AgentRelationship.CONTACT);
    }

    public void addAgent(String string, AgentRelationship agentRelationship) {
        Debug.expect(this.getAgentData(string) == null, "adding agent twice", string);
        AgentData agentData = new AgentData(string, agentRelationship);
        this.agentData.add(agentData);
        this.relMap.addValue(agentRelationship, agentData);
        this.fireNewContact(agentData);
    }

    public void addAgents(List list, AgentRelationship agentRelationship) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addAgent((String)iterator.next(), agentRelationship);
        }
    }

    public void noteAgent(String string) {
        this.noteAgent(string, AgentRelationship.CONTACT);
    }

    public void noteAgent(String string, AgentRelationship agentRelationship) {
        AgentData agentData = this.getAgentData(string);
        if (agentData == null) {
            this.addAgent(string, agentRelationship);
        }
    }

    public boolean ensureAgent(String string, AgentRelationship agentRelationship) {
        AgentData agentData = this.getAgentData(string);
        if (agentData == null) {
            this.addAgent(string, agentRelationship);
        } else {
            this.changeRelationship(string, agentRelationship);
        }
        return agentData == null;
    }

    public List getAgentData() {
        return this.agentData;
    }

    public AgentData getAgentData(String string) {
        for (AgentData agentData : this.agentData) {
            if (!agentData.getName().equals(string)) continue;
            return agentData;
        }
        return null;
    }

    public List getAgentData(AgentRelationship agentRelationship) {
        return (List)this.relMap.get(agentRelationship);
    }

    public List getAgentData(Capability capability) {
        return this.getAgentData(capability, false);
    }

    public List getAgentData(Capability capability, boolean bl) {
        LinkedList<AgentData> linkedList = new LinkedList<AgentData>();
        for (AgentData agentData : this.agentData) {
            if (!agentData.hasCapability(capability, bl)) continue;
            linkedList.add(agentData);
        }
        return linkedList;
    }

    public List getSortedNameList() {
        List list = (List)Collect.map(this.agentData, Fn.accessor(AgentData.class, "getName"));
        Collections.sort(list);
        return list;
    }

    protected void replaceAgentData(AgentData agentData, AgentData agentData2) {
        Collect.replaceFirst(agentData, agentData2, this.agentData);
        this.relMap.removeValue(agentData.getRelationship(), agentData);
        this.relMap.addValue(agentData2.getRelationship(), agentData2);
    }

    public void changeRelationship(String string, AgentRelationship agentRelationship) {
        AgentData agentData = this.getAgentData(string);
        AgentRelationship agentRelationship2 = agentData.getRelationship();
        Debug.noteln("Changing " + string + " from " + agentRelationship2 + " to " + agentRelationship);
        if (agentRelationship != agentRelationship2) {
            AgentData agentData2 = new AgentData(agentData);
            agentData2.setRelationship(agentRelationship);
            this.replaceAgentData(agentData, agentData2);
            this.checkAgentData(string, agentData2);
            this.fireContactChange(agentData, agentData2);
        }
    }

    public void deleteAgent(String string) {
        AgentData agentData = this.getAgentData(string);
        if (agentData == null) {
            throw new IllegalArgumentException("Attempt to delete unknown agent " + string);
        }
        AgentRelationship agentRelationship = agentData.getRelationship();
        this.agentData.remove(agentData);
        this.relMap.removeValue(agentRelationship, agentData);
        this.fireContactDeleted(agentData);
    }

    public void setCapabilities(String string, List list) {
        AgentData agentData = this.getAgentData(string);
        ListOfCapability listOfCapability = agentData.getCapabilities();
        Debug.noteln("Changing " + string + " capabilities from " + listOfCapability + " to " + list);
        if (!Collect.equalAsSets(listOfCapability, list)) {
            AgentData agentData2 = new AgentData(agentData);
            agentData2.setCapabilities(list);
            this.replaceAgentData(agentData, agentData2);
            this.checkAgentData(string, agentData2);
            this.fireContactChange(agentData, agentData2);
        }
    }

    private void checkAgentData(String string, AgentData agentData) {
        Debug.expect(this.getAgentData(string) == agentData, "Don't get new agent data for", string);
        ListOfCapability listOfCapability = agentData.getCapabilities();
        Debug.noteln("Checking that " + string + " has capabilities " + listOfCapability);
        for (Capability capability : listOfCapability) {
            Debug.expect(this.getAgentData(capability).contains(agentData), "Agent lacks capability", capability);
        }
        Debug.expect(this.getAgentData(agentData.getRelationship()).contains(agentData), "Relationship doesn't give new data");
    }

    public Color getAgentColor(String string) {
        return this.colorGen.getColor(string);
    }

    public Color getAgentColor(String string, Color color) {
        return this.colorGen.getColor(string, color);
    }

    public void setAgentColor(String string, Color color) {
        this.colorGen.setColor((Object)string, color);
    }

    public Collection getAgentGroups() {
        return this.groups;
    }

    public AgentGroup getAgentGroup(String string) {
        return (AgentGroup)this.nameToGroup.get(string);
    }

    public void addAgentGroup(AgentGroup agentGroup) {
        this.groups.add(agentGroup);
        this.nameToGroup.put(agentGroup.getName(), agentGroup);
    }

    protected void addStandardAgentGroups() {
        this.addAgentGroup(new AbstractAgentGroup("all", this){});
        for (AgentRelationship agentRelationship : AgentRelationship.values()) {
            if (agentRelationship == AgentRelationship.NONE) continue;
            this.addAgentGroup(new RelationshipGroup(agentRelationship, this));
        }
    }

    public void processCommandLineArguments() {
        for (Object object : AgentRelationship.values()) {
            List object2 = Parameters.getList(object + "s");
            this.warnAboutQuestionableAgentNames(object2, (AgentRelationship)object);
            this.addAgents(object2, (AgentRelationship)object);
        }
        String string = Parameters.getParameter("external-capabilities", "");
        for (String string2 : Strings.breakAt(",", string)) {
            String[] stringArray = Strings.breakAtFirst(":", string2);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            this.noteAgent(string3, AgentRelationship.SERVICE);
            AgentData agentData = this.getAgentData(string3);
            agentData.addCapability(new VerbCapability(string4));
        }
    }

    protected void warnAboutQuestionableAgentNames(List list, AgentRelationship agentRelationship) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            if (string.indexOf(58) < 0) continue;
            linkedList.add(string);
        }
        if (!linkedList.isEmpty()) {
            Debug.warn("The following agent names, gives as " + agentRelationship + "s, " + "contain colons: " + Strings.conjunction(linkedList) + ".  " + "Perhaps you meant them as agent capabilities.");
        }
    }

    public void addContactListener(ContactListener contactListener) {
        this.listeners.add(contactListener);
    }

    public void fireNewContact(AgentData agentData) {
        this.fireContactEvent(new ContactEvent(this, null, agentData));
    }

    public void fireContactDeleted(AgentData agentData) {
        this.fireContactEvent(new ContactEvent(this, agentData, null));
    }

    public void fireContactChange(AgentData agentData, AgentData agentData2) {
        this.fireContactEvent(new ContactEvent(this, agentData, agentData2));
    }

    public void fireContactEvent(ContactEvent contactEvent) {
        Debug.noteln("fireContactEvent", contactEvent);
        for (ContactListener contactListener : this.listeners) {
            contactListener.contactChange(contactEvent);
        }
    }
}

