/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.dynamic;

import ix.isim.dynamic.MoveSpec;
import ix.util.Debug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.ArrayList;

public class PointListMoveSpec
implements MoveSpec {
    static final double eRad = 6371000.0;
    private boolean finished = false;
    private ArrayList lats = new ArrayList();
    private ArrayList longs = new ArrayList();
    private ArrayList accDists = new ArrayList();
    private ArrayList bearings = new ArrayList();
    private double speedInMps = 0.0;
    private boolean circle = false;
    long startTime = System.currentTimeMillis();

    public PointListMoveSpec() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Debug.displayException(exception);
        }
    }

    public double getSpeed() {
        return this.speedInMps;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    public double getCurrentLatitude() {
        int n;
        double d;
        double d2 = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double d3 = this.speedInMps * d2;
        if (d3 >= (d = ((Double)this.accDists.get(this.accDists.size() - 1)).doubleValue())) {
            if (this.circle) {
                while (d3 >= d) {
                    d3 -= d;
                }
            } else {
                this.finished = true;
                return (Double)this.lats.get(this.lats.size() - 1) / Math.PI * 180.0;
            }
        }
        for (n = this.accDists.size() - 1; n >= 0 && !(d3 >= (Double)this.accDists.get(n - 1)); --n) {
        }
        double d4 = (Double)this.lats.get(n - 1);
        double d5 = (Double)this.longs.get(n - 1);
        double d6 = (Double)this.bearings.get(n - 1);
        double d7 = (d3 - (Double)this.accDists.get(n - 1)) / 6371000.0;
        return Math.asin(Math.sin(d4) * Math.cos(d7) + Math.cos(d4) * Math.sin(d7) * Math.cos(d6)) / Math.PI * 180.0;
    }

    public double getCurrentLongitude() {
        int n;
        double d;
        double d2 = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double d3 = this.speedInMps * d2;
        if (d3 >= (d = ((Double)this.accDists.get(this.accDists.size() - 1)).doubleValue())) {
            if (this.circle) {
                while (d3 >= d) {
                    d3 -= d;
                }
            } else {
                this.finished = true;
                return (Double)this.lats.get(this.lats.size() - 1) / Math.PI * 180.0;
            }
        }
        for (n = this.accDists.size() - 1; n >= 0 && !(d3 >= (Double)this.accDists.get(n - 1)); --n) {
        }
        double d4 = (Double)this.lats.get(n - 1);
        double d5 = (Double)this.longs.get(n - 1);
        double d6 = (Double)this.bearings.get(n - 1);
        double d7 = (d3 - (Double)this.accDists.get(n - 1)) / 6371000.0;
        return (d5 + Math.atan2(Math.sin(d6) * Math.sin(d7) * Math.cos(d4), Math.cos(d7) - Math.sin(d4) * Math.sin(d4))) / Math.PI * 180.0;
    }

    public boolean finished() {
        return this.finished;
    }

    private double readNumeric(StreamTokenizer streamTokenizer, String string) throws ParseException, IOException {
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals(string)) {
            throw new ParseException("\"" + string + "\" expected", streamTokenizer.lineno());
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            throw new ParseException("numeric value expected", streamTokenizer.lineno());
        }
        double d = streamTokenizer.nval;
        streamTokenizer.nextToken();
        return d;
    }

    private static double getDistance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = Math.sin(d5 / 2.0) * Math.sin(d5 / 2.0) + Math.cos(d) * Math.cos(d3) * Math.sin(d6 / 2.0) * Math.sin(d6 / 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        double d9 = 6371000.0 * d8;
        return d9;
    }

    private static double getBearing(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.atan2(Math.sin(d6) * Math.cos(d3), Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d6));
        return d7;
    }

    public PointListMoveSpec(StreamTokenizer streamTokenizer) throws ParseException, IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.accDists.add(new Double(0.0));
        for (int i = 1; i <= 2; ++i) {
            d = d3;
            d2 = d4;
            d3 = this.readNumeric(streamTokenizer, "latitude") / 180.0 * Math.PI;
            this.lats.add(new Double(d3));
            d4 = this.readNumeric(streamTokenizer, "longitude") / 180.0 * Math.PI;
            this.longs.add(new Double(d4));
        }
        double d5 = PointListMoveSpec.getDistance(d3, d4, d, d2);
        this.accDists.add(new Double(d5));
        this.bearings.add(new Double(PointListMoveSpec.getBearing(d, d2, d3, d4)));
        Debug.noteln("bearing: " + PointListMoveSpec.getBearing(d, d2, d3, d4));
        while (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("latitude")) {
            d = d3;
            d2 = d4;
            d3 = this.readNumeric(streamTokenizer, "latitude") / 180.0 * Math.PI;
            this.lats.add(new Double(d3));
            d4 = this.readNumeric(streamTokenizer, "longitude") / 180.0 * Math.PI;
            this.longs.add(new Double(d4));
            this.accDists.add(new Double(d5 += PointListMoveSpec.getDistance(d3, d4, d, d2)));
            this.bearings.add(new Double(PointListMoveSpec.getBearing(d, d2, d3, d4)));
        }
        double d6 = this.readNumeric(streamTokenizer, "speed");
        if (streamTokenizer.ttype != -3) {
            throw new ParseException("unit for speed expected", streamTokenizer.lineno());
        }
        if (streamTokenizer.sval.equals("mps")) {
            this.speedInMps = d6;
        } else if (streamTokenizer.sval.equals("kmph")) {
            this.speedInMps = d6 / 3.6;
        } else {
            throw new ParseException("unknown unit for spped", streamTokenizer.lineno());
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals("stop") && !streamTokenizer.sval.equals("circle")) {
            throw new ParseException("\"stop\" or \"circle\" expected", streamTokenizer.lineno());
        }
        if (streamTokenizer.sval.equals("circle")) {
            this.circle = true;
            d = d3;
            d2 = d4;
            d3 = (Double)this.lats.get(0);
            this.lats.add(this.lats.get(0));
            d4 = (Double)this.longs.get(0);
            this.longs.add(this.longs.get(0));
            this.accDists.add(new Double(d5 += PointListMoveSpec.getDistance(d3, d4, d, d2)));
            this.bearings.add(new Double(PointListMoveSpec.getBearing(d, d2, d3, d4)));
        }
        streamTokenizer.nextToken();
    }

    private void jbInit() throws Exception {
    }
}

