/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.dynamic;

import ix.isim.dynamic.BearingMoveSpec;
import ix.isim.dynamic.MoveSpec;
import ix.isim.dynamic.ObjectAnimator;
import ix.isim.dynamic.PointListMoveSpec;
import ix.util.Debug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class AnimatedObject
extends Thread {
    static final int displayRes = 72;
    static final double screenDotSize = 3.4722222222222224E-4;
    static final int iniScale = 2000000;
    private String symName;
    private List receivers = new LinkedList();
    private MoveSpec animation;
    private boolean terminationFlag = false;
    private int msgDelay;

    public void useScale(int n) {
        double d = 3.4722222222222224E-4 * (double)n;
        this.msgDelay = (int)(1000.0 * (d / this.animation.getSpeed()));
    }

    public void run() {
        Debug.noteln("starting animation for " + this.symName);
        this.animation.reset();
        while (!this.animation.finished() && !this.getTerminationFlag()) {
            double d = this.animation.getCurrentLatitude();
            double d2 = this.animation.getCurrentLongitude();
            for (String string : this.receivers) {
                ObjectAnimator.sendConstraint("latitude", this.symName, d, string);
                ObjectAnimator.sendConstraint("longitude", this.symName, d2, string);
            }
            try {
                AnimatedObject.sleep(this.msgDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Debug.noteln("animation for " + this.symName + " finished.");
    }

    public void terminate() {
        Debug.noteln("terminating animation for " + this.symName);
        this.setTerminationFlag();
    }

    private synchronized void setTerminationFlag() {
        this.terminationFlag = true;
    }

    private synchronized boolean getTerminationFlag() {
        return this.terminationFlag;
    }

    public String toString() {
        String string = "animate " + this.symName;
        ListIterator listIterator = this.receivers.listIterator();
        while (listIterator.hasNext()) {
            string = string + " receivedBy " + listIterator.next();
        }
        return string + ' ' + this.animation.toString();
    }

    private void readReceivers(StreamTokenizer streamTokenizer) throws ParseException, IOException {
        while (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("receivedBy")) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -3) {
                throw new ParseException("receiver name expected", streamTokenizer.lineno());
            }
            this.receivers.add(streamTokenizer.sval);
            streamTokenizer.nextToken();
        }
    }

    public AnimatedObject(StreamTokenizer streamTokenizer) throws ParseException, IOException {
        if (streamTokenizer.ttype != -3) {
            throw new ParseException("symbolic object name expected", streamTokenizer.lineno());
        }
        this.symName = streamTokenizer.sval;
        streamTokenizer.nextToken();
        this.readReceivers(streamTokenizer);
        if (streamTokenizer.ttype != -3) {
            throw new ParseException("movement spec expected", streamTokenizer.lineno());
        }
        if (streamTokenizer.sval.equals("from")) {
            streamTokenizer.nextToken();
            this.animation = new BearingMoveSpec(streamTokenizer);
        } else if (streamTokenizer.sval.equals("routed-via")) {
            streamTokenizer.nextToken();
            this.animation = new PointListMoveSpec(streamTokenizer);
        } else {
            throw new ParseException("movement spec expected", streamTokenizer.lineno());
        }
        this.useScale(2000000);
    }
}

