/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.actions;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.isim.ExecutableAction;
import ix.isim.SimulationException;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import java.util.Iterator;
import java.util.LinkedList;

public class SendConstraint
extends ExecutableAction {
    static final Symbol sendConstraintSy = Symbol.intern("send-constraint");
    static final Symbol worldStateSy = Symbol.intern("world-state");
    static final Symbol effectSy = Symbol.intern("effect");

    public void executeAction(MatchEnv matchEnv) throws SimulationException {
        if (!this.action.getActivity().getVerb().equals(sendConstraintSy)) {
            throw new SimulationException("Activity verb must be " + sendConstraintSy + ", not " + this.action.getActivity().getVerb());
        }
        Iterator iterator = this.action.getActivity().getParameters().iterator();
        Name name = Name.valueOf(iterator.next());
        String string = iterator.next().toString();
        LList lList = (LList)iterator.next();
        if (!worldStateSy.equals(lList.get(0)) || !effectSy.equals(lList.get(1))) {
            throw new SimulationException("Constraint must world-state effect!");
        }
        LinkedList<PatternAssignment> linkedList = new LinkedList<PatternAssignment>();
        linkedList.add(new PatternAssignment((LList)lList.get(2), lList.get(4)));
        Constraint constraint = new Constraint(worldStateSy, effectSy, linkedList);
        constraint.setSenderId(name);
        try {
            IPC.getCommunicationStrategy().sendObject(string, constraint);
        }
        catch (Exception exception) {
            throw new SimulationException("Unable to send message.");
        }
    }
}

