/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.domain.Refinement;
import ix.iface.util.ToolController;
import ix.isim.ExecutableAction;
import ix.isim.ISim;
import ix.isim.ISimEventsFrame;
import ix.isim.ISimTimer;
import ix.isim.ISimTimerException;
import ix.isim.SimulationException;
import ix.isim.TimedEvent;
import ix.isim.util.LongPriorityQueue;
import ix.isim.util.TreeOfListsLongPriorityQueue;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispFileReader;
import ix.util.lisp.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ISimEngine
extends Thread {
    static final Symbol executeWithSy = Symbol.intern("execute-with");
    protected ISim theISim;
    protected ISimEventsFrame simEventsFrame;
    private boolean waitingForEvents = true;
    private boolean simPaused = false;
    private long simStartTime = 0L;
    private LongPriorityQueue waitingEvents = new TreeOfListsLongPriorityQueue();
    private List activeEvents = new ArrayList();
    private List completedEvents = new ArrayList();

    public ISimEngine(ISim iSim) {
        this.theISim = iSim;
        this.simEventsFrame = new ISimEventsFrame(this);
        ToolController toolController = new ToolController("I-Sim Events"){

            public Object createTool() {
                return ISimEngine.this.simEventsFrame;
            }
        };
        this.theISim.addTool(toolController);
    }

    public long getSimStartTime() {
        return this.simStartTime;
    }

    public void loadTimedEvents(File[] fileArray) {
        TimedEventsLoader timedEventsLoader = new TimedEventsLoader(fileArray);
        timedEventsLoader.start();
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void reactivateEventQueue(TimedEvent timedEvent) {
        if (this.waitingForEvents) {
            this.waitingForEvents = false;
            this.notify();
        } else if (this.waitingEvents.getLowestFront() == timedEvent) {
            this.interrupt();
        }
        Thread.currentThread();
        Thread.yield();
    }

    public void startSimulation(long l, double d) {
        this.simStartTime = l;
        ISimTimer iSimTimer = this.theISim.getISimTimer();
        try {
            iSimTimer.start(l, d);
            this.start();
            Thread.currentThread();
            Thread.yield();
            this.updateUI();
        }
        catch (ISimTimerException iSimTimerException) {
            iSimTimerException.printStackTrace();
        }
    }

    protected synchronized void updateUI() {
        this.simEventsFrame.makeRowsFromQueue(this.completedEvents, this.activeEvents, this.waitingEvents);
    }

    protected synchronized void updateStatus(TimedEvent timedEvent, int n) {
        Debug.noteln(TimedEvent.statusString[n] + ": " + timedEvent);
        switch (n) {
            case 1: {
                this.activeEvents.add(timedEvent);
                break;
            }
            case 2: 
            case 3: {
                this.activeEvents.remove(timedEvent);
                this.completedEvents.add(timedEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        timedEvent.setStatus(n);
        this.simEventsFrame.eventsTableModel.eventUpdated(timedEvent);
        Thread.currentThread();
        Thread.yield();
    }

    public synchronized void pauseSimulation() {
        this.simPaused = true;
        this.interrupt();
    }

    public synchronized void resumeSimulation() {
        this.simPaused = false;
        this.interrupt();
    }

    public synchronized void clearAllWaitingEvents() {
        this.waitingEvents = new TreeOfListsLongPriorityQueue();
        this.interrupt();
        this.updateUI();
    }

    public synchronized void executeNextEvent() {
        TimedEvent timedEvent = (TimedEvent)this.waitingEvents.getLowestFront();
        timedEvent.setRelativeTime(this.theISim.getISimTimer().getSimTimeInMillis() - this.simStartTime);
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ISimTimer iSimTimer = this.theISim.getISimTimer();
        while (true) {
            Object object;
            if (this.simPaused || this.waitingForEvents) {
                try {
                    object = this;
                    synchronized (object) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.waitingEvents.isEmpty()) {
                Debug.noteln("No events to simulate. Waiting ...");
                this.waitingForEvents = true;
                continue;
            }
            this.yield();
            if (this.simPaused) continue;
            object = (TimedEvent)this.waitingEvents.getLowestFront();
            long l = (long)((double)(this.simStartTime + ((TimedEvent)object).timeInMillis - iSimTimer.getSimTimeInMillis()) / iSimTimer.getAccelerationFactor());
            if (l > 0L) {
                try {
                    ISimEngine.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            this.yield();
            ISimEngine iSimEngine = this;
            synchronized (iSimEngine) {
                object = (TimedEvent)this.waitingEvents.removeLowestFront();
                this.updateStatus((TimedEvent)object, 1);
                try {
                    Refinement refinement = this.theISim.getDomain().getNamedRefinement(((TimedEvent)object).event.getVerb().toString());
                    if (refinement == null) {
                        throw new SimulationException("No executable refinement with name " + ((TimedEvent)object).event.getVerb());
                    }
                    Symbol symbol = (Symbol)refinement.getAnnotation(executeWithSy);
                    if (symbol == null) {
                        throw new SimulationException("No ExecutableAction class specified for " + refinement.getName());
                    }
                    ExecutableAction executableAction = (ExecutableAction)Class.forName(symbol.toString()).newInstance();
                    executableAction.simulate((TimedEvent)object, refinement);
                    this.yield();
                }
                catch (SimulationException simulationException) {
                    simulationException.printStackTrace();
                    this.updateStatus((TimedEvent)object, 3);
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    this.updateStatus((TimedEvent)object, 3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    this.updateStatus((TimedEvent)object, 3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    this.updateStatus((TimedEvent)object, 3);
                }
                this.yield();
            }
        }
    }

    private class TimedEventsLoader
    extends Thread {
        File[] eventFiles;

        public TimedEventsLoader(File[] fileArray) {
            this.eventFiles = fileArray;
        }

        public void run() {
            ISimTimer iSimTimer = ISimEngine.this.theISim.getISimTimer();
            for (int i = 0; i < this.eventFiles.length; ++i) {
                try {
                    String string = this.eventFiles[i].getName();
                    string = string.substring(0, string.length() - 4);
                    LispFileReader lispFileReader = new LispFileReader(this.eventFiles[i]);
                    this.readEventFile(lispFileReader, string, iSimTimer);
                    lispFileReader.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (SimulationException simulationException) {
                    simulationException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.yield();
            }
            ISimEngine.this.updateUI();
        }

        private void readEventFile(LispFileReader lispFileReader, String string, ISimTimer iSimTimer) throws ParseException, SimulationException {
            Object object;
            while ((object = lispFileReader.readObject()) != Lisp.EOF) {
                LList lList = ISimEngine.this.theISim.getModelManager().putVariablesInPattern((LList)object);
                TimedEvent timedEvent = TimedEvent.getTimedEvent(lList);
                timedEvent.setThread(string);
                if (iSimTimer.simulationStarted()) {
                    timedEvent.timeInMillis += iSimTimer.getSimTimeInMillis() - ISimEngine.this.simStartTime + 1L;
                }
                this.yield();
                this.queueTimedEvent(timedEvent);
            }
        }

        private void queueTimedEvent(TimedEvent timedEvent) {
            ISimTimer iSimTimer = ISimEngine.this.theISim.getISimTimer();
            if (iSimTimer.simulationStarted() && iSimTimer.getSimTimeInMillis() - ISimEngine.this.simStartTime - timedEvent.timeInMillis > 1000L) {
                Debug.noteln("Adding event in the past: " + timedEvent);
            }
            ISimEngine.this.waitingEvents.addElementAtEnd(timedEvent, timedEvent.timeInMillis);
            if (!ISimEngine.this.simPaused) {
                ISimEngine.this.reactivateEventQueue(timedEvent);
            }
            this.yield();
        }
    }
}

