/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.AdviceManager;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.iplan.Alternative;
import ix.iplan.Slip;
import ix.iplan.SlipAchieveConds;
import ix.iplan.SlipAchiever;
import ix.iplan.SlipExpandNode;
import ix.iplan.SlipExpander;
import ix.iplan.SlipSatisfyConds;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListIterator;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class SlipFindExecutable
implements Runnable {
    Slip slip;

    SlipFindExecutable(Slip slip) {
        this.slip = slip;
    }

    public void run() {
        LList lList = this.getNodeEnds();
        this.findNext(lList, this.endIterator(lList));
    }

    void findNext(LList lList, LListIterator lListIterator) {
        while (true) {
            List list;
            Object object;
            PNodeEnd pNodeEnd = this.nextStatusExecutable(lListIterator);
            Debug.noteln("SlipFindExecutable considering", pNodeEnd);
            if (pNodeEnd.getEnd() == End.END) {
                if (!this.canComplete(pNodeEnd)) continue;
                this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                this.executeNodeEnd(pNodeEnd);
                lListIterator = this.endIterator(lList);
                continue;
            }
            PNode pNode = pNodeEnd.getNode();
            if (this.slip.isGoalNode(pNodeEnd)) {
                Debug.noteln("Examining goal node", pNodeEnd);
                object = this.slip.getGoalCond(pNodeEnd);
                list = new LinkedListOfConstraint();
                list.add(this.makeCondition((PatternAssignment)object));
                Debug.noteln("Goal cond", object);
                List list2 = this.slip.MM().evalFilters((ListOfConstraint)list, new MatchEnv());
                if (!list2.isEmpty()) {
                    Debug.noteln("Envs for goal cond", list2);
                    this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                    List list3 = this.slip.MM().reevaluateFilters((ListOfConstraint)list);
                    Debug.expect(!list3.isEmpty(), "Cannot match goal", object);
                    this.slip.setStatus(pNode.getEnd(), Status.COMPLETE);
                    ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
                    Agenda agenda = this.slip.getController().getActivityAgenda();
                    Debug.noteln("Deleting goal node", activityItem);
                    agenda.removeItem(activityItem);
                    lList = this.getNodeEnds();
                    lListIterator = this.endIterator(lList);
                    continue;
                }
                Debug.expect(!pNode.isExpanded());
            }
            if (this.isAlreadyExpanded(pNodeEnd)) {
                Debug.noteln("Is already expanded");
                object = this.slip.MM().getNodeConditions(pNode);
                if (object == null || object.isEmpty()) {
                    Debug.noteln("No conditions");
                    this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                    this.slip.setStatus(pNodeEnd, Status.COMPLETE);
                    lListIterator = this.endIterator(lList);
                    continue;
                }
                list = this.slip.MM().evalFilters((ListOfConstraint)object, new MatchEnv());
                Debug.noteln("Conditions", object);
                Debug.noteln("Envs", list);
                if (list.isEmpty()) {
                    Debug.noteln("Cannot satisfy conds");
                    if (this.slip.isWaitingForAchieve(pNode) || !this.mightAchieveConds((ListOfConstraint)object)) continue;
                    this.postSatisfyByAchieveAlt(pNode, (ListOfConstraint)object);
                    continue;
                }
                this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                this.satisfyNodeEndConds(pNodeEnd, (ListOfConstraint)object, list);
                lListIterator = this.endIterator(lList);
                continue;
            }
            Debug.noteln("Trying refinements");
            object = new LinkedList();
            list = new LinkedList();
            if (!this.nodeExpanders(pNodeEnd, (LinkedList)object, (LinkedList)list)) {
                Debug.noteln("No refinements apply");
                this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                this.slip.setStatus(pNodeEnd, Status.COMPLETE);
                lListIterator = this.endIterator(lList);
                continue;
            }
            if (!((AbstractCollection)object).isEmpty()) {
                Debug.noteln("Can expand");
                this.postFindNextAlt(pNodeEnd, lList, lListIterator);
                if (!((AbstractCollection)((Object)list)).isEmpty()) {
                    this.postExpandLaterAlt(pNode, (LinkedList)list);
                }
                this.slip.setNextStep(new SlipExpandNode(this.slip, pNode, (LinkedList)object));
                return;
            }
            if (!((AbstractCollection)((Object)list)).isEmpty()) {
                this.postExpandLaterAlt(pNode, (LinkedList)list);
            }
            Debug.noteln("No refinement can expand now");
        }
    }

    void postFindNextAlt(PNodeEnd pNodeEnd, LList lList, LListIterator lListIterator) {
        LListListIterator lListListIterator;
        PNodeEnd pNodeEnd2;
        if (lListIterator.hasNext() && (pNodeEnd2 = this.slip.findExecutable(lListListIterator = new LListListIterator(lListIterator.getTail()))) != null) {
            lListListIterator.previous();
            this.slip.postAlternative(new Resume(lList, lListListIterator));
        }
    }

    Constraint makeCondition(PatternAssignment patternAssignment) {
        return new Constraint(Refinement.S_WORLD_STATE, Refinement.S_CONDITION, (List)Lisp.list(patternAssignment));
    }

    void satisfyNodeEndConds(PNodeEnd pNodeEnd, ListOfConstraint listOfConstraint, List list) {
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        if (list.size() == 1) {
            this.slip.MM().satisfyConds(agendaItem, listOfConstraint, (MatchEnv)list.get(0));
            this.slip.setStatus(pNodeEnd, Status.COMPLETE);
            return;
        }
        LinkedList linkedList = (LinkedList)list;
        MatchEnv matchEnv = (MatchEnv)linkedList.removeFirst();
        SlipSatisfyConds slipSatisfyConds = new SlipSatisfyConds(this.slip);
        slipSatisfyConds.getClass();
        this.slip.postAlternative(new SlipSatisfyConds.ResumeSatisfaction(slipSatisfyConds, agendaItem, listOfConstraint, linkedList));
        this.slip.MM().satisfyConds(agendaItem, listOfConstraint, matchEnv);
        this.slip.setStatus(pNodeEnd, Status.COMPLETE);
    }

    void postSatisfyByAchieveAlt(PNode pNode, ListOfConstraint listOfConstraint) {
        this.slip.postAlternative(new SatisfyByAchieveAlt(pNode, listOfConstraint));
    }

    boolean mightAchieveConds(ListOfConstraint listOfConstraint) {
        boolean bl = false;
        for (Constraint constraint : listOfConstraint) {
            if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            if (this.condMightBeAchieved(patternAssignment)) {
                bl = true;
                continue;
            }
            if (this.worldStateSatisfiesCond(constraint)) continue;
            return false;
        }
        return bl;
    }

    boolean worldStateSatisfiesCond(Constraint constraint) {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        linkedListOfConstraint.add(constraint);
        List list = this.slip.MM().evalFilters(linkedListOfConstraint, new MatchEnv());
        return !list.isEmpty();
    }

    boolean condMightBeAchieved(PatternAssignment patternAssignment) {
        return this.slip.existsAchieversForCond(patternAssignment);
    }

    LList getNodeEnds() {
        return LList.newLList(this.slip.MM().getNodeEnds());
    }

    LListIterator endIterator(LList lList) {
        if (!this.slip.domainSays("iplan-try-pointless-permutations")) {
            this.executeTrivialEnds(lList);
        }
        return (LListIterator)lList.iterator();
    }

    void executeTrivialEnds(LList lList) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (PNodeEnd pNodeEnd : lList) {
                if (this.slip.getStatus(pNodeEnd) != Status.POSSIBLE || !this.isTrivial(pNodeEnd)) continue;
                Debug.noteln("Pre-executing", pNodeEnd);
                this.slip.setStatus(pNodeEnd, Status.COMPLETE);
                bl = true;
            }
        }
    }

    boolean isTrivial(PNodeEnd pNodeEnd) {
        PNode pNode = pNodeEnd.getNode();
        if (pNodeEnd.getEnd() == End.BEGIN) {
            ListOfConstraint listOfConstraint = this.slip.MM().getNodeConditions(pNode);
            return (listOfConstraint == null || listOfConstraint.isEmpty()) && !this.slip.isGoalNode(pNodeEnd) && !this.someRefinementApplies(pNode);
        }
        List list = this.slip.MM().getNodeEffects(pNode);
        return list == null || list.isEmpty();
    }

    boolean someRefinementApplies(PNode pNode) {
        LList lList = pNode.getPattern();
        for (Refinement refinement : this.slip.getDomain().getRefinements()) {
            if (!this.refinementApplies(refinement, lList)) continue;
            return true;
        }
        return false;
    }

    boolean refinementApplies(Refinement refinement, LList lList) {
        int n;
        LList lList2 = refinement.getPattern();
        if (!lList2.car().equals(lList.car())) {
            return false;
        }
        int n2 = lList2.length();
        return n2 == (n = lList.length()) || n2 - 2 <= n && lList2.contains(Matcher.REST);
    }

    PNodeEnd nextStatusExecutable(Iterator iterator) {
        PNodeEnd pNodeEnd = this.slip.findExecutable(iterator);
        if (pNodeEnd == null) {
            if (this.slip.planIsComplete()) {
                throw new Slip.HavePlanException();
            }
            throw this.slip.poison("no executable node-end");
        }
        return pNodeEnd;
    }

    boolean canComplete(PNodeEnd pNodeEnd) {
        PNode pNode = pNodeEnd.getNode();
        List list = this.slip.MM().getNodeEffects(pNode);
        if (list == null) {
            return true;
        }
        Set set = Variable.varsAnywhereIn(list);
        Set set2 = Variable.unboundVarsIn(set);
        return set2.isEmpty();
    }

    void executeNodeEnd(PNodeEnd pNodeEnd) {
        PNode pNode = pNodeEnd.getNode();
        List list = this.slip.MM().getNodeEffects(pNode);
        if (list != null) {
            this.slip.MM().handleEffects(pNode, list);
        }
        this.slip.setStatus(pNodeEnd, Status.COMPLETE);
    }

    boolean isAlreadyExpanded(PNodeEnd pNodeEnd) {
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        PNode pNode = pNodeEnd.getNode();
        if (pNode.isExpanded()) {
            Debug.expect(!this.slip.isGoalNode(pNodeEnd));
            return true;
        }
        Debug.expect(pNode.getChildren().isEmpty(), "Has children when not expanded", pNode);
        Debug.expect(Collect.isEmpty(this.slip.MM().getNodeConditions(pNode)), "Has conds when not expanded", pNode);
        return false;
    }

    boolean nodeExpanders(PNodeEnd pNodeEnd, LinkedList linkedList, LinkedList linkedList2) {
        if (this.slip.isGoalNode(pNodeEnd)) {
            return this.goalExpanders(pNodeEnd, linkedList, linkedList2);
        }
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        boolean bl = false;
        AdviceManager adviceManager = this.slip.MM().getAdviceManager();
        for (Refinement refinement : this.slip.getDomain().getRefinements()) {
            LList lList = agendaItem.getPattern();
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), lList);
            if (matchEnv == null || !adviceManager.isUsableRefinement(refinement)) {
                bl = bl || this.refinementApplies(refinement, lList);
                continue;
            }
            if (Collect.isEmpty(refinement.getNodes()) && Collect.isEmpty(refinement.getConstraints())) {
                linkedList.add(this.makeManualExpander(agendaItem, refinement, matchEnv));
                continue;
            }
            Object object = this.makeExpander(agendaItem, refinement, matchEnv);
            if (object != null) {
                linkedList.add(object);
                continue;
            }
            object = this.makeLaterExpander(agendaItem, refinement, matchEnv);
            if (object != null) {
                linkedList2.add(object);
                continue;
            }
            bl = true;
        }
        return bl || !linkedList.isEmpty() || !linkedList2.isEmpty();
    }

    boolean goalExpanders(PNodeEnd pNodeEnd, LinkedList linkedList, LinkedList linkedList2) {
        AgendaItem agendaItem = (AgendaItem)pNodeEnd.getNode();
        List list = this.slip.getGoalAchievers(agendaItem);
        for (SlipAchiever slipAchiever : list) {
            Refinement refinement = slipAchiever.refinement;
            Debug.expect(!Collect.isEmpty(refinement.getConstraints()));
            MatchEnv matchEnv = slipAchiever.rematchCond();
            if (matchEnv == null) {
                Debug.noteln("Can't use " + slipAchiever + " for goal " + agendaItem + " because " + slipAchiever.condMatchEnv + " no longer applies");
                continue;
            }
            Object object = this.makeExpander(agendaItem, refinement, matchEnv);
            if (object != null) {
                linkedList.add(object);
                continue;
            }
            object = this.makeLaterExpander(agendaItem, refinement, matchEnv);
            if (object != null) {
                linkedList2.add(object);
                continue;
            }
            Debug.noteln("Can't use " + slipAchiever + " for goal " + agendaItem);
        }
        if (linkedList.isEmpty() && linkedList2.isEmpty()) {
            Debug.noteln("Cannot expand goal", agendaItem);
        }
        return true;
    }

    Object makeManualExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        Cons cons = Lisp.list(matchEnv);
        return new SlipExpander(this.slip, agendaItem, refinement, matchEnv, cons);
    }

    Object makeExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        boolean bl;
        MatchEnv matchEnv2 = matchEnv;
        ListOfConstraint listOfConstraint = refinement.getFilterConstraints();
        List list = listOfConstraint.isEmpty() ? Collections.EMPTY_LIST : this.slip.MM().evalFilters(listOfConstraint, matchEnv2);
        boolean bl2 = bl = listOfConstraint.isEmpty() || !list.isEmpty();
        if (bl) {
            return new SlipExpander(this.slip, agendaItem, refinement, matchEnv2, list);
        }
        return null;
    }

    Object makeLaterExpander(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
        if (!this.slip.isWaitingForAchieve(agendaItem) && this.mightAchieveConds(refinement.getFilterConstraints())) {
            return new SlipExpander(this.slip, agendaItem, refinement, matchEnv, null);
        }
        return null;
    }

    void postExpandLaterAlt(PNode pNode, LinkedList linkedList) {
        this.slip.postAlternative(new ExpandLaterAlt(pNode, linkedList));
    }

    class ExpandLaterAlt
    extends Alternative {
        PNode node;
        LinkedList useLater;

        ExpandLaterAlt(PNode pNode, LinkedList linkedList) {
            this.node = pNode;
            this.useLater = linkedList;
        }

        public void run() {
            SlipFindExecutable.this.slip.setNextStep(new SlipExpandNode(SlipFindExecutable.this.slip, this.node, this.useLater));
        }
    }

    class SatisfyByAchieveAlt
    extends Alternative {
        PNode node;
        ListOfConstraint conds;

        SatisfyByAchieveAlt(PNode pNode, ListOfConstraint listOfConstraint) {
            this.node = pNode;
            this.conds = listOfConstraint;
        }

        public void run() {
            SlipFindExecutable.this.slip.setNextStep(new SlipAchieveConds(SlipFindExecutable.this.slip, this.node, this.conds));
        }
    }

    class Resume
    extends Alternative {
        LList allNodeEnds;
        LListIterator nodeEndIter;

        Resume(LList lList, LListIterator lListIterator) {
            this.allNodeEnds = lList;
            this.nodeEndIter = lListIterator;
        }

        public void run() {
            SlipFindExecutable.this.findNext(this.allNodeEnds, this.nodeEndIter);
        }
    }
}

