/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.domain.ListOfConstraint;
import ix.icore.process.PNode;
import ix.ip2.ActivityItem;
import ix.iplan.Alternative;
import ix.iplan.Slip;
import ix.iplan.SlipAchieveConds;
import ix.iplan.SlipExpander;
import ix.iplan.SlipFindExecutable;
import ix.iplan.SlipSatisfyConds;
import ix.util.Debug;
import java.util.LinkedList;

class SlipExpandNode
implements Runnable {
    Slip slip;
    PNode node;
    LinkedList expanders;

    SlipExpandNode(Slip slip, PNode pNode, LinkedList linkedList) {
        this.slip = slip;
        this.node = pNode;
        this.expanders = linkedList;
    }

    public void run() {
        this.nextExpansion();
    }

    void nextExpansion() {
        SlipExpander slipExpander = this.getValidExpander();
        if (!this.expanders.isEmpty()) {
            this.slip.postAlternative(new Resume());
        }
        slipExpander.doExpansion();
        if (this.slip.isGoalNode(this.node.getBegin())) {
            this.fixupGoalNode(this.node);
        }
        ListOfConstraint listOfConstraint = this.node.getRefinement().getFilterConstraints();
        Debug.noteln("Instantiated conds", listOfConstraint);
        if (listOfConstraint.isEmpty()) {
            this.slip.setStatus(this.node.getBegin(), Status.COMPLETE);
            this.slip.setNextStep(new SlipFindExecutable(this.slip));
            return;
        }
        if (slipExpander.isExpandLater()) {
            this.slip.setNextStep(new SlipAchieveConds(this.slip, this.node, listOfConstraint));
        } else {
            this.slip.setNextStep(new SlipSatisfyConds(this.slip, this.node, listOfConstraint));
        }
    }

    private SlipExpander getValidExpander() {
        while (!this.expanders.isEmpty()) {
            SlipExpander slipExpander = (SlipExpander)this.expanders.removeFirst();
            if (slipExpander.isStillValid()) {
                return slipExpander;
            }
            Debug.noteln("Rejected expander", slipExpander);
        }
        throw this.slip.poison("No valid expanders for " + this.node);
    }

    void fixupGoalNode(PNode pNode) {
        ActivityItem activityItem = (ActivityItem)pNode;
        Debug.noteln("Fixing up", activityItem);
        this.slip.normalizeGoalNode(activityItem);
        Debug.noteln("Item is now", activityItem);
    }

    class Resume
    extends Alternative {
        Resume() {
        }

        public void run() {
            SlipExpandNode.this.nextExpansion();
        }
    }
}

