/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.domain.Domain;
import ix.iplan.Slip;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.owls.PlanToOWLS;
import ix.util.owls.ProcessWriter;
import ix.util.owls.ServiceTranslator;
import ix.util.xml.XML;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mindswap.owls.service.Service;

public class PlanWithOWLS
extends Slip {
    public PlanWithOWLS(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-Plan with OWL-S");
        PlanWithOWLS planWithOWLS = new PlanWithOWLS(true);
        planWithOWLS.mainStartup(stringArray);
        planWithOWLS.plan();
        planWithOWLS.outputPlan();
        planWithOWLS.outputOwlSPlan();
        planWithOWLS.exit();
    }

    protected void readDomain(Domain domain) {
        Object object;
        super.readDomain(domain);
        String string = Parameters.getParameter("service-list");
        if (string != null) {
            if (string.endsWith(".owls")) {
                object = new ServiceTranslator();
                Domain domain2 = ((ServiceTranslator)object).readServiceDomain(string);
                domain.takeFrom(domain2);
            } else {
                object = (Domain)XML.readObject(Domain.class, string);
                domain.takeFrom((Domain)object);
            }
        }
        if ((object = Parameters.getParameter("domain-out")) != null) {
            XML.writeObject(domain, (String)object);
        }
    }

    protected void outputOwlSPlan() {
        String string = Parameters.getParameter("owls-out");
        if (string == null) {
            return;
        }
        PlanToOWLS planToOWLS = new PlanToOWLS(this);
        Service service = planToOWLS.planToService();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            ProcessWriter processWriter = new ProcessWriter();
            processWriter.write(service, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new RethrownException(iOException);
        }
    }
}

