/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.ip2.Ip2;
import ix.iplan.ErrorPlanEvaluation;
import ix.iplan.PlanEvaluation;
import ix.iplan.PlanEvaluator;
import ix.util.Debug;
import ix.util.StableHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlanEvalManager {
    protected List planEvaluators = new LinkedList();

    public PlanEvalManager() {
        this.addPlanEvaluators();
    }

    public void addPlanEvaluator(PlanEvaluator planEvaluator) {
        this.planEvaluators.add(planEvaluator);
    }

    public List getPlanEvaluators() {
        return this.planEvaluators;
    }

    public Map evaluatePlan(Ip2 ip2, String string) {
        Debug.noteln("Evaluating plan in agent", ip2);
        Debug.noteln("Evaluating plan in option", string);
        StableHashMap stableHashMap = new StableHashMap();
        for (PlanEvaluator planEvaluator : this.planEvaluators) {
            stableHashMap.put(planEvaluator, this.evalSafely(planEvaluator, ip2, string));
        }
        return stableHashMap;
    }

    public PlanEvaluation evalSafely(PlanEvaluator planEvaluator, Ip2 ip2, String string) {
        try {
            return planEvaluator.evaluatePlan(ip2, string);
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            return new ErrorPlanEvaluation(throwable);
        }
    }

    public void addPlanEvaluators() {
    }
}

