/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.IXAgent;
import ix.icore.plan.Plan;
import ix.iface.util.CheckTableDialog;
import ix.iface.util.IFUtil;
import ix.ip2.NewIp2Frame;
import ix.iplan.IPlanOptionManager;
import ix.iplan.event.OptionEvent;
import ix.iplan.event.OptionListener;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.XML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class OptionUI
implements ActionListener,
OptionListener {
    IPlanOptionManager optMan;
    JFrame frame;
    JMenu optionMenu;
    JMenu selectOptionMenu;
    JMenu clearOptionMenu;
    JMenu deleteOptionMenu;
    JMenuItem copyOptionItem;
    JMenuItem splitOptionItem;
    JMenuItem renameOptionItem;
    JMenuItem deleteOptionItem;
    JFileChooser directoryChooser;
    List savedSyncSelection = Collections.EMPTY_LIST;

    public OptionUI(IPlanOptionManager iPlanOptionManager, JFrame jFrame) {
        this.optMan = iPlanOptionManager;
        this.frame = jFrame;
        this.constructOptionMenu();
        this.optMan.addOptionListener(this);
    }

    public JMenu getOptionMenu() {
        return this.optionMenu;
    }

    void constructOptionMenu() {
        this.optionMenu = new JMenu("Options");
        this.selectOptionMenu = new JMenu("Select");
        this.optionMenu.add(this.selectOptionMenu);
        this.optionMenu.add(this.makeItem("New Option"));
        this.splitOptionItem = this.makeItem("Split X");
        this.optionMenu.add(this.splitOptionItem);
        this.copyOptionItem = this.makeItem("Copy X");
        this.optionMenu.add(this.copyOptionItem);
        this.renameOptionItem = this.makeItem("Rename X");
        this.optionMenu.add(this.renameOptionItem);
        this.clearOptionMenu = new JMenu("Clear X");
        this.optionMenu.add(this.clearOptionMenu);
        this.clearOptionMenu.add(this.makeItem("Clear All"));
        this.clearOptionMenu.add(this.makeItem("Clear All But State"));
        this.deleteOptionMenu = new JMenu("Delete");
        this.optionMenu.add(this.deleteOptionMenu);
        this.deleteOptionItem = this.makeItem("Delete X");
        this.deleteOptionMenu.add(this.deleteOptionItem);
        this.deleteOptionMenu.add(this.makeItem("Delete Selected Options"));
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.makeItem("Sync State"));
        this.optionMenu.add(this.makeItem("Preferences"));
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.makeItem("Load Options From ..."));
        this.optionMenu.add(this.makeItem("Save Options In ..."));
        this.splitOptionItem.setActionCommand("Split Option");
        this.copyOptionItem.setActionCommand("Copy Option");
        this.renameOptionItem.setActionCommand("Rename Option");
        this.deleteOptionItem.setActionCommand("Delete Option");
    }

    private JMenuItem makeItem(String string) {
        return IFUtil.makeMenuItem(string, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Option action:", string);
        if (string.equals("Select Option")) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText();
            Debug.noteln("Select option", string2);
            this.optMan.setOption(string2);
        } else if (string.equals("New Option")) {
            String string3 = JOptionPane.showInputDialog(this.frame, (Object)"Enter a name for the new option");
            if (string3 != null) {
                this.optMan.newOption(string3);
            }
        } else if (string.equals("Split Option")) {
            String string4 = Strings.beforeLast(" (", this.splitOptionItem.getText());
            this.checkOptionName(string4);
            this.optMan.splitOption();
        } else if (string.equals("Copy Option")) {
            this.checkOptionName(actionEvent);
            String string5 = JOptionPane.showInputDialog(this.frame, (Object)"Enter a name for the copy");
            if (string5 != null) {
                this.optMan.copyOption(string5);
            }
        } else if (string.equals("Rename Option")) {
            this.checkOptionName(actionEvent);
            String string6 = JOptionPane.showInputDialog(this.frame, (Object)"Enter a new name for the option");
            if (string6 != null) {
                this.optMan.renameOption(string6);
            }
        } else if (string.equals("Clear All")) {
            this.checkOptionName(this.clearOptionMenu.getText());
            if (Util.dialogConfirms(this.frame, "Are you sure you want to clear the option?")) {
                this.optMan.clearOption();
            }
        } else if (string.equals("Clear All But State")) {
            this.checkOptionName(this.clearOptionMenu.getText());
            if (Util.dialogConfirms(this.frame, "Are you sure you want to clear all but the option's state?")) {
                this.optMan.clearOptionAllButState();
            }
        } else if (string.equals("Delete Option")) {
            this.checkOptionName(actionEvent);
            if (Util.dialogConfirms(this.frame, "Are you sure you want to delete the option?")) {
                this.optMan.deleteOption();
            }
        } else if (string.equals("Delete Selected Options")) {
            this.deleteSelectedOptions();
        } else if (string.equals("Sync State")) {
            if (this.optMan.getNameToOptionMap().size() < 2) {
                Util.displayAndWait(this.frame, new String[]{"There is only one option, and so none to", "take state from the current option"});
            } else {
                this.syncSelectedOptions();
            }
        } else if (string.equals("Preferences")) {
            this.editPreferences();
        } else if (string.equals("Load Options From ...")) {
            this.loadOptions();
        } else if (string.equals("Save Options In ...")) {
            this.saveOptions();
        } else {
            throw new ConsistencyException("Unknown option command", string);
        }
    }

    private void checkOptionName(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        this.checkOptionName(jMenuItem.getText());
    }

    private void checkOptionName(String string) {
        String string2 = Strings.afterFirst(" ", string);
        Debug.expectEquals(string2, this.optMan.getOption().getName(), "The current option does not have the expected name.");
    }

    public void optionAdded(OptionEvent optionEvent) {
        this.populateSelectOptionMenu();
    }

    public void optionSet(OptionEvent optionEvent) {
        this.noticeCurrentOptionName(optionEvent);
    }

    public void optionRenamed(OptionEvent optionEvent, String string) {
        if (optionEvent.getOption() == this.optMan.getOption()) {
            this.noticeCurrentOptionName(optionEvent);
        }
        this.populateSelectOptionMenu();
    }

    public void optionContentsChanged(OptionEvent optionEvent, EventObject eventObject) {
        Debug.expectSame(this.optMan.getOption(), optionEvent.getOption());
        this.menuShowSplitDirection(optionEvent);
    }

    public void optionDeleted(OptionEvent optionEvent) {
        this.populateSelectOptionMenu();
    }

    void populateSelectOptionMenu() {
        JMenu jMenu = this.selectOptionMenu;
        jMenu.setEnabled(false);
        jMenu.removeAll();
        for (String string : this.optMan.getNameToOptionMap().keySet()) {
            JMenuItem jMenuItem = IFUtil.makeMenuItem(string, this);
            jMenuItem.setActionCommand("Select Option");
            jMenu.add(jMenuItem);
        }
        jMenu.setEnabled(true);
    }

    void noticeCurrentOptionName(OptionEvent optionEvent) {
        Debug.expectSame(this.optMan.getOption(), optionEvent.getOption());
        String string = optionEvent.getOptionName();
        this.menuShowSplitDirection(optionEvent);
        this.copyOptionItem.setText("Copy " + string);
        this.renameOptionItem.setText("Rename " + string);
        this.clearOptionMenu.setText("Clear " + string);
        this.deleteOptionItem.setText("Delete " + string);
        this.frameShowOptionName(string);
    }

    void menuShowSplitDirection(OptionEvent optionEvent) {
        String string = optionEvent.getOption().hasChanged() ? " (down)" : " (across)";
        this.splitOptionItem.setText("Split " + optionEvent.getOptionName() + string);
    }

    void frameShowOptionName(String string) {
        if (this.frame instanceof NewIp2Frame) {
            NewIp2Frame newIp2Frame = (NewIp2Frame)this.frame;
            newIp2Frame.optionLabel.setText(string);
        }
    }

    void deleteSelectedOptions() {
        String string = this.optMan.getOptionForInput().getName();
        Set set = this.optMan.getNameToOptionMap().keySet();
        LinkedList linkedList = new LinkedList(set);
        linkedList.remove(string);
        if (linkedList.isEmpty()) {
            String[] stringArray = new String[]{"There are no deletable options.  Remember that the", "option selected for input, " + string + ",", "cannot be deleted."};
            Util.displayAndWait(this.frame, stringArray);
            return;
        }
        Object[] objectArray = CheckTableDialog.showDialog(this.frame, "Options to delete", linkedList.toArray());
        this.optMan.deleteOptions(Arrays.asList(objectArray));
    }

    void syncSelectedOptions() {
        String string = this.optMan.getOption().getName();
        Set set = this.optMan.getNameToOptionMap().keySet();
        LinkedList linkedList = new LinkedList(set);
        linkedList.remove(string);
        this.savedSyncSelection = (List)Collect.intersection(linkedList, this.savedSyncSelection);
        Debug.expect(!linkedList.isEmpty(), "no syncable options");
        Object[] objectArray = CheckTableDialog.showDialog(this.frame, "Options to sync state from " + string, linkedList.toArray(), this.savedSyncSelection.toArray());
        this.savedSyncSelection = Arrays.asList(objectArray);
        this.optMan.syncState(this.savedSyncSelection);
    }

    void editPreferences() {
        this.editOptionForInput();
    }

    void editOptionForInput() {
        String string = this.optMan.getOptionForInput().getName();
        String string2 = this.askUserToSelectOption("Select the option to receive input", string);
        if (string2 != null) {
            this.optMan.setOptionForInput(string2);
        }
    }

    public String askUserToSelectOption(String string, String string2) {
        Object[] objectArray = this.optMan.getNameToOptionMap().keySet().toArray();
        Object object = JOptionPane.showInputDialog(this.frame, string, IXAgent.getAgent().getAgentDisplayName() + " Select Option", 3, null, objectArray, string2);
        return object == null ? null : (String)object;
    }

    void loadOptions() {
        if (this.directoryChooser == null) {
            this.directoryChooser = this.makeDirectoryChooser();
        }
        int n;
        while ((n = this.directoryChooser.showOpenDialog(this.frame)) == 0) {
            try {
                if (!this.loadOptions(this.directoryChooser.getSelectedFile())) continue;
                return;
            }
            catch (Throwable throwable) {
                Debug.displayException(throwable);
                continue;
            }
            break;
        }
        return;
    }

    private boolean loadOptions(File file) {
        Debug.noteln("Loading options from", file);
        String string = file.toString();
        SortedMap sortedMap = this.optMan.readPlans(string);
        ArrayList arrayList = new ArrayList(sortedMap.keySet());
        if (Util.dialogConfirms(this.frame, new String[]{Strings.foldLongLine("Found plans " + Strings.conjunction(arrayList) + "."), "", "Treat them as options?"})) {
            this.optMan.makeTopLevelOptions(string, sortedMap);
            return true;
        }
        return false;
    }

    JFileChooser makeDirectoryChooser() {
        String string = Parameters.getParameter("option-directory", System.getProperty("user.dir"));
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        return jFileChooser;
    }

    void saveOptions() {
        int n;
        if (this.directoryChooser == null) {
            this.directoryChooser = this.makeDirectoryChooser();
        }
        if ((n = this.directoryChooser.showSaveDialog(this.frame)) == 0) {
            File file = this.directoryChooser.getSelectedFile();
            this.saveOptions(file);
        }
    }

    void saveOptions(File file) {
        Debug.noteln("Saving options in", file);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".xml");
            }
        });
        if (fileArray == null) {
            throw new IllegalArgumentException(file + " does not name a directory");
        }
        Set set = this.optMan.getNameToOptionMap().keySet();
        Set set2 = (Set)Collect.intersection(this.fileNameSet(fileArray), set);
        Debug.noteln("Will overwrite", set2);
        if (!set2.isEmpty() && !Util.dialogConfirms(this.frame, Strings.foldLongLine("Saving options to " + file + " will overwite " + Strings.conjunction(new ArrayList(set2)) + ". " + " Continue?"))) {
            return;
        }
        SortedMap sortedMap = this.optMan.getOptionsAsPlans();
        for (Map.Entry entry : sortedMap.entrySet()) {
            String string = (String)entry.getKey();
            Plan plan = (Plan)entry.getValue();
            File file2 = new File(file, string + ".xml");
            if (file2.exists()) {
                Util.renameToBackup(file2);
            }
            Debug.noteln("Writing", file2);
            XML.writeObject(plan, file2.getPath());
        }
    }

    Set fileNameSet(File[] fileArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            treeSet.add(Strings.beforeLast(".", fileArray[i].getName()));
        }
        return treeSet;
    }
}

