/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.ip2.Ip2ModelManager;
import ix.ip2.Ip2WorldStateManager;
import ix.util.Debug;
import ix.util.context.ContextHashMap;
import ix.util.context.ContextMap;
import ix.util.context.ContextValue;
import ix.util.context.LLQueue;
import ix.util.context.TypedContextValue;
import ix.util.lisp.LList;
import ix.util.match.MatchEnv;
import java.util.List;

public class IPlanWorldStateManager
extends Ip2WorldStateManager {
    protected ContextMap patternToFactMap = new ContextHashMap();

    public IPlanWorldStateManager(Ip2ModelManager ip2ModelManager) {
        super(ip2ModelManager);
    }

    public void reset() {
        super.reset();
        this.patternToFactMap.clearCompletely();
    }

    public void clear() {
        super.clear();
        this.patternToFactMap.clear();
    }

    public void deleteEffect(PatternAssignment patternAssignment) {
        this.patternToFactMap.remove(patternAssignment.getPattern());
        super.deleteEffect(patternAssignment);
    }

    public void satisfyConds(PNode pNode, ListOfConstraint listOfConstraint, MatchEnv matchEnv) {
        Debug.noteln("Using env " + matchEnv + " to satisfy " + listOfConstraint + " at " + pNode);
        this.modelManager.bindVariables(matchEnv);
        listOfConstraint = (ListOfConstraint)Variable.removeAllVars(listOfConstraint);
        for (Constraint constraint : listOfConstraint) {
            if (constraint.getType() != Refinement.S_WORLD_STATE) continue;
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            Debug.noteln("Finding contrib for", patternAssignment);
            Debug.noteln("At", pNode);
            this.satisfy1Cond(patternAssignment.getPattern(), patternAssignment.getValue(), pNode);
        }
    }

    protected void satisfy1Cond(LList lList, Object object, PNode pNode) {
        Fact fact = (Fact)this.patternToFactMap.get(lList);
        Debug.expect(fact != null, "can't find a fact for", lList);
        Debug.expectEquals(object, fact.getValue(), "fact value doesn't match");
        PNode pNode2 = fact.getContributor();
        if (pNode2 == null) {
            Debug.noteln("No contributor so presumably initial state.");
        } else {
            pNode.getBegin().linkAfter(pNode2.getEnd());
        }
        fact.addUser(pNode);
    }

    protected void assign(LList lList, Object object, PNode pNode) {
        Fact fact = (Fact)this.patternToFactMap.get(lList);
        if (fact == null) {
            Debug.expect(this.worldStateMap.get(lList) == null);
            fact = new Fact(lList, object, pNode);
            this.patternToFactMap.put(lList, fact);
        } else if (fact.getValue().equals(object)) {
            PNode pNode2 = fact.getContributor();
            if (pNode2 != null && pNode != null && pNode2 != pNode) {
                pNode2.getEnd().linkBefore(pNode.getEnd());
            }
            fact.setContributor(pNode);
        } else {
            PNode pNode3 = fact.getContributor();
            if (pNode != null) {
                if (pNode3 != null && pNode3 != pNode) {
                    pNode3.getEnd().linkBefore(pNode.getEnd());
                }
                for (PNode pNode4 : fact.getUsers()) {
                    pNode4.getBegin().linkBefore(pNode.getEnd());
                }
            }
            fact.clearUsers();
            fact.setContributor(pNode);
            fact.setValue(object);
        }
        this.worldStateMap.put(lList, object);
    }

    protected static class Fact {
        protected LList pattern;
        protected ContextValue value = new ContextValue<Object>(null);
        protected ContextValue contributor = new TypedContextValue<Object>(PNode.class, null);
        protected LLQueue users = new LLQueue();

        public Fact() {
        }

        public Fact(LList lList, Object object, PNode pNode) {
            this.pattern = lList;
            this.value.set(object);
            this.contributor.set(pNode);
        }

        public LList getPattern() {
            return this.pattern;
        }

        public Object getValue() {
            return this.value.get();
        }

        public void setValue(Object object) {
            this.value.set(object);
        }

        public PNode getContributor() {
            return (PNode)this.contributor.get();
        }

        public void setContributor(PNode pNode) {
            this.contributor.set(pNode);
        }

        public List getUsers() {
            return this.users.contents();
        }

        public void addUser(PNode pNode) {
            this.users.add(pNode);
        }

        public void clearUsers() {
            this.users.clear();
        }
    }
}

