/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.IXAgent;
import ix.icore.Report;
import ix.icore.plan.Plan;
import ix.iface.util.Reporting;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.UndoException;
import ix.iplan.CombinedPlanChangeListener;
import ix.iplan.IPlanTool;
import ix.iplan.NoPlanException;
import ix.iplan.PlanEvalManager;
import ix.iplan.PlanEvaluation;
import ix.iplan.PlanEvaluator;
import ix.iplan.PlanStats;
import ix.iplan.PlannerBase;
import ix.iplan.Slip;
import ix.iplan.TechnicalPlanEvalManager;
import ix.iplan.event.OptionEvent;
import ix.iplan.event.OptionListener;
import ix.test.DigestSet;
import ix.util.AbstractUndoAction;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Gensym;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Predicate1;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.UndoAction;
import ix.util.Util;
import ix.util.context.Context;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class IPlanOptionManager {
    Ip2 ip2;
    SortedMap nameToOptionMap = new TreeMap();
    Opt currentOption;
    Opt optionForInput;
    boolean warnUserOfDelayedInput = true;
    boolean warnUserOfDelayedReport = true;
    boolean useOnlyOneOption = false;
    boolean planSplitsOption = Parameters.getBoolean("plan-splits-option", false);
    List optionListeners = new LinkedList();
    boolean noticePlanChangeEvents = true;
    int inUndoableTransaction = 0;
    boolean nowUndoing = false;
    Gensym.Generator nameGen = new Gensym.Generator();
    PlanEvalManager planEvalManager = new TechnicalPlanEvalManager();
    String contextDepartureReason = null;
    List specialInputQueue = null;

    public IPlanOptionManager(Ip2 ip2) {
        this.ip2 = ip2;
    }

    public List getPlanEvaluators() {
        return this.planEvalManager.getPlanEvaluators();
    }

    public void connectYourself() {
        new CombinedPlanChangeListener(){

            protected void eventReceived(EventObject eventObject) {
                IPlanOptionManager.this.planChangeEvent(eventObject);
            }
        }.connectYourself(this.ip2);
        this.ip2.addResetHook(new ResetHook());
    }

    void planChangeEvent(EventObject eventObject) {
        Debug.expect(this.currentOption != null, "State modified before there's a current option");
        if (this.noticePlanChangeEvents) {
            Debug.noteln("Option manager sees", eventObject);
            this.currentOption.noteChange(eventObject);
        } else {
            Debug.noteln("Option manager ignores", eventObject);
        }
    }

    Predicate1 makePlanFilter() {
        return Parameters.getBoolean("filter-duplicate-plans", true) ? new DigestSet.IsNewPredciate(new DigestSet()) : Fn.alwaysTrue;
    }

    public void initOneOption() {
        this.useOnlyOneOption = true;
        if (Parameters.haveParameter("option-directory")) {
            Debug.warn("The option-directory parameter is not supported by this agent.");
        }
        this.setInitialCurrentOption();
    }

    public void initOptions() {
        this.useOnlyOneOption = false;
        String string = Parameters.getParameter("option-directory");
        if (string == null) {
            this.setInitialCurrentOption();
        } else {
            if (Parameters.haveParameter("plan")) {
                Debug.warn("The plan and option-directory parameters should not be used together.");
            }
            this.loadOptions(string);
            String string2 = Parameters.getParameter("option-for-input");
            if (string2 != null) {
                Opt opt = (Opt)this.nameToOptionMap.get(string2);
                if (opt == null) {
                    opt = this.makeTopLevelOption(string2, null);
                }
                this.setInitialCurrentOption(opt);
            } else if (this.nameToOptionMap.isEmpty()) {
                this.setInitialCurrentOption();
            } else {
                String string3 = (String)this.nameToOptionMap.firstKey();
                Opt opt = (Opt)this.nameToOptionMap.get(string3);
                this.setInitialCurrentOption(opt);
            }
        }
    }

    void setInitialCurrentOption() {
        String string = Parameters.getParameter("option-for-input", "Option-1");
        this.setInitialCurrentOption(this.makeTopLevelOption(string, null));
    }

    void setInitialCurrentOption(Opt opt) {
        Debug.noteln("Setting initial current option to", opt);
        Debug.expect(this.currentOption == null, "initial current option set twice");
        opt.makeYourselfTheCurrentOption();
        this.checkContext();
        this.optionForInput = opt;
    }

    public void loadOptions(String string) {
        block2: {
            Debug.noteln("Reading options from", string);
            try {
                SortedMap sortedMap = this.readPlans(string);
                this.makeTopLevelOptions(string, sortedMap);
            }
            catch (Throwable throwable) {
                Debug.displayException("Problem reading options", throwable);
                if (Parameters.isInteractive()) break block2;
                throw new RethrownException(throwable);
            }
        }
    }

    void makeTopLevelOptions(String string, SortedMap sortedMap) {
        Debug.noteln("Option plans", sortedMap.keySet());
        List list = (List)Collect.intersection(new LinkedList(this.nameToOptionMap.keySet()), sortedMap.keySet());
        if (!list.isEmpty()) {
            throw new IllegalStateException("Some options in " + string + " have the same name as existing options: " + Strings.conjunction(list) + ".");
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            String string2 = (String)entry.getKey();
            Plan plan = (Plan)entry.getValue();
            this.makeTopLevelOption(string2, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Opt makeTopLevelOption(String string, Plan plan) {
        Ip2 ip2 = this.ip2;
        synchronized (ip2) {
            Opt opt;
            Context context = Context.getContext();
            try {
                Context.setContext(Context.rootContext);
                Context.pushContext();
                opt = new Opt(string, plan);
            }
            catch (Throwable throwable) {
                Context.setContext(context);
                throw throwable;
            }
            Context.setContext(context);
            return opt;
        }
    }

    public SortedMap getNameToOptionMap() {
        return this.nameToOptionMap;
    }

    Opt getOption(String string) {
        Opt opt = (Opt)this.nameToOptionMap.get(string);
        if (opt != null) {
            return opt;
        }
        throw new IllegalArgumentException("There is no option named " + Strings.quote(string));
    }

    String childName(String string, int n) {
        char c = string.charAt(string.length() - 1);
        return c == '-' || Character.isDigit(c) ? string + "." + n : string + "-" + n;
    }

    String parentName(String string) {
        for (int i = string.length() - 1; i > 0; --i) {
            char c = string.charAt(i);
            if (c != '.' && c != '-') continue;
            return string.substring(0, i);
        }
        throw new ConsistencyException("Can't find parent name for", string);
    }

    String nextSiblingName(String string) {
        int n = 1;
        String string2;
        while (!this.optionNameIsAvailable(string2 = this.childName(string, n))) {
            ++n;
        }
        return string2;
    }

    boolean optionNameIsAvailable(String string) {
        if (this.nameToOptionMap.containsKey(string)) {
            return false;
        }
        for (String string2 : this.nameToOptionMap.keySet()) {
            if (!string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    String wantOptionName(String string) {
        if (!this.optionNameIsAvailable(string)) {
            throw new IllegalArgumentException("The option name \"" + string + "\" has already been used.");
        }
        return string;
    }

    public Opt getOption() {
        this.checkContext();
        return this.currentOption;
    }

    public void setOption(String string) {
        this.setOption(this.getOption(string));
    }

    protected void setOption(Opt opt) {
        Debug.noteln("Setting option to", opt);
        Debug.expect(this.nameToOptionMap.values().contains(opt));
        this.checkContext();
        if (this.useOnlyOneOption) {
            Debug.expectSame(this.currentOption, opt);
        } else if (opt == this.currentOption) {
            Debug.noteln(opt + " is already current");
            return;
        }
        opt.makeYourselfTheCurrentOption();
        this.checkContext();
    }

    Context departContext(String string) {
        Context context = Context.getContext();
        Debug.noteln("Departing " + context + " because " + string);
        this.contextDepartureReason = string;
        return context;
    }

    void restoreContext(Context context) {
        Context.setContext(context);
        Debug.noteln("Returning to " + context + " after " + this.contextDepartureReason);
        this.contextDepartureReason = null;
        if (this.specialInputQueue != null) {
            this.deliverEnqueuedInput();
        }
    }

    void enqueueInput(IPC.InputMessage inputMessage) {
        Debug.noteln("Specially delayed input", inputMessage.getContents());
        if (this.specialInputQueue == null) {
            this.specialInputQueue = new LinkedList();
        }
        this.specialInputQueue.add(inputMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverEnqueuedInput() {
        this.checkContext();
        Ip2 ip2 = this.ip2;
        synchronized (ip2) {
            try {
                for (IPC.InputMessage inputMessage : this.specialInputQueue) {
                    Object object = inputMessage.getContents();
                    Debug.noteln("Delivering specially delayed", object);
                    this.ip2.handleInput(inputMessage);
                }
            }
            finally {
                this.specialInputQueue = null;
            }
        }
    }

    public Opt getOptionForInput() {
        return this.optionForInput;
    }

    public void setOptionForInput(String string) {
        this.setOptionForInput(this.getOption(string));
    }

    public void setOptionForInput(Opt opt) {
        Debug.noteln("Setting option for input to", opt);
        Debug.expect(this.nameToOptionMap.values().contains(opt), "unknown option", opt);
        this.optionForInput = opt;
    }

    public boolean canTakeInput() {
        Debug.expect(this.optionForInput != null, "No option can receive input");
        return this.optionForInput == this.currentOption && this.currentOption.expectsContext();
    }

    public void recordDelayedInput(IPC.InputMessage inputMessage) {
        if (!this.currentOption.expectsContext()) {
            this.enqueueInput(inputMessage);
            return;
        }
        Debug.expect(this.optionForInput != null, "No option can receive input");
        String string = this.optionForInput.getName();
        if (Parameters.isInteractive() && this.warnUserOfDelayedInput) {
            String[] stringArray = new String[]{"Received " + Reporting.messageDescription(inputMessage), "It will be processed when option currently selected for input,", string + ", becomes the current option.", "", "Do you want to continue to receive these warnings?"};
            this.warnUserOfDelayedInput = Util.dialogConfirms(this.ip2.getFrame(), stringArray);
        } else {
            Debug.noteln("Received ", Reporting.messageDescription(inputMessage));
            Debug.noteln("It will be processed when " + string + " becomes the current option.");
        }
        this.optionForInput.recordDelayedInput(inputMessage);
    }

    public void handleReportWhenOptions(IPC.InputMessage inputMessage) {
        String[] stringArray;
        if (!this.currentOption.expectsContext()) {
            this.enqueueInput(inputMessage);
            return;
        }
        this.checkContext();
        Report report = (Report)inputMessage.getContents();
        boolean bl = false;
        if (this.canTakeInput() || this.ip2.getController().wantsReport(report)) {
            this.ip2.handleInputDirectly(inputMessage);
            bl = true;
        }
        if (this.nameToOptionMap.size() < 2) {
            return;
        }
        String[] stringArray2 = new String[]{"Received " + Reporting.messageDescription(inputMessage), "It was " + (bl ? "delivered" : "not relevant") + " in option " + this.currentOption.getName(), "It will be processed in other options when they next become the current option."};
        if (Parameters.isInteractive() && this.warnUserOfDelayedReport) {
            stringArray = new String[]{"", "Do you want to continue to receive these warnings?"};
            this.warnUserOfDelayedReport = Util.dialogConfirms(this.ip2.getFrame(), Util.appendArrays(stringArray2, stringArray));
        } else {
            Debug.notelines(stringArray2);
        }
        stringArray = new ReportMessage(report);
        for (Opt opt : this.nameToOptionMap.values()) {
            if (opt == this.currentOption) continue;
            opt.recordDelayedInput((IPC.InputMessage)stringArray);
        }
        this.checkContext();
    }

    public void newOption(String string) {
        Debug.noteln("New option", string);
        this.wantOptionName(string);
        this.setOption(this.makeTopLevelOption(string, null));
    }

    public void copyOption(String string) {
        Debug.noteln("Copy", this.currentOption);
        this.wantOptionName(string);
        this.checkContext();
        this.setOption(this.makeTopLevelOption(string, this.currentOption.asPlan()));
    }

    public void renameOption(String string) {
        Debug.noteln("New name for " + this.currentOption, string);
        this.wantOptionName(string);
        this.checkContext();
        this.currentOption.setName(string);
        this.currentOption.noteChange(new OptionEvent(this, this.currentOption));
    }

    public void splitOption() {
        Debug.noteln("Split", this.currentOption);
        Opt opt = this.currentOption.splitYourself();
        this.setOption(opt);
    }

    public boolean plan() {
        Debug.noteln("Plan in", this.currentOption);
        this.checkContext();
        Opt opt = this.currentOption.plan();
        this.checkContext();
        if (opt == null) {
            return false;
        }
        if (opt == this.currentOption) {
            Debug.expect(!this.planSplitsOption);
            this.currentOption.makeYourselfTheCurrentOption();
            this.checkContext();
        } else {
            Debug.expect(this.planSplitsOption);
            this.setOption(opt);
        }
        return true;
    }

    public void replan() {
        Debug.noteln("Replan in", this.currentOption);
        Debug.expect(this.currentOption.allowsReplan(), "Can't replan now");
        this.checkContext();
        Opt opt = this.currentOption.replan();
        this.checkContext();
        if (opt != null) {
            this.setOption(opt);
        }
    }

    public PlanStats getStats() {
        return this.currentOption.getStats();
    }

    public void clearOption() {
        Debug.noteln("Clear", this.currentOption);
        this.checkContext();
        this.currentOption.clear();
        this.ip2.clearModel();
        this.ip2.resetViewers();
        this.reloadViewers();
        this.checkContext();
    }

    public void clearOptionAllButState() {
        Debug.noteln("Clear all but state", this.currentOption);
        this.checkContext();
        this.currentOption.clearAllButState();
        this.ip2.clearAllButState();
        this.ip2.resetViewers();
        this.reloadViewers();
        this.checkContext();
    }

    public void deleteOption() {
        Debug.noteln("Delete", this.currentOption);
        this.checkContext();
        if (this.currentOption == this.optionForInput) {
            throw new IllegalStateException(this.currentOption + " is currently selected for input " + "and so cannot be deleted.");
        }
        String string = this.currentOption.getName();
        SortedMap sortedMap = this.nameToOptionMap.headMap(string);
        SortedMap sortedMap2 = this.nameToOptionMap.tailMap(string + "\u0000");
        String string2 = !sortedMap2.isEmpty() ? sortedMap2.firstKey() : (!sortedMap.isEmpty() ? sortedMap.lastKey() : null);
        this.currentOption.deleteYourself();
        if (string2 != null) {
            this.setOption(string2);
        } else {
            this.newOption("Option-1");
        }
    }

    public void deleteOptions(List list) {
        Debug.noteln("Delete Options", list);
        this.checkContext();
        boolean bl = false;
        for (String string : list) {
            Opt opt = this.getOption(string);
            if (opt == this.currentOption) {
                bl = true;
                continue;
            }
            opt.deleteYourself();
        }
        if (bl) {
            this.deleteOption();
        }
    }

    public void syncState(List list) {
        Debug.noteln("Sync state to", list);
        Debug.noteln("Syna state from", this.currentOption);
        this.checkContext();
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.ip2.getModelManager();
        Map map = ip2ModelManager.getWorldStateMap();
        Plan plan = new Plan();
        plan.setWorldState(map);
        SyncMessage syncMessage = new SyncMessage(plan);
        for (String string : list) {
            Opt opt = this.getOption(string);
            Debug.expect(opt != this.currentOption, "appempt to sync with self:", opt);
            opt.recordDelayedInput(syncMessage);
        }
        this.checkContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        Debug.noteln("Undo in", this.currentOption);
        this.checkContext();
        try {
            Debug.expect(!this.nowUndoing, "nested undo");
            this.nowUndoing = true;
            this.currentOption.undo();
        }
        finally {
            this.nowUndoing = false;
        }
        this.currentOption.makeYourselfTheCurrentOption();
        this.checkContext();
        this.printUndoTrail(this.currentOption);
    }

    protected final boolean undoIsActive() {
        Debug.expect(this.inUndoableTransaction >= 0, "exited too many undoable transactions");
        return this.noticePlanChangeEvents && !this.nowUndoing;
    }

    public void markUndoPoint(String string) {
        if (this.undoIsActive() && this.inUndoableTransaction == 0) {
            Debug.noteln("Mark undo point in", this.currentOption);
            this.checkContext();
            this.currentOption.markUndoPoint(string);
            this.checkContext();
            this.printUndoTrail(this.currentOption);
        }
    }

    public void saveUndoAction(UndoAction undoAction) {
        if (this.undoIsActive()) {
            Debug.noteln("Save undo action " + undoAction + " in " + this.currentOption);
            this.checkContext();
            this.currentOption.saveUndoAction(undoAction);
            if (this.inUndoableTransaction == 0) {
                this.printUndoTrail(this.currentOption);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoableTransaction(String string, Runnable runnable) {
        this.beginUndoableTransaction(string);
        try {
            runnable.run();
        }
        finally {
            this.endUndoableTransaction(string);
        }
    }

    public void beginUndoableTransaction(String string) {
        if (!this.undoIsActive()) {
            return;
        }
        Debug.noteln("/-- Begin undoable transaction (" + (this.inUndoableTransaction + 1) + ")" + " for " + string + " in " + this.currentOption);
        if (this.inUndoableTransaction == 0) {
            this.markUndoPoint(string);
        }
        ++this.inUndoableTransaction;
    }

    public void endUndoableTransaction(String string) {
        if (!this.undoIsActive()) {
            return;
        }
        --this.inUndoableTransaction;
        try {
            Debug.noteln("\\--> End undoable transaction (" + (this.inUndoableTransaction + 1) + ")" + " for " + string + " in " + this.currentOption);
            this.printUndoTrail(this.currentOption);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void printUndoTrail(Opt opt) {
        Debug.noteln("Undo trail:");
        this.printUndoTrail(3, 5, opt.undoTrail.getContents());
    }

    protected void printUndoTrail(int n, int n2, LinkedList linkedList) {
        for (UndoAction undoAction : linkedList) {
            if (n2 <= 0) {
                Debug.noteln(Strings.repeat(n, " "), "...");
                break;
            }
            Debug.noteln(Strings.repeat(n, " "), undoAction.getNote());
            if (undoAction instanceof Opt.UndoPoint) {
                Opt.UndoPoint undoPoint = (Opt.UndoPoint)undoAction;
                this.printUndoTrail(n + 3, 10, undoPoint.undoActions);
            }
            --n2;
        }
    }

    public void addOptionListener(OptionListener optionListener) {
        Debug.noteln("Adding OptionListener", optionListener);
        this.optionListeners.add(optionListener);
    }

    void fireOptionSet(Opt opt) {
        OptionEvent optionEvent = new OptionEvent(this, opt);
        for (OptionListener optionListener : this.optionListeners) {
            optionListener.optionSet(optionEvent);
        }
    }

    void fireOptionAdded(Opt opt) {
        OptionEvent optionEvent = new OptionEvent(this, opt);
        for (OptionListener optionListener : this.optionListeners) {
            optionListener.optionAdded(optionEvent);
        }
    }

    void fireOptionRenamed(Opt opt, String string) {
        OptionEvent optionEvent = new OptionEvent(this, opt);
        for (OptionListener optionListener : this.optionListeners) {
            optionListener.optionRenamed(optionEvent, string);
        }
    }

    void fireOptionContentsChanged(Opt opt, EventObject eventObject) {
        OptionEvent optionEvent = new OptionEvent(this, opt);
        for (OptionListener optionListener : this.optionListeners) {
            optionListener.optionContentsChanged(optionEvent, eventObject);
        }
    }

    void fireOptionDeleted(Opt opt) {
        OptionEvent optionEvent = new OptionEvent(this, opt);
        for (OptionListener optionListener : this.optionListeners) {
            optionListener.optionDeleted(optionEvent);
        }
    }

    private void checkContext() {
        Context context;
        Context context2 = this.currentOption.getExpectedContext();
        if (context2 != (context = Context.getContext())) {
            Debug.warn("The current option, " + this.currentOption + ", " + "is for " + context2 + ", " + "but the current context is " + context);
        }
    }

    private Component displayFrame() {
        IPlanTool iPlanTool = (IPlanTool)this.ip2.ensureTool("I-Plan");
        return iPlanTool.getFrame();
    }

    public SortedMap readPlans(String string) {
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        SortedMap sortedMap = fileSyntaxManager.readAllObjects(Plan.class, string);
        TreeMap<String, Plan> treeMap = new TreeMap<String, Plan>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            File file = (File)entry.getKey();
            Plan plan = (Plan)entry.getValue();
            String string2 = Strings.beforeLast(".", file.getName());
            if (treeMap.get(string2) != null) {
                throw new IllegalArgumentException("There are two plans named " + Strings.quote(string2) + " in " + string);
            }
            treeMap.put(string2, plan);
        }
        return treeMap;
    }

    SortedMap getOptionsAsPlans() {
        TreeMap<String, Plan> treeMap = new TreeMap<String, Plan>();
        for (Opt opt : this.nameToOptionMap.values()) {
            treeMap.put(opt.getName(), opt.asPlan());
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadViewers() {
        Debug.expect(this.noticePlanChangeEvents);
        try {
            this.noticePlanChangeEvents = false;
            this.ip2.reloadViewers();
        }
        finally {
            this.noticePlanChangeEvents = true;
        }
    }

    protected class PlanGen {
        String name;
        List clients;
        Context homeContext;
        Context initialPlanContext;
        Slip slip;
        PlanStats stats;
        int plansReturned;
        Predicate1 planFilter;
        int rejectedPlans;

        PlanGen() {
            this.name = IPlanOptionManager.this.nameGen.nextString("PlanGen");
            this.clients = new LinkedList();
            this.plansReturned = 0;
            this.planFilter = IPlanOptionManager.this.makePlanFilter();
            Debug.noteln("Making", this);
        }

        PlanStats getStats() {
            Debug.expect(this.stats != null, "no stats available from", this);
            return this.stats;
        }

        int getNumberPlansReturned() {
            return this.plansReturned;
        }

        void addClient(Opt opt) {
            Debug.noteln(this + " adding client", opt);
            this.clients.add(opt);
        }

        void removeClient(Opt opt) {
            Debug.noteln(this + " removing client", opt);
            Debug.expect(this.clients.contains(opt));
            this.clients.remove(opt);
            if (this.clients.isEmpty()) {
                this.vanish();
            }
        }

        void vanish() {
            Debug.expect(this.clients.isEmpty(), "vanishing too soon", this);
            Debug.noteln("No longer need", this);
        }

        void discardYourself() {
            for (Opt opt : new ArrayList(this.clients)) {
                opt.dropPlanGen();
            }
            Debug.expect(this.clients.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Plan plan(Plan plan) {
            Debug.noteln("Plan in", this);
            this.homeContext = IPlanOptionManager.this.departContext("planning");
            try {
                this.rejectedPlans = 0;
                this.createPlanner(plan);
                this.slip.plan();
                Plan plan2 = this.filteredPlan();
                return plan2;
            }
            catch (NoPlanException noPlanException) {
                this.handleNoPlan();
                Util.displayAndWait(IPlanOptionManager.this.displayFrame(), "No plan was found");
                Plan plan3 = null;
                return plan3;
            }
            catch (Throwable throwable) {
                this.handleNoPlan();
                Debug.displayException(throwable);
                Plan plan4 = null;
                return plan4;
            }
            finally {
                IPlanOptionManager.this.restoreContext(this.homeContext);
            }
        }

        void handleNoPlan() {
            this.stats = this.slip.getStatistics();
            this.recordRejectCount(this.stats);
            this.discardPlanner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Plan replan() {
            Debug.noteln("Replan in", this);
            Debug.expect(this.slip != null, "no planner in", this);
            this.homeContext = IPlanOptionManager.this.departContext("replanning");
            try {
                this.rejectedPlans = 0;
                this.slip.replan();
                Plan plan = this.filteredPlan();
                return plan;
            }
            catch (NoPlanException noPlanException) {
                this.handleNoPlan();
                Util.displayAndWait(IPlanOptionManager.this.displayFrame(), "No plan was found");
                Plan plan = null;
                return plan;
            }
            catch (Throwable throwable) {
                this.handleNoPlan();
                Debug.displayException(throwable);
                Plan plan = null;
                return plan;
            }
            finally {
                IPlanOptionManager.this.restoreContext(this.homeContext);
            }
        }

        private Plan filteredPlan() {
            while (true) {
                this.stats = this.slip.getStatistics();
                Plan plan = this.slip.getPlan();
                if (this.planFilter.trueOf(plan)) {
                    this.recordRejectCount(this.stats);
                    ++this.plansReturned;
                    return plan;
                }
                this.rejectPlan(plan);
                this.slip.replan();
            }
        }

        private void rejectPlan(Plan plan) {
            Debug.noteln("Plan rejected by", this.planFilter);
            ++this.rejectedPlans;
            if (this.rejectedPlans % 50 == 0 && Parameters.isInteractive()) {
                String[] stringArray = new String[]{this.rejectedPlans + " duplicate plans have been rejected", "Do you want to continue?"};
                if (!Util.dialogConfirms(IPlanOptionManager.this.displayFrame(), stringArray)) {
                    throw new NoPlanException();
                }
            }
        }

        private void recordRejectCount(PlanStats planStats) {
            if (this.rejectedPlans > 0) {
                planStats.recordStat("Number of rejected plans", new Integer(this.rejectedPlans));
            }
        }

        void createPlanner(Plan plan) {
            Context.setContext(Context.rootContext);
            this.initialPlanContext = Context.pushContext();
            this.slip = new Slip(false);
            this.slip.mainStartup(new String[0]);
            this.slip.setDomain(IPlanOptionManager.this.ip2.getDomain());
            this.slip.loadPlan(plan);
        }

        void discardPlanner() {
            this.initialPlanContext.discard();
            this.initialPlanContext = null;
            this.slip = null;
        }

        public String toString() {
            return this.name + "[for " + this.clients + "]";
        }
    }

    public static class ModelHolder
    extends PlannerBase {
        private static ModelHolder instance;

        private ModelHolder() {
            super(false);
        }

        public void plan() {
            throw new UnsupportedOperationException();
        }

        static ModelHolder instance() {
            if (instance == null) {
                instance = ModelHolder.newInstance();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ModelHolder newInstance() {
            IXAgent iXAgent = IXAgent.getAgent();
            synchronized (iXAgent) {
                ModelHolder modelHolder;
                Context context = Context.getContext();
                try {
                    Context.setContext(Context.rootContext);
                    ModelHolder modelHolder2 = new ModelHolder();
                    modelHolder2.mainStartup(new String[0]);
                    modelHolder = modelHolder2;
                }
                catch (Throwable throwable) {
                    Context.setContext(context);
                    throw throwable;
                }
                Context.setContext(context);
                return modelHolder;
            }
        }
    }

    public static class UndoEvent
    extends EventObject {
        UndoEvent(Opt opt) {
            super(opt);
        }
    }

    public static class NoPlanEvent
    extends EventObject {
        NoPlanEvent(Opt opt) {
            super(opt);
        }
    }

    public static class PlanEvent
    extends EventObject {
        PlanEvent(Opt opt) {
            super(opt);
        }
    }

    public class Opt {
        String name;
        Plan plan;
        List delayedMessages;
        Context iplanContext;
        UndoTrail undoTrail;
        boolean hasChanged;
        PlanGen planGen = null;
        PlanStats stats = null;
        long lastChangeTimestamp = 0L;
        long lastEvalTimestamp = this.lastChangeTimestamp - 1L;
        Map planEvaluations = Collections.EMPTY_MAP;

        Opt(String string) {
            this(string, null);
        }

        Opt(String string, Plan plan) {
            this.name = string;
            this.plan = plan;
            this.delayedMessages = new LinkedList();
            this.iplanContext = Context.pushContext();
            this.undoTrail = new UndoTrail();
            this.hasChanged = true;
            if (IPlanOptionManager.this.nameToOptionMap.get(string) != null) {
                throw new ConsistencyException("There is already an option named " + string);
            }
            IPlanOptionManager.this.nameToOptionMap.put(string, this);
            IPlanOptionManager.this.fireOptionAdded(this);
        }

        public void clear() {
            this.undoTrail.clear();
        }

        public void clearAllButState() {
            this.undoTrail.clear();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            String string2 = this.name;
            this.name = IPlanOptionManager.this.wantOptionName(string);
            IPlanOptionManager.this.nameToOptionMap.remove(string2);
            IPlanOptionManager.this.nameToOptionMap.put(string, this);
            IPlanOptionManager.this.fireOptionRenamed(this, string2);
        }

        public boolean expectsContext() {
            return Context.getContext() == this.iplanContext;
        }

        public Context getExpectedContext() {
            return this.iplanContext;
        }

        public PlanStats getStats() {
            Debug.expect(this.stats != null, "no stats available from", this);
            return this.stats;
        }

        public Map getPlanEvaluations() {
            return this.planEvaluations;
        }

        public PlanEvaluation getPlanEvaluation(PlanEvaluator planEvaluator) {
            return (PlanEvaluation)this.getPlanEvaluations().get(planEvaluator);
        }

        void noteChange(EventObject eventObject) {
            Debug.noteln(this + " has changed");
            this.recordChangeTimestamp();
            try {
                Debug.expectSame(IPlanOptionManager.this.currentOption, this, "Change when not current option");
            }
            catch (Throwable throwable) {
                Debug.displayException(throwable);
            }
            this.hasChanged = true;
            if (this.planGen != null) {
                this.dropPlanGen();
            }
            this.evaluatePlan();
            IPlanOptionManager.this.fireOptionContentsChanged(this, eventObject);
        }

        private void recordChangeTimestamp() {
            this.lastChangeTimestamp = System.currentTimeMillis();
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public boolean allowsReplan() {
            return this.planGen != null;
        }

        public void recordDelayedInput(IPC.InputMessage inputMessage) {
            this.delayedMessages.add(inputMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void makeYourselfTheCurrentOption() {
            IPlanOptionManager.this.ip2.resetViewers();
            Context.setContext(this.iplanContext);
            IPlanOptionManager.this.currentOption = this;
            IPlanOptionManager.this.reloadViewers();
            if (this.plan != null) {
                Debug.expect(IPlanOptionManager.this.noticePlanChangeEvents);
                try {
                    IPlanOptionManager.this.noticePlanChangeEvents = false;
                    IPlanOptionManager.this.ip2.loadPlan(this.plan);
                    this.plan = null;
                }
                finally {
                    IPlanOptionManager.this.noticePlanChangeEvents = true;
                }
            }
            this.processMessages(this.delayedMessages, IPlanOptionManager.this.ip2);
            this.delayedMessages.clear();
            this.evaluatePlan();
            IPlanOptionManager.this.fireOptionSet(IPlanOptionManager.this.currentOption);
        }

        private void processMessages(List list, Ip2 ip2) {
            for (IPC.InputMessage inputMessage : list) {
                if (inputMessage instanceof PseudoMessage) {
                    ((PseudoMessage)inputMessage).receivedBy(this, ip2);
                    continue;
                }
                ip2.handleInputDirectly(inputMessage);
            }
        }

        void evaluatePlan() {
            Debug.noteln("Evaluating plan in", this);
            if (this.lastChangeTimestamp == this.lastEvalTimestamp) {
                Debug.noteln("No need to re-evaluate.");
            } else {
                this.planEvaluations = IPlanOptionManager.this.planEvalManager.evaluatePlan(IPlanOptionManager.this.ip2, this.name);
                this.lastEvalTimestamp = this.lastChangeTimestamp;
            }
        }

        Opt splitYourself() {
            Opt opt = this.hasChanged ? this.splitDown() : this.splitAcross();
            return opt;
        }

        private Opt splitDown() {
            Debug.noteln("Splitting down", this);
            String string = IPlanOptionManager.this.wantOptionName(IPlanOptionManager.this.childName(this.name, 1));
            String string2 = IPlanOptionManager.this.wantOptionName(IPlanOptionManager.this.childName(this.name, 2));
            this.hasChanged = false;
            this.setName(string);
            Opt opt = this.splitAcross();
            Debug.expectEquals(string2, opt.name);
            return opt;
        }

        private Opt splitAcross() {
            Debug.noteln("Splitting across", this);
            String string = IPlanOptionManager.this.parentName(this.name);
            String string2 = IPlanOptionManager.this.nextSiblingName(string);
            Opt opt = IPlanOptionManager.this.makeTopLevelOption(string2, this.asPlan());
            if (this.planGen != null) {
                opt.takePlanGen(this.planGen);
            }
            opt.planEvaluations = this.planEvaluations;
            opt.hasChanged = false;
            return opt;
        }

        void undo() {
            if (this.undoTrail.isEmpty()) {
                throw new UndoException.NoFurtherUndo();
            }
            UndoAction undoAction = this.undoTrail.pop();
            Debug.noteln("Undoing", undoAction.getNote());
            undoAction.undo();
            this.recordChangeTimestamp();
            IPlanOptionManager.this.fireOptionContentsChanged(this, new UndoEvent(this));
        }

        void markUndoPoint(String string) {
            Debug.expect(IPlanOptionManager.this.inUndoableTransaction == 0);
            this.undoTrail.push(new UndoPoint(string));
        }

        void saveUndoAction(UndoAction undoAction) {
            if (IPlanOptionManager.this.inUndoableTransaction > 0) {
                Debug.noteln("Saving in undoable transaction.");
                UndoPoint undoPoint = (UndoPoint)this.undoTrail.getFirst();
                undoPoint.saveUndoAction(undoAction);
            } else {
                this.undoTrail.push(undoAction);
            }
        }

        Opt plan() {
            PlanGen planGen = new PlanGen();
            Plan plan = planGen.plan(this.asPlan());
            PlanStats planStats = planGen.getStats();
            if (plan == null) {
                this.stats = planStats;
                return null;
            }
            if (!IPlanOptionManager.this.planSplitsOption) {
                if (this.planGen != null) {
                    this.dropPlanGen();
                }
                this.takePlanGen(planGen);
                this.replacePlanWith(plan);
                this.stats = planStats;
                this.hasChanged = true;
                this.recordChangeTimestamp();
                IPlanOptionManager.this.fireOptionContentsChanged(this, new PlanEvent(this));
                return this;
            }
            String string = IPlanOptionManager.this.nextSiblingName(this.name);
            Opt opt = IPlanOptionManager.this.makeTopLevelOption(string, plan);
            opt.stats = planStats;
            opt.takePlanGen(planGen);
            return opt;
        }

        Opt replan() {
            Debug.expect(this.planGen != null, "lost plan generator for", this);
            Plan plan = this.planGen.replan();
            PlanStats planStats = this.planGen.getStats();
            if (plan == null) {
                this.stats = planStats;
                this.planGen.discardYourself();
                IPlanOptionManager.this.fireOptionContentsChanged(this, new NoPlanEvent(this));
                return null;
            }
            if (IPlanOptionManager.this.useOnlyOneOption) {
                this.replacePlanWith(plan);
                return this;
            }
            int n = this.planGen.getNumberPlansReturned();
            Opt opt = !IPlanOptionManager.this.planSplitsOption && n == 2 ? this.splitDown() : this.splitAcross();
            this.hasChanged = true;
            opt.replacePlanWith(plan);
            opt.stats = planStats;
            opt.hasChanged = true;
            return opt;
        }

        void takePlanGen(PlanGen planGen) {
            Debug.expect(this.planGen == null);
            this.planGen = planGen;
            this.planGen.addClient(this);
        }

        void dropPlanGen() {
            this.planGen.removeClient(this);
            this.planGen = null;
        }

        void replacePlanWith(Plan plan) {
            if (!this.delayedMessages.isEmpty()) {
                Debug.warn("Trying to replace plan in " + this + " when there are delayed messages.");
            }
            Context.inContext(this.iplanContext, new Runnable(){

                public void run() {
                    IPlanOptionManager.this.ip2.clearModel();
                }
            });
            this.plan = plan;
        }

        void deleteYourself() {
            IPlanOptionManager.this.nameToOptionMap.remove(this.name);
            if (this.planGen != null) {
                this.planGen.removeClient(this);
            }
            IPlanOptionManager.this.fireOptionDeleted(this);
        }

        public Plan asPlan() {
            Plan plan = this.getPlan();
            if (this.delayedMessages.isEmpty()) {
                return plan;
            }
            Debug.noteln("Getting plan with delayed messages in", this);
            Debug.expect(this != IPlanOptionManager.this.currentOption);
            IPlanOptionManager.this.checkContext();
            ModelHolder modelHolder = ModelHolder.instance();
            IPlanOptionManager.this.checkContext();
            modelHolder.clearModel();
            modelHolder.loadPlan(plan);
            this.processMessages(this.delayedMessages, modelHolder);
            Plan plan2 = modelHolder.getPlan();
            modelHolder.clearModel();
            IPlanOptionManager.this.checkContext();
            return plan2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Plan getPlan() {
            Parameters.setParameter("plan-state-to-save", "*");
            if (this.plan != null) {
                return this.plan;
            }
            Context context = Context.getContext();
            try {
                Context.setContext(this.iplanContext);
                Plan plan = IPlanOptionManager.this.ip2.getPlan();
                return plan;
            }
            finally {
                Context.setContext(context);
            }
        }

        public String toString() {
            return "option[" + this.name + "]";
        }

        class UndoTrail {
            private LinkedList trail = new LinkedList();
            private boolean savedHasChanged;

            UndoTrail() {
                this.savedHasChanged = Opt.this.hasChanged;
            }

            void clear() {
                this.trail.clear();
            }

            boolean isEmpty() {
                return this.trail.isEmpty();
            }

            void push(UndoAction undoAction) {
                if (this.trail.isEmpty()) {
                    Debug.noteln("Saving hasChanged == " + Opt.this.hasChanged);
                    this.savedHasChanged = Opt.this.hasChanged;
                }
                this.trail.addFirst(undoAction);
            }

            UndoAction getFirst() {
                return (UndoAction)this.trail.getFirst();
            }

            UndoAction pop() {
                UndoAction undoAction = (UndoAction)this.trail.removeFirst();
                if (this.trail.isEmpty()) {
                    Debug.noteln("Restoring hasChanged to " + this.savedHasChanged);
                    Opt.this.hasChanged = this.savedHasChanged;
                }
                return undoAction;
            }

            LinkedList getContents() {
                return this.trail;
            }
        }

        public class UndoPoint
        extends AbstractUndoAction {
            Context savedState;
            LinkedList undoActions;

            public UndoPoint(String string) {
                super(string);
                this.undoActions = new LinkedList();
                Debug.expectSame(Opt.this.iplanContext, Context.getContext());
                this.savedState = Opt.this.iplanContext;
                Opt.this.iplanContext = Context.pushContext();
            }

            public void saveUndoAction(UndoAction undoAction) {
                this.undoActions.addFirst(undoAction);
            }

            public void undo() {
                Debug.noteln("Undoing " + Opt.this + " to " + this.savedState);
                Context.setContext(this.savedState);
                Opt.this.iplanContext = Context.pushContext();
                Debug.noteln("Pushed " + Opt.this + " to " + Opt.this.iplanContext);
                while (!this.undoActions.isEmpty()) {
                    UndoAction undoAction = (UndoAction)this.undoActions.removeFirst();
                    Debug.noteln("In " + this.getNote() + ", undoing " + undoAction.getNote());
                    undoAction.undo();
                }
            }
        }
    }

    static class SyncMessage
    extends PseudoMessage {
        SyncMessage(Plan plan) {
            super(plan);
        }

        public void receivedBy(Opt opt, Ip2 ip2) {
            Debug.noteln("Syncing state in", opt);
            Debug.noteln("Loading sync state in model of", ip2);
            ip2.loadPlan((Plan)this.getContents());
        }
    }

    public static abstract class PseudoMessage
    extends IPC.BasicInputMessage {
        public PseudoMessage(Object object) {
            super(object);
        }

        public abstract void receivedBy(Opt var1, Ip2 var2);
    }

    class ReportMessage
    extends PseudoMessage {
        ReportMessage(Report report) {
            super(report);
        }

        public void receivedBy(Opt opt, Ip2 ip2) {
            Debug.noteln(opt + " trying " + Reporting.messageDescription(this));
            Debug.noteln("Using agendas of", ip2);
            Debug.expectSame(IPlanOptionManager.this.currentOption, opt);
            Report report = (Report)this.getContents();
            if (ip2.getController().wantsReport(report) || opt == IPlanOptionManager.this.optionForInput) {
                Debug.noteln("Giving report to", opt);
                ip2.handleInputDirectly(this);
            }
        }
    }

    class ResetHook
    implements Runnable {
        ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", IPlanOptionManager.this);
            IPlanOptionManager.this.nameToOptionMap.clear();
            IPlanOptionManager.this.currentOption = null;
            IPlanOptionManager.this.optionForInput = null;
            IPlanOptionManager.this.setInitialCurrentOption();
        }
    }
}

