/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.domain.Constraint;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.HandlerAction;
import ix.util.Collect;
import ix.util.Strings;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UnsatisfiedConditionsUnreadyReason
extends ActionUnreadyReason {
    protected List satisfiedConditions;
    protected List unsatisfiedConditions;
    protected MatchEnv condEnv;
    protected String[] explanation = null;

    public UnsatisfiedConditionsUnreadyReason(HandlerAction handlerAction, List list, List list2, MatchEnv matchEnv) {
        super(handlerAction);
        this.satisfiedConditions = list2;
        this.unsatisfiedConditions = (List)Collect.difference(list, list2);
        this.condEnv = matchEnv;
    }

    public List getSatisfiedConditions() {
        return this.satisfiedConditions;
    }

    public List getUnsatisfiedConditions() {
        return this.unsatisfiedConditions;
    }

    public MatchEnv getConditionEnv() {
        return this.condEnv;
    }

    public String[] getExplanation() {
        if (this.explanation == null) {
            this.explanation = this.makeExplanation();
        }
        return this.explanation;
    }

    protected String[] makeExplanation() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.unsatisfiedConditions.isEmpty()) {
            linkedList.add("The conditions could all be satisfied individually,");
            linkedList.add("but not together.");
        }
        linkedList.addAll(this.condDescrs("Can be satisfied individually:", this.satisfiedConditions));
        linkedList.addAll(this.condDescrs("Cannot be satisfied individually:", this.unsatisfiedConditions));
        linkedList.add(Strings.foldLongLine("Environment: " + this.envDescription(this.condEnv), 75, "  "));
        return Strings.toArray(linkedList);
    }

    protected List condDescrs(String string, List list) {
        if (list.isEmpty()) {
            return Lisp.list(string + " none");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        for (Constraint constraint : list) {
            linkedList.add("   " + constraint);
        }
        return linkedList;
    }

    protected String envDescription(MatchEnv matchEnv) {
        if (matchEnv.isEmpty()) {
            return "empty";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = matchEnv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

