/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.KeyValueTable;
import ix.iface.util.ToolFrame;
import ix.ip2.StateViewTable;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class PropertyViewTable
extends StateViewTable.ViewTable {
    ViewFrame frame = new ViewFrame();
    Object viewedObject = null;

    public PropertyViewTable(StateViewTable stateViewTable) {
        super(stateViewTable, "Property", "Value");
        this.setKeySortComparator(new KeyValueTable.LexicographicComparator());
    }

    public void viewObject(Object object) {
        String string = Lisp.printToString(object);
        Debug.noteln("Asked to see properties of", string);
        this.reset();
        this.viewedObject = object;
        this.recordNewValues(this.getStateViewerMap());
        this.frame.scroll.setBorder(BorderFactory.createTitledBorder("Properties of " + string));
        this.frame.setVisible(true);
    }

    private Map getStateViewerMap() {
        return this.stateViewer.viewTable.getViewedMap();
    }

    public void reset() {
        super.reset();
        this.viewedObject = null;
    }

    void closeFrame() {
        Debug.noteln("Close on", this);
        this.frame.setVisible(false);
        this.reset();
    }

    protected String keyToString(Object object) {
        final Symbol symbol = Symbol.intern("~");
        LList lList = (LList)Collect.map((LList)object, new Function1(){

            public Object funcall(Object object) {
                return object.equals(PropertyViewTable.this.viewedObject) ? symbol : object;
            }
        });
        return Lisp.elementsToString(lList);
    }

    public void recordNewValue(Object object, Object object2) {
        if (this.getRowObjects(object, Lisp.NIL).contains(this.viewedObject)) {
            super.recordNewValue(object, object2);
        }
    }

    protected boolean isObjectName(Object object) {
        return this.stateViewer.viewTable.isObjectName(object);
    }

    public void deleteEntry(Object object, Object object2) {
        if (this.keyList.contains(object)) {
            super.deleteEntry(object, object2);
        }
    }

    class ViewFrame
    extends ToolFrame {
        Container contentPane;
        JScrollPane scroll;

        ViewFrame() {
            super(PropertyViewTable.this.stateViewer.ip2.getAgentDisplayName() + " Object Properties");
            this.contentPane = this.getContentPane();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Debug.noteln("Property view windowClosing event");
                    PropertyViewTable.this.closeFrame();
                }
            });
            JTable jTable = PropertyViewTable.this.getJTable();
            this.scroll = new JScrollPane(jTable);
            this.scroll.setBorder(BorderFactory.createTitledBorder("Properties"));
            this.contentPane.add((Component)this.scroll, "Center");
            this.contentPane.add((Component)this.makeButtonPanel(), "South");
            this.pack();
            Dimension dimension = this.getSize();
            this.setSize(new Dimension((int)Math.round(dimension.getWidth()), 150));
        }

        protected JPanel makeButtonPanel() {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("Cancel");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyViewTable.this.closeFrame();
                }
            };
            jButton.addActionListener(CatchingActionListener.listener(actionListener));
            jPanel.add(jButton);
            return jPanel;
        }
    }
}

