/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.Annotations;
import ix.icore.Issue;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.domain.LinkedListOfConstrainer;
import ix.icore.domain.ListOfConstrainer;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.LinkedListOfPlanIssue;
import ix.icore.plan.LinkedListOfPlanIssueRefinement;
import ix.icore.plan.LinkedListOfPlanNode;
import ix.icore.plan.LinkedListOfPlanRefinement;
import ix.icore.plan.LinkedListOfPlanVariableDeclaration;
import ix.icore.plan.ListOfPlanIssue;
import ix.icore.plan.ListOfPlanIssueRefinement;
import ix.icore.plan.ListOfPlanNode;
import ix.icore.plan.ListOfPlanRefinement;
import ix.icore.plan.ListOfPlanVariableDeclaration;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanIssue;
import ix.icore.plan.PlanIssueRefinement;
import ix.icore.plan.PlanNode;
import ix.icore.plan.PlanRefinement;
import ix.icore.plan.PlanVariable;
import ix.icore.plan.PlanVariableDeclaration;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueItem;
import ix.ip2.PanelController;
import ix.ip2.VariableManager;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Gensym;
import ix.util.Name;
import ix.util.ObjectCopier;
import ix.util.Parameters;
import ix.util.Predicate2;
import ix.util.Proc;
import ix.util.StableHashMap;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class PlanMaker {
    public static final Symbol S_WORLD_STATE = Symbol.intern("world-state");
    public static final Symbol S_CONDITION = Symbol.intern("condition");
    public static final Symbol S_EFFECT = Symbol.intern("effect");
    Gensym.Generator nameGen = new Gensym.Generator();
    PanelController controller;
    Ip2ModelManager modelManager;
    VariableManager variableManager;
    Plan plan;
    ListOfPlanNode topNodes;
    ListOfPlanRefinement refinements;
    ListOfPlanIssue topIssues;
    ListOfPlanIssueRefinement issueRefinements;
    Map varToDclMap;
    Map itemToNodeMap = new HashMap();

    PlanMaker(Ip2 ip2) {
        this.controller = ip2.getController();
        this.modelManager = (Ip2ModelManager)ip2.getModelManager();
        this.variableManager = this.modelManager.variableManager;
    }

    Plan getPlan() {
        this.buildPlan();
        return this.plan;
    }

    Plan buildPlan() {
        this.plan = new Plan();
        this.topNodes = new LinkedListOfPlanNode();
        this.refinements = new LinkedListOfPlanRefinement();
        this.topIssues = new LinkedListOfPlanIssue();
        this.issueRefinements = new LinkedListOfPlanIssueRefinement();
        this.varToDclMap = new HashMap();
        List list = this.getVariables(this.modelManager.getVarEnv());
        ListOfPlanVariableDeclaration listOfPlanVariableDeclaration = this.makeVariableDeclarations(list);
        Collect.extendMap(this.varToDclMap, list, listOfPlanVariableDeclaration);
        ListOfConstrainer listOfConstrainer = this.getTopLevelConstraints();
        ListOfPatternAssignment listOfPatternAssignment = this.getWorldState();
        this.walkNodes();
        this.walkIssues();
        listOfConstrainer.addAll(this.buildNonSiblingOrderings());
        Annotations annotations = this.modelManager.getAnnotations();
        if (!listOfPlanVariableDeclaration.isEmpty()) {
            this.plan.setPlanVariableDeclarations(listOfPlanVariableDeclaration);
        }
        if (!this.topIssues.isEmpty()) {
            this.plan.setPlanIssues(this.topIssues);
        }
        if (!this.issueRefinements.isEmpty()) {
            this.plan.setPlanIssueRefinements(this.issueRefinements);
        }
        if (!this.topNodes.isEmpty()) {
            this.plan.setPlanNodes(this.topNodes);
        }
        if (!this.refinements.isEmpty()) {
            this.plan.setPlanRefinements(this.refinements);
        }
        if (!listOfConstrainer.isEmpty()) {
            this.plan.setConstraints(listOfConstrainer);
        }
        if (!listOfPatternAssignment.isEmpty()) {
            this.plan.setWorldState(listOfPatternAssignment);
        }
        if (annotations != null && !annotations.isEmpty()) {
            this.plan.setAnnotations(annotations);
        }
        this.plan = (Plan)new Pass2().copy(this.plan);
        return this.plan;
    }

    Name genId(String string) {
        return this.nameGen.nextName(string);
    }

    List getVariables(Map map) {
        LinkedList linkedList = new LinkedList(Variable.getAllVariables());
        linkedList.retainAll(map.values());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            if (variable.getValue() == null) continue;
            iterator.remove();
        }
        return linkedList;
    }

    ListOfPlanVariableDeclaration makeVariableDeclarations(List list) {
        LinkedListOfPlanVariableDeclaration linkedListOfPlanVariableDeclaration = new LinkedListOfPlanVariableDeclaration();
        Collect.map(linkedListOfPlanVariableDeclaration, list, new Function1(){

            public Object funcall(Object object) {
                Variable variable = (Variable)object;
                return new PlanVariableDeclaration(PlanMaker.this.genId("var"), variable);
            }
        });
        return linkedListOfPlanVariableDeclaration;
    }

    ListOfConstrainer getTopLevelConstraints() {
        LinkedListOfConstrainer linkedListOfConstrainer = new LinkedListOfConstrainer();
        linkedListOfConstrainer.addAll(this.variableManager.getConstraints());
        linkedListOfConstrainer.addAll(this.modelManager.getOtherConstraints());
        return linkedListOfConstrainer;
    }

    ListOfPatternAssignment getWorldState() {
        final List list = Parameters.getList("plan-state-to-save");
        Map map = this.modelManager.getWorldStateMap();
        return PatternAssignment.mapToAssignments(list.contains("*") ? map : Collect.filter(new StableHashMap(), map, new Predicate2(){

            public boolean trueOf(Object object, Object object2) {
                LList lList = (LList)object;
                return lList != Lisp.NIL && list.contains(lList.car().toString());
            }
        }));
    }

    void walkIssues() {
        List list = this.controller.getIssueAgenda().getItems();
        for (IssueItem issueItem : list) {
            if (issueItem.getLevel() != 0) continue;
            this.walkTopIssue(issueItem);
        }
    }

    void walkTopIssue(IssueItem issueItem) {
        Issue issue = (Issue)issueItem.getAbout();
        PlanIssue planIssue = new PlanIssue(this.genId("issue"), issue);
        this.topIssues.add(planIssue);
        if (issueItem.isExpanded()) {
            this.buildIssueExpansion(issueItem, planIssue);
        }
    }

    void buildIssueExpansion(IssueItem issueItem, PlanIssue planIssue) {
        List list;
        PlanIssueRefinement planIssueRefinement = new PlanIssueRefinement();
        planIssueRefinement.setId(this.genId("issue-refinement"));
        this.issueRefinements.add(planIssueRefinement);
        planIssue.setExpansion(planIssueRefinement.getId());
        planIssueRefinement.setExpands(planIssue.getId());
        List list2 = this.getVariables(issueItem.getVarTable());
        if (!list2.isEmpty()) {
            list = this.makeVariableDeclarations(list2);
            Collect.extendMap(this.varToDclMap, list2, list);
            planIssueRefinement.setPlanVariableDeclarations((ListOfPlanVariableDeclaration)list);
        }
        list = issueItem.getChildren();
        LinkedListOfPlanIssue linkedListOfPlanIssue = new LinkedListOfPlanIssue();
        for (IssueItem issueItem2 : list) {
            Issue issue = (Issue)issueItem2.getAbout();
            PlanIssue planIssue2 = new PlanIssue(this.genId(planIssue.getId().toString()), issue);
            linkedListOfPlanIssue.add(planIssue2);
            if (!issueItem2.isExpanded()) continue;
            this.buildIssueExpansion(issueItem2, planIssue2);
        }
        if (!linkedListOfPlanIssue.isEmpty()) {
            planIssueRefinement.setPlanIssues(linkedListOfPlanIssue);
        }
    }

    void walkNodes() {
        for (ActivityItem activityItem : this.modelManager.getNodes()) {
            if (activityItem.getLevel() != 0) continue;
            this.walkTopNode(activityItem);
        }
    }

    void walkTopNode(ActivityItem activityItem) {
        PlanNode planNode = this.makePlanNode("node", activityItem);
        this.topNodes.add(planNode);
        if (activityItem.isExpanded()) {
            this.buildExpansion(activityItem, planNode);
        } else {
            ListOfConstrainer listOfConstrainer = this.getNodeConstraints(activityItem);
            if (!listOfConstrainer.isEmpty()) {
                PlanRefinement planRefinement = this.makePlanRefinement(planNode);
                planRefinement.setConstraints(listOfConstrainer);
                planRefinement.setIsNotExpansion();
            }
        }
    }

    PlanNode makePlanNode(String string, ActivityItem activityItem) {
        Activity activity = (Activity)activityItem.getAbout();
        PlanNode planNode = new PlanNode(this.genId(string), activity);
        this.itemToNodeMap.put(activityItem, planNode);
        return planNode;
    }

    PlanNode getPlanNode(ActivityItem activityItem) {
        PlanNode planNode = (PlanNode)this.itemToNodeMap.get(activityItem);
        Debug.expect(planNode != null, "Can't find PlanNode for", activityItem);
        return planNode;
    }

    void buildExpansion(ActivityItem activityItem, PlanNode planNode) {
        List list;
        PlanRefinement planRefinement = this.makePlanRefinement(planNode);
        List list2 = this.getVariables(activityItem.getVarTable());
        if (!list2.isEmpty()) {
            list = this.makeVariableDeclarations(list2);
            Collect.extendMap(this.varToDclMap, list2, list);
            planRefinement.setPlanVariableDeclarations((ListOfPlanVariableDeclaration)list);
        }
        list = activityItem.getChildren();
        LinkedListOfPlanNode linkedListOfPlanNode = new LinkedListOfPlanNode();
        Object object = list.iterator();
        while (object.hasNext()) {
            ActivityItem activityItem2 = (ActivityItem)object.next();
            PlanNode planNode2 = this.makePlanNode(planNode.getId().toString(), activityItem2);
            linkedListOfPlanNode.add(planNode2);
            if (!activityItem2.isExpanded()) continue;
            this.buildExpansion(activityItem2, planNode2);
        }
        this.checkItemToNodeMap(list, linkedListOfPlanNode);
        if (!linkedListOfPlanNode.isEmpty()) {
            planRefinement.setPlanNodes(linkedListOfPlanNode);
        }
        if (!(object = this.getNodeConstraints(activityItem)).isEmpty()) {
            planRefinement.setConstraints((ListOfConstrainer)object);
        }
    }

    PlanRefinement makePlanRefinement(PlanNode planNode) {
        PlanRefinement planRefinement = new PlanRefinement();
        planRefinement.setId(this.genId("refinement"));
        this.refinements.add(planRefinement);
        planNode.setExpansion(planRefinement.getId());
        planRefinement.setExpands(planNode.getId());
        return planRefinement;
    }

    ListOfConstrainer getNodeConstraints(ActivityItem activityItem) {
        LinkedListOfConstrainer linkedListOfConstrainer = new LinkedListOfConstrainer();
        linkedListOfConstrainer.addAll(this.buildChildSiblingOrderings(activityItem));
        linkedListOfConstrainer.addAll(this.modelManager.getNodeConditions(activityItem));
        linkedListOfConstrainer.addAll(this.buildConstraints(S_WORLD_STATE, S_EFFECT, this.modelManager.getNodeEffects(activityItem)));
        linkedListOfConstrainer.addAll(Collect.ensureList(this.modelManager.getOtherNodeConstraints(activityItem)));
        return linkedListOfConstrainer;
    }

    void checkItemToNodeMap(List list, List list2) {
        Debug.expect(list.size() == list2.size());
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            ActivityItem activityItem = (ActivityItem)iterator.next();
            PlanNode planNode = (PlanNode)iterator2.next();
            Debug.expect(this.getPlanNode(activityItem) == planNode);
        }
    }

    List buildConstraints(Symbol symbol, Symbol symbol2, List list) {
        LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
        if (list == null) {
            return linkedList;
        }
        for (PatternAssignment patternAssignment : list) {
            linkedList.add(new Constraint(symbol, symbol2, (List)Lisp.list(patternAssignment)));
        }
        return linkedList;
    }

    List buildChildSiblingOrderings(ActivityItem activityItem) {
        final LinkedList linkedList = new LinkedList();
        this.walkChildOrderings(activityItem, new OrdWalker(){

            public void visit(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
                if (pNodeEnd.getNode().isSiblingOf(pNodeEnd2.getNode())) {
                    linkedList.add(PlanMaker.this.makeOrdering(pNodeEnd, pNodeEnd2));
                }
            }
        });
        return linkedList;
    }

    List buildNonSiblingOrderings() {
        final LinkedList linkedList = new LinkedList();
        this.modelManager.walkTopNodes(new Proc(){

            public void call(Object object) {
                ActivityItem activityItem = (ActivityItem)object;
                PlanMaker.this.walkNodeOrderings(activityItem, new OrdWalker(){

                    public void visit(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
                        if (PlanMaker.this.isNonSiblingOrdering(pNodeEnd, pNodeEnd2)) {
                            linkedList.add(PlanMaker.this.makeOrdering(pNodeEnd, pNodeEnd2));
                        }
                    }
                });
                PlanMaker.this.modelManager.walkNodeChildren(activityItem, this);
            }
        });
        return linkedList;
    }

    boolean isNonSiblingOrdering(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
        ActivityItem activityItem2 = (ActivityItem)pNodeEnd2.getNode();
        End end = pNodeEnd.getEnd();
        End end2 = pNodeEnd2.getEnd();
        if (end == End.BEGIN && activityItem == activityItem2.getParent() || end2 == End.END && activityItem2 == activityItem.getParent()) {
            return false;
        }
        return activityItem.getParent() == null || !activityItem.isSiblingOf(activityItem2);
    }

    void walkChildOrderings(PNode pNode, OrdWalker ordWalker) {
        for (PNode pNode2 : pNode.getChildren()) {
            this.walkNodeOrderings(pNode2, ordWalker);
        }
    }

    void walkNodeOrderings(PNode pNode, OrdWalker ordWalker) {
        this.walkEndOrderings(pNode.getBegin(), ordWalker);
        this.walkEndOrderings(pNode.getEnd(), ordWalker);
    }

    void walkEndOrderings(PNodeEnd pNodeEnd, OrdWalker ordWalker) {
        PNodeEnd pNodeEnd2 = null;
        if (pNodeEnd.getEnd() == End.BEGIN) {
            pNodeEnd2 = pNodeEnd.getNode().getEnd();
        }
        for (PNodeEnd pNodeEnd3 : pNodeEnd.getSuccessors()) {
            if (pNodeEnd3 == pNodeEnd2) continue;
            ordWalker.visit(pNodeEnd, pNodeEnd3);
        }
    }

    Ordering makeOrdering(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
        ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
        ActivityItem activityItem2 = (ActivityItem)pNodeEnd2.getNode();
        PlanNode planNode = this.getPlanNode(activityItem);
        PlanNode planNode2 = this.getPlanNode(activityItem2);
        return new Ordering(new NodeEndRef(pNodeEnd.getEnd(), planNode.getId()), new NodeEndRef(pNodeEnd2.getEnd(), planNode2.getId()));
    }

    static interface OrdWalker {
        public void visit(PNodeEnd var1, PNodeEnd var2);
    }

    class Pass2
    extends ObjectCopier {
        Pass2() {
        }

        public Object mapElement(Object object) {
            return object instanceof Variable ? this.mapVariable((Variable)object) : this.copy(object);
        }

        Object mapVariable(Variable variable) {
            Object object = variable.getValue();
            return object != null ? object : this.getPV(variable);
        }

        PlanVariable getPV(Variable variable) {
            PlanVariableDeclaration planVariableDeclaration = (PlanVariableDeclaration)PlanMaker.this.varToDclMap.get(variable);
            return planVariableDeclaration.getPlanVariable();
        }
    }
}

