/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.domain.Constraint;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.Plan;
import ix.icore.process.event.ProcessStatusEvent;
import ix.iface.util.HtmlStringWriter;
import ix.iface.util.HtmlTableEditorPane;
import ix.iface.util.HtmlTableWalker;
import ix.iface.util.IFUtil;
import ix.iface.util.IconImage;
import ix.iface.util.KeyValueTable;
import ix.iface.util.ToolFrame;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.ObjectView;
import ix.ip2.PanelFrame;
import ix.ip2.StateViewer;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.StructuralEquality;
import ix.util.UniqueObject;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class ObjectWhiteboard
implements StateViewer {
    Ip2 ip2;
    Ip2ModelManager mm;
    WhiteboardFrame frame;
    SortedMap nameToViewMap = null;
    ObjectView view = null;
    SortedSet objects;
    List properties;
    static boolean hasBeenVisible = false;
    Map fromPattern = new HashMap();
    Map fromTD = new HashMap();
    StructuralEquality structEqual = new StructuralEquality();
    final Object BLANK = new UniqueObject("BLANK");
    private Function1 stateLookupFn = new Function1(){

        public Object funcall(Object object) {
            LList lList = (LList)object;
            return ObjectWhiteboard.this.mm.getWorldStateValue(lList);
        }
    };

    public ObjectWhiteboard(Ip2 ip2) {
        this(ip2, null);
    }

    protected ObjectWhiteboard(Ip2 ip2, SortedMap sortedMap) {
        this.ip2 = ip2;
        this.mm = (Ip2ModelManager)ip2.getModelManager();
        this.nameToViewMap = sortedMap;
        this.frame = new WhiteboardFrame();
        if (this.nameToViewMap == null) {
            String string = Parameters.getParameter("object-view-directory");
            if (string != null) {
                this.loadViews(string);
            }
        } else {
            this.frame.populateSelectViewMenu();
        }
        ip2.getModelManager().addProcessStatusListener(this);
        ip2.addResetHook(new ResetHook());
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
        if (!hasBeenVisible) {
            hasBeenVisible = true;
            this.whenFirstMadeVisible();
        }
    }

    void whenFirstMadeVisible() {
        ArrayList arrayList = Parameters.getList("initial-whiteboards");
        if (!arrayList.isEmpty() && arrayList.get(0).equals(":all")) {
            arrayList = new ArrayList(this.nameToViewMap.keySet());
        }
        if (!arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            String string = (String)iterator.next();
            Debug.noteln("Setting first view to", string);
            this.setObjectView(string);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Debug.noteln("Creating view for", string2);
                ObjectWhiteboard objectWhiteboard = new ObjectWhiteboard(this.ip2, this.nameToViewMap);
                objectWhiteboard.setVisible(true);
                objectWhiteboard.setObjectView(string2);
            }
        }
    }

    public Component getView(PanelFrame panelFrame) {
        return this.frame;
    }

    public void reset() {
        if (this.view != null) {
            this.setObjectView(this.view);
        }
    }

    public void statusUpdate(ProcessStatusEvent processStatusEvent) {
    }

    public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
    }

    public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
        if (this.view == null) {
            return;
        }
        SortedSet sortedSet = this.view.getNewObjects(map, this.objects, this.stateLookupFn);
        if (!sortedSet.isEmpty()) {
            Debug.noteln("New objects to view", sortedSet);
            this.loadViewContentsSavingState();
        } else {
            this.processStateDelta(map, false);
        }
    }

    public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
        if (this.view == null) {
            return;
        }
        this.processStateDelta(map, true);
    }

    void processStateDelta(Map map, boolean bl) {
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            Fact fact = this.getFact(lList);
            if (fact == null) continue;
            if (bl) {
                fact.delete();
                continue;
            }
            fact.changeValue(v);
        }
    }

    public ObjectView getObjectView() {
        return this.view;
    }

    public ObjectView getObjectView(String string) {
        ObjectView objectView = (ObjectView)this.nameToViewMap.get(string);
        if (objectView != null) {
            return objectView;
        }
        throw new IllegalArgumentException("There is no view named " + Strings.quote(string));
    }

    public void setObjectView(String string) {
        this.setObjectView(this.getObjectView(string));
    }

    public void setObjectView(ObjectView objectView) {
        this.view = objectView;
        this.properties = Collect.ensureList(objectView.getProperties());
        this.loadViewContents();
        this.frame.noticeView(objectView);
    }

    void addObject(Symbol symbol) {
        this.view.addObject(symbol);
        this.loadViewContentsSavingState();
    }

    void addObject(Symbol symbol, Object object) {
        Cons cons = Lisp.list(ObjectView.TYPE, symbol);
        PatternAssignment patternAssignment = new PatternAssignment(cons, object);
        this.mm.addConstraint(new Constraint("world-state", "effect", (List)Lisp.list(patternAssignment)));
    }

    void loadViewContentsSavingState() {
        Map map = this.saveFactEditState();
        this.loadViewContents();
        if (map.isEmpty()) {
            Debug.noteln("No fact state needed to be restored.");
        } else {
            this.restoreFactEditState(map);
        }
    }

    void loadViewContents() {
        Map map = this.mm.getWorldStateMap();
        this.objects = this.view.getInitialObjects(map, this.stateLookupFn);
        String string = this.makeHtmlTable(map);
        this.frame.setHtml(string);
        this.analyseHTML(map, this.frame.getHTMLDocument());
    }

    void loadViews(String string) {
        block2: {
            Debug.noteln("Reading views from", string);
            try {
                this.nameToViewMap = this.readViews(string);
                this.frame.populateSelectViewMenu();
            }
            catch (Throwable throwable) {
                Debug.displayException("Problem reading views from directory " + string, throwable);
                if (Parameters.isInteractive()) break block2;
                throw new RethrownException(throwable);
            }
        }
    }

    public SortedMap readViews(String string) {
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        SortedMap sortedMap = fileSyntaxManager.readAllObjects(ObjectView.class, string);
        TreeMap<String, ObjectView> treeMap = new TreeMap<String, ObjectView>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            File file = (File)entry.getKey();
            ObjectView objectView = (ObjectView)entry.getValue();
            String string2 = objectView.getName();
            if (string2 == null) {
                string2 = Strings.beforeLast(".", file.getName());
                objectView.setName(string2);
            }
            if (treeMap.get(string2) != null) {
                throw new IllegalArgumentException("There are two views named " + Strings.quote(string2) + " in " + string);
            }
            treeMap.put(string2, objectView);
        }
        return treeMap;
    }

    String makeHtmlTable(Map map) {
        ViewHtmlStringWriter viewHtmlStringWriter = new ViewHtmlStringWriter();
        viewHtmlStringWriter.tag("table", "border=\"1\" cellspacing=\"0\"");
        viewHtmlStringWriter.newLine();
        viewHtmlStringWriter.tag("tr");
        viewHtmlStringWriter.tagged("th", this.view.getObjectHeader("Object"));
        for (ObjectProperty objectProperty : this.properties) {
            viewHtmlStringWriter.tagged("th", objectProperty.getName().toString());
        }
        viewHtmlStringWriter.end("tr");
        viewHtmlStringWriter.newLine();
        for (ObjectProperty objectProperty : this.objects) {
            viewHtmlStringWriter.tag("tr");
            viewHtmlStringWriter.tagged("th", "", ((Object)objectProperty).toString());
            for (ObjectProperty objectProperty2 : this.properties) {
                String string = "BLANK";
                viewHtmlStringWriter.tagged("td", string);
            }
            viewHtmlStringWriter.end("tr");
            viewHtmlStringWriter.newLine();
        }
        viewHtmlStringWriter.end("table");
        viewHtmlStringWriter.newLine();
        String string = viewHtmlStringWriter.toString();
        viewHtmlStringWriter.close();
        return string;
    }

    Object getPropValue(ObjectProperty objectProperty, Object object, Map map) {
        Cons cons = Lisp.list(objectProperty.getName(), object);
        Object v = map.get(cons);
        return v != null ? v : ObjectView.NO_VALUE;
    }

    void analyseHTML(Map map, HTMLDocument hTMLDocument) {
        this.clearFacts();
        new HtmlAnalyser(map).walkHTML(hTMLDocument);
    }

    HTML.Tag getTag(Element element) {
        return (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    Fact getFact(LList lList) {
        return (Fact)this.fromPattern.get(lList);
    }

    Fact getFact(Element element) {
        return (Fact)this.fromTD.get(element);
    }

    Collection getFacts() {
        return this.fromPattern.values();
    }

    Plan getFactsAsPlan() {
        TreeMap<LList, Object> treeMap = new TreeMap<LList, Object>(new KeyValueTable.PatternObjectComparator());
        for (Fact fact : this.getFacts()) {
            if (fact.wasEdited) {
                throw new IllegalStateException("You must commit changes before sending the view.");
            }
            Object object = fact.getValue();
            if (object == ObjectView.NO_VALUE) continue;
            treeMap.put(fact.pattern, object);
        }
        Plan plan = new Plan();
        plan.setWorldState(treeMap);
        return plan;
    }

    void clearFacts() {
        this.fromPattern.clear();
        this.fromTD.clear();
    }

    void submitChanges() {
        StableHashMap stableHashMap = new StableHashMap();
        StableHashMap stableHashMap2 = new StableHashMap();
        for (Object object : this.getFacts()) {
            Object object2;
            if (!((Fact)object).wasEdited) continue;
            Object object3 = ((Fact)object).getValue();
            if (this.structEqual.equal(object3, object2 = ((Fact)object).getValueFromTable())) {
                ((Fact)object).wasEdited = false;
                continue;
            }
            if (object2 == ObjectView.NO_VALUE) {
                stableHashMap2.put(((Fact)object).pattern, object3);
                continue;
            }
            stableHashMap.put(((Fact)object).pattern, object2);
        }
        if (!stableHashMap2.isEmpty()) {
            Debug.noteln("Deletions:", stableHashMap2);
            Iterator<Object> iterator = stableHashMap2.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                object = new PatternAssignment((Map.Entry)iterator.next());
                this.mm.deleteConstraint(new Constraint("world-state", "effect", (List)Lisp.list(object)));
            }
        }
        if (stableHashMap.isEmpty()) {
            Debug.noteln("No changes to submit");
        } else {
            Debug.noteln("Submitting changes", stableHashMap);
            this.mm.handleEffects(PatternAssignment.mapToAssignments(stableHashMap));
        }
    }

    Map saveFactEditState() {
        StableHashMap stableHashMap = new StableHashMap();
        for (Fact fact : this.getFacts()) {
            if (!fact.wasEdited) continue;
            stableHashMap.put(fact, fact.getTableText());
        }
        return stableHashMap;
    }

    void restoreFactEditState(Map map) {
        Debug.noteln("Restoring state", map);
        for (Map.Entry entry : map.entrySet()) {
            Fact fact = (Fact)entry.getKey();
            String string = (String)entry.getValue();
            Debug.expect(fact.wasEdited, "should have been edited", fact);
            Fact fact2 = (Fact)this.fromPattern.get(fact.pattern);
            if (fact2 == null) {
                Debug.noteln("No new Fact matching", fact);
                continue;
            }
            fact2.writeTableText(string);
            fact2.edited();
        }
    }

    static class NewRowDialog
    extends JDialog
    implements ActionListener {
        JTextField nameText = new JTextField(15);
        JComboBox typeChoice = new JComboBox();
        String object = null;
        Object type = null;

        NewRowDialog(Frame frame, String string, ObjectView objectView) {
            super(frame, string, true);
            Object object;
            JPanel jPanel = new JPanel();
            this.setContentPane(jPanel);
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.add((Component)this.wrap(this.nameText, objectView.getObjectHeader("Object")), "West");
            String string2 = "";
            this.typeChoice.addItem(string2);
            if (objectView.getTypes() != null) {
                object = objectView.getTypes().iterator();
                while (object.hasNext()) {
                    this.typeChoice.addItem(object.next());
                }
            }
            this.typeChoice.setSelectedItem(string2);
            jPanel.add((Component)this.wrap(this.typeChoice, "Type"), "East");
            object = IFUtil.makeButton("Cancel", this);
            JButton jButton = IFUtil.makeButton("OK", this);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add((Component)object);
            box.add(Box.createHorizontalGlue());
            jPanel.add((Component)box, "South");
            this.pack();
            this.setLocationRelativeTo(frame);
        }

        String getObject() {
            return this.object;
        }

        Object getType() {
            return this.type;
        }

        JPanel wrap(Component component, String string) {
            JPanel jPanel = new JPanel();
            jPanel.add(component);
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
            return jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("ObjectWhiteboard.NewRowDialog command", string);
            if (string.equals("OK")) {
                String string2 = this.nameText.getText().trim();
                if (string2.equals("")) {
                    Util.displayAndWait(this, "Empty object name");
                    return;
                }
                this.object = string2;
                this.type = this.typeChoice.getSelectedItem();
                this.dispose();
            } else if (string.equals("Cancel")) {
                this.dispose();
            } else {
                throw new ConsistencyException("Don't know what to do for", string);
            }
        }
    }

    class WhiteboardFrame
    extends ToolFrame
    implements ActionListener {
        Container contentPane;
        JMenu viewMenu;
        JMenu selectViewMenu;
        HtmlTableEditorPane htmlPane;
        JScrollPane htmlScroll;
        JButton submitButton;
        JButton newRowButton;
        boolean changingDocumnent;

        WhiteboardFrame() {
            super(ObjectWhiteboard.this.ip2.getAgentDisplayName() + " Object View Table");
            this.htmlPane = new WhiteboardEditorPane();
            this.changingDocumnent = false;
            this.setIconImage(IconImage.getIconImage(this));
            this.setJMenuBar(this.makeMenuBar());
            this.contentPane = this.getContentPane();
            this.htmlScroll = new JScrollPane(this.htmlPane);
            this.htmlScroll.setBorder(BorderFactory.createTitledBorder("Object View"));
            this.contentPane.add((Component)this.htmlScroll, "Center");
            JPanel jPanel = this.makeButtonPanel();
            this.contentPane.add((Component)jPanel, "South");
            this.pack();
            this.setSize(500, 300);
            this.validate();
        }

        JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            jMenu.add(IFUtil.makeMenuItem("New View Window", this));
            jMenu.add(IFUtil.makeMenuItem("Send View", this));
            jMenu.add(IFUtil.makeMenuItem("Close", this));
            JMenu jMenu2 = new JMenu("View");
            jMenuBar.add(jMenu2);
            this.selectViewMenu = new JMenu("Select");
            jMenu2.add(this.selectViewMenu);
            jMenu2.add(IFUtil.makeMenuItem("Redisplay", this));
            this.selectViewMenu.setEnabled(false);
            return jMenuBar;
        }

        void populateSelectViewMenu() {
            JMenu jMenu = this.selectViewMenu;
            jMenu.setEnabled(false);
            jMenu.removeAll();
            for (String string : ObjectWhiteboard.this.nameToViewMap.keySet()) {
                JMenuItem jMenuItem = IFUtil.makeMenuItem(string, this);
                jMenuItem.setActionCommand("Select View");
                jMenu.add(jMenuItem);
            }
            jMenu.setEnabled(true);
        }

        JPanel makeButtonPanel() {
            JPanel jPanel = new JPanel();
            this.submitButton = IFUtil.makeButton("Commit changes", false, this);
            this.newRowButton = IFUtil.makeButton("New Row", false, this);
            jPanel.add(this.submitButton);
            jPanel.add(this.newRowButton);
            return jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("I-Plan Option Tool frame action:", string);
            if (string.equals("Close")) {
                this.setVisible(false);
            } else if (string.equals("New View Window")) {
                new ObjectWhiteboard(ObjectWhiteboard.this.ip2, ObjectWhiteboard.this.nameToViewMap).setVisible(true);
            } else if (string.equals("Send View")) {
                this.sendView();
            } else if (string.equals("Select View")) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string2 = jMenuItem.getText();
                Debug.noteln("Select view", string2);
                ObjectWhiteboard.this.setObjectView(string2);
            } else if (string.equals("Redisplay")) {
                if (ObjectWhiteboard.this.view != null) {
                    ObjectWhiteboard.this.loadViewContents();
                }
            } else if (string.equals("Commit changes")) {
                ObjectWhiteboard.this.submitChanges();
                this.submitButton.setEnabled(false);
            } else if (string.equals("New Row")) {
                this.displayNewRowDialog();
            } else {
                throw new ConsistencyException("Nothing to do for " + string);
            }
        }

        void displayNewRowDialog() {
            NewRowDialog newRowDialog = new NewRowDialog((Frame)this, ObjectWhiteboard.this.ip2.getAgentDisplayName() + " Define Object", ObjectWhiteboard.this.view);
            newRowDialog.show();
            if (newRowDialog.getObject() == null) {
                return;
            }
            Symbol symbol = Symbol.intern(newRowDialog.getObject());
            Object object = newRowDialog.getType();
            if (object.equals("")) {
                ObjectWhiteboard.this.addObject(symbol);
            } else {
                Debug.expect(ObjectWhiteboard.this.view.getTypes().contains(object));
                ObjectWhiteboard.this.addObject(symbol, object);
            }
        }

        HTMLDocument getHTMLDocument() {
            return (HTMLDocument)this.htmlPane.getDocument();
        }

        void setHtml(String string) {
            this.htmlPane.setDocText(string);
        }

        void noticeView(ObjectView objectView) {
            this.htmlScroll.setBorder(BorderFactory.createTitledBorder(objectView.getName()));
            this.submitButton.setEnabled(false);
            this.newRowButton.setEnabled(true);
            this.setTitle(ObjectWhiteboard.this.ip2.getAgentDisplayName() + " " + objectView.getName() + " View");
        }

        void sendView() {
            if (ObjectWhiteboard.this.view == null) {
                throw new IllegalStateException("No view has been selected.");
            }
            Cons cons = Lisp.list(Symbol.intern("load-plan"), ObjectWhiteboard.this.getFactsAsPlan());
            ObjectWhiteboard.this.ip2.getFrame().getSendPanelVisible().initActivity(new Activity(cons));
        }

        class WhiteboardEditorPane
        extends HtmlTableEditorPane {
            WhiteboardEditorPane() {
            }

            protected void editedElement(Element element) {
                Debug.noteln("Editing TD", element);
                Debug.expectSame(HTML.Tag.TD, ObjectWhiteboard.this.getTag(element));
                Fact fact = ObjectWhiteboard.this.getFact(element);
                Debug.expect(fact != null, "unmapped element", element);
                if (!WhiteboardFrame.this.changingDocumnent) {
                    fact.edited();
                    WhiteboardFrame.this.submitButton.setEnabled(true);
                }
            }
        }
    }

    class Fact {
        LList pattern;
        Object value;
        Object obj;
        ObjectProperty prop;
        Element td;
        boolean wasEdited;

        Fact(Object object, ObjectProperty objectProperty, Element element) {
            this.value = ObjectWhiteboard.this.BLANK;
            this.wasEdited = false;
            this.obj = object;
            this.prop = objectProperty;
            this.pattern = Lisp.list(objectProperty.getName(), object);
            this.td = element;
        }

        void recordYourself() {
            ObjectWhiteboard.this.fromPattern.put(this.pattern, this);
            ObjectWhiteboard.this.fromTD.put(this.td, this);
        }

        void edited() {
            Debug.noteln("Changing the value of", this.pattern);
            this.wasEdited = true;
        }

        Object getValue() {
            Debug.expect(this.value != ObjectWhiteboard.this.BLANK, "Blank value for", this);
            Debug.expect(this.value != null, "Null value for", this);
            return this.value;
        }

        Object getValueFromTable() {
            String string = this.getTableText();
            Debug.noteln("Text for " + this.pattern, Strings.quote(string));
            try {
                return ObjectWhiteboard.this.view.read(this.prop, string, this.value);
            }
            catch (Exception exception) {
                throw new RethrownException("Problem with the value for " + this.pattern + ":", exception);
            }
        }

        String getTableText() {
            Document document = this.td.getDocument();
            int n = this.td.getStartOffset();
            int n2 = this.td.getEndOffset();
            try {
                return document.getText(n, n2 - n - 1);
            }
            catch (BadLocationException badLocationException) {
                throw new RethrownException(badLocationException);
            }
        }

        void changeValue(Object object) {
            this.value = object;
            String string = ObjectWhiteboard.this.view.write(this.prop, object);
            this.writeTableText(string);
        }

        void writeTableText(String string) {
            HTMLDocument hTMLDocument = (HTMLDocument)this.td.getDocument();
            int n = this.td.getStartOffset();
            int n2 = this.td.getEndOffset();
            Debug.noteln("TD TEXT", Strings.quote(string));
            try {
                ObjectWhiteboard.this.frame.changingDocumnent = true;
                hTMLDocument.replace(n, n2 - n - 1, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new RethrownException(badLocationException);
            }
            finally {
                ObjectWhiteboard.this.frame.changingDocumnent = false;
                this.wasEdited = false;
            }
        }

        void delete() {
            this.changeValue(ObjectView.NO_VALUE);
        }

        public String toString() {
            return "Fact[" + this.pattern + "=" + this.value + "]";
        }
    }

    static class ViewHtmlStringWriter
    extends HtmlStringWriter {
        public ViewHtmlStringWriter() {
            this.setDefaultAttributes("tr", "align=\"left\"");
            this.setDefaultAttributes("th", "align=\"center\" bgcolor=\"#99ccff\"");
        }
    }

    class HtmlAnalyser
    extends HtmlTableWalker {
        Map state;

        HtmlAnalyser(Map map) {
            super(ObjectWhiteboard.this.objects, ObjectWhiteboard.this.properties);
            this.state = map;
        }

        public void walkTD(Element element, Object object, Object object2) {
            this.analyseTD(element, object, (ObjectProperty)object2);
        }

        void analyseTD(Element element, Object object, ObjectProperty objectProperty) {
            Debug.expectSame(HTML.Tag.TD, this.getTag(element));
            Fact fact = new Fact(object, objectProperty, element);
            fact.recordYourself();
            Object object2 = ObjectWhiteboard.this.getPropValue(objectProperty, object, this.state);
            fact.changeValue(object2);
        }
    }

    class ResetHook
    implements Runnable {
        ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", ObjectWhiteboard.this);
            ObjectWhiteboard.this.reset();
        }
    }
}

