/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.plan.Plan;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IFUtil;
import ix.ip2.Ip2;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.TextAreaFrame;
import ix.util.xml.XML;
import ix.util.xml.XMLTreeViewFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

class LoadPlanFrame
extends JFrame
implements ActionListener {
    Ip2 ip2;
    Plan plan;
    Container contentPane = this.getContentPane();

    LoadPlanFrame(Ip2 ip2, Activity activity, Plan plan) {
        super(ip2.getAgentDisplayName() + " Load Plan");
        this.ip2 = ip2;
        this.plan = plan;
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.makeMenuBar());
        Name name = activity.getSenderId();
        String string = "Received a load-plan request from " + (name == null ? "an unnamed agent" : name.toString());
        JLabel jLabel = new JLabel(string, 0);
        this.contentPane.add((Component)jLabel, "North");
        this.contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setVisible(true);
    }

    JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(IFUtil.makeMenuItem("Close", this));
        JMenu jMenu2 = new JMenu("View");
        jMenuBar.add(jMenu2);
        jMenu2.add(IFUtil.makeMenuItem("As XML", this));
        jMenu2.add(IFUtil.makeMenuItem("As Tree", this));
        return jMenuBar;
    }

    JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.makeButton("Load Plan in Current Option"));
        jPanel.add(this.makeButton("Replace Plan in Current Option"));
        jPanel.add(this.makeButton("Replace Plan in Current Option, Keeping State"));
        jPanel.add(this.makeButton("Finished"));
        return jPanel;
    }

    JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(CatchingActionListener.listener(this));
        jButton.setHorizontalAlignment(2);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("LoadPlanFrame action:", string);
        if (string.equals("Close")) {
            this.finished();
        } else if (string.equals("As XML")) {
            new TextViewFrame(this.plan);
        } else if (string.equals("As Tree")) {
            XMLTreeViewFrame xMLTreeViewFrame = new XMLTreeViewFrame(this.ip2, this.getTitle() + " Tree View");
            xMLTreeViewFrame.editObject(this.plan);
            xMLTreeViewFrame.setVisible(true);
        } else if (string.equals("Load Plan in Current Option")) {
            this.loadPlan();
        } else if (string.equals("Replace Plan in Current Option")) {
            this.replacePlan();
        } else if (string.equals("Replace Plan in Current Option, Keeping State")) {
            this.replacePlanKeepingState();
        } else if (string.equals("Finished")) {
            this.finished();
        } else {
            throw new ConsistencyException("Nothing to do for " + string);
        }
    }

    void loadPlan() {
        this.ip2.loadPlan(this.plan);
    }

    void replacePlan() {
        this.ip2.resetViewers();
        this.ip2.clearModel();
        this.ip2.loadPlan(this.plan);
    }

    void replacePlanKeepingState() {
        this.ip2.resetViewers();
        this.ip2.clearAllButState();
        this.ip2.loadPlan(this.plan);
    }

    void finished() {
        this.dispose();
    }

    class TextViewFrame
    extends TextAreaFrame {
        TextViewFrame(Object object) {
            super(LoadPlanFrame.this.getTitle() + " XML View", new String[]{"Cancel"});
            this.setText(XML.objectToXMLString(object));
            this.setVisible(true);
        }

        public void setText(String string) {
            super.setText(string);
            this.setCaretPosition(0);
        }

        public void whenClosed() {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }
}

