/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.Release;
import ix.ichat.ChatFrame;
import ix.icore.Activity;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.event.AgentNameEvent;
import ix.icore.plan.Plan;
import ix.iface.domain.DomainParser;
import ix.iface.domain.DomainWriter;
import ix.iface.ui.HelpFrame;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.ip2.AbstractAgendaItemPopupMenu;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.AnnotationViewer;
import ix.ip2.IVarTool;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.LoadDomainHandler;
import ix.ip2.LoadPlanHandler;
import ix.ip2.LoadStateHandler;
import ix.ip2.PanelFrame;
import ix.ip2.StateViewer;
import ix.ip2.UndoException;
import ix.iplan.IPlanOptionTool;
import ix.iplan.IPlanTool;
import ix.ispace.ISpaceTool;
import ix.iview.IDERelease;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.ISODateFormat;
import ix.util.Parameters;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class Ip2Frame
extends PanelFrame
implements ActionListener {
    protected Container contentPane;
    protected Ip2AboutFrame aboutFrame;
    protected AgendaViewer activityViewer;
    protected AgendaViewer issueViewer;
    protected StateViewer stateViewer;
    protected AnnotationViewer annotationViewer;
    protected Ip2 ip2;
    protected JPanel logoPanel;
    protected JMenuItem undoMenuItem;
    JSplitPane split1 = new JSplitPane(0);
    JSplitPane split2 = new JSplitPane(0);
    protected HelpFrame helpFrame = null;

    public Ip2Frame(Ip2 ip2) {
        super(ip2);
        this.ip2 = ip2;
    }

    protected void setUp() {
        this.setIconImage(IconImage.getIconImage(this));
        this.activityViewer = this.ip2.activityViewer;
        this.issueViewer = this.ip2.issueViewer;
        this.stateViewer = this.ip2.stateViewer;
        this.contentPane = this.getContentPane();
        this.setSize(500, 400);
        this.setJMenuBar(this.makeMenuBar());
        JPanel jPanel = new JPanel();
        jPanel.add((Component)((Object)this.issueViewer));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Issues"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)((Object)this.activityViewer));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Activities"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)((Object)this.stateViewer));
        JScrollPane jScrollPane3 = new JScrollPane(jPanel3);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("State"));
        this.split1.setTopComponent(jScrollPane);
        this.split1.setBottomComponent(this.split2);
        this.split2.setTopComponent(jScrollPane2);
        this.split2.setBottomComponent(jScrollPane3);
        this.contentPane.add(this.split1);
        this.logoPanel = this.ip2.makeLogoPanel();
        this.contentPane.add((Component)this.logoPanel, "South");
    }

    protected void becomeVisible() {
        if (Parameters.haveParameter("frame-size")) {
            Dimension dimension = Parameters.getDimension("frame-size");
            this.pack();
            this.setSize(dimension);
        } else {
            this.setReasonableSize();
        }
        super.validate();
        this.split1.setDividerLocation(0.33);
        this.split2.setDividerLocation(0.55);
        this.setVisible(true);
    }

    protected void setReasonableSize() {
        Dimension dimension = this.getSize();
        int n = (int)Math.round(dimension.getHeight());
        this.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        int n2 = (int)Math.round(dimension3.getWidth());
        int n3 = (int)Math.round(dimension3.getHeight());
        int n4 = (int)(0.875 * dimension2.getHeight());
        int n5 = 30;
        int n6 = Math.max(Math.min(n3, n4), n);
        if (n3 != n6) {
            this.setSize(new Dimension(n2 + n5, n6));
        }
    }

    public void symbolNameChanged(AgentNameEvent agentNameEvent) {
        super.symbolNameChanged(agentNameEvent);
        this.contentPane.remove(this.logoPanel);
        this.logoPanel = this.ip2.makeLogoPanel();
        this.contentPane.add((Component)this.logoPanel, "South");
        this.validate();
    }

    protected void addIp2Tools() {
        this.addTool(new ToolController("Domain Editor"){

            public Object createTool() {
                return Ip2Frame.this.makeDomainEditor(Ip2Frame.this.ip2, Ip2Frame.this.ip2.getDomain());
            }
        });
        this.addTool(new ToolController("I-Space"){

            public Object createTool() {
                return new ISpaceTool(Ip2Frame.this.ip2);
            }
        });
        this.addTool(new ToolController("I-Var"){

            public Object createTool() {
                return new IVarTool(Ip2Frame.this.ip2);
            }
        });
        this.addTool(new ToolController("I-Plan"){

            public Object createTool() {
                return new IPlanTool(Ip2Frame.this.ip2);
            }
        });
        if (this.ip2.showOptions) {
            this.addTool(new ToolController("I-Plan Options"){

                public Object createTool() {
                    return new IPlanOptionTool(Ip2Frame.this.ip2);
                }
            });
        }
        this.addTool(new ToolController("Messenger"){

            public Object createTool() {
                return new ChatFrame(Ip2Frame.this.ip2, Ip2Frame.this.ip2.getAgentDisplayName() + " Messenger");
            }
        });
        this.addTool(new ToolController("HTML Viewer"){

            public Object createTool() {
                return Ip2Frame.this.makeHTMLViewer();
            }
        });
    }

    protected HTMLViewer makeHTMLViewer() {
        String string = Parameters.getParameter("initial-html-viewer-home");
        if (string != null) {
            URL uRL = XML.toURL(string);
            if (uRL != null) {
                return new HTMLViewer(uRL);
            }
            Util.displayAndWait(this, new String[]{"Can't find " + string, "The HTML viewer will display the default", "page instead."});
        }
        return new HTMLViewer("ix-info.html");
    }

    public HTMLViewer ensureHTMLViewer() {
        return (HTMLViewer)this.toolManager.findToolElseError("HTML Viewer").ensureToolVisible();
    }

    public HelpFrame ensureHelpFrame() {
        return this.ensureHelpFrame("ip2-help.html");
    }

    public HelpFrame ensureHelpFrame(String string) {
        if (this.helpFrame == null) {
            this.helpFrame = new Ip2HelpFrame(string);
        } else {
            this.helpFrame.displayURL(UIUtil.resourceURL(string));
        }
        this.helpFrame.setVisible(true);
        return this.helpFrame;
    }

    public void ensureAboutIP2() {
        this.ensureAboutFrame(this.ip2.getAgentTypeName(), this.makeAboutText());
    }

    public void ensureAboutFrame(String string, String string2) {
        String string3 = this.ip2.getAgentDisplayName() + " About " + string;
        if (this.aboutFrame == null) {
            this.aboutFrame = new Ip2AboutFrame(string3);
        } else {
            this.aboutFrame.setTitle(string3);
        }
        this.aboutFrame.setText(string2);
        this.aboutFrame.setVisible(true);
    }

    public String makeAboutText() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("I-X version: " + Release.version + ", release date " + Release.date);
        linkedList.add("I-DE version: " + IDERelease.version + ", release date " + IDERelease.date);
        linkedList.add("Agent class: " + this.ip2.getClass().getName());
        linkedList.add("Started running: " + new ISODateFormat().formatDateTime(this.ip2.getAgentStartupDate()));
        linkedList.add("Java version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"));
        Properties properties = Parameters.getParameters();
        TreeSet treeSet = new TreeSet(((Hashtable)properties).keySet());
        linkedList.add("");
        if (treeSet.isEmpty()) {
            linkedList.add("Parameters: none");
        } else {
            linkedList.add("Parameters: ");
            for (String string : treeSet) {
                String string2 = (String)((Hashtable)properties).get(string);
                linkedList.add("   " + string + " = " + string2 + (Parameters.usedParameter(string) ? "" : " [unused]"));
            }
        }
        this.ip2.addAboutInfo(linkedList);
        this.ip2.getController().addAboutInfo(linkedList);
        XML.fileSyntaxManager().addAboutInfo(linkedList);
        return Strings.joinLines(linkedList);
    }

    public void ensureAboutSyntax() {
        this.ensureAboutFrame("Syntax", this.makeSyntaxText());
    }

    public String makeSyntaxText() {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = this.ip2.getController().getIssueAgenda().getSyntaxList();
        List list2 = this.ip2.getController().getActivityAgenda().getSyntaxList();
        this.addHandlerSyntax(linkedList, "Issue", list);
        linkedList.add("");
        this.addHandlerSyntax(linkedList, "Activity", list2);
        linkedList.add("");
        this.addExpansionSyntax(linkedList);
        return Strings.joinLines(linkedList);
    }

    private void addHandlerSyntax(List list, String string, List list2) {
        if (list2.isEmpty()) {
            list.add(string + " patterns from handlers: none");
        } else {
            list.add(string + " patterns from handlers:");
            Iterator iterator = this.sortedStrings(list2).iterator();
            while (iterator.hasNext()) {
                list.add("   " + iterator.next());
            }
        }
    }

    private SortedSet sortedStrings(List list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (LList lList : list) {
            treeSet.add(PatternParser.unparse(lList));
        }
        return treeSet;
    }

    private void addExpansionSyntax(List list) {
        List list2 = (List)Collect.map(new LinkedList(), this.ip2.getDomain().getRefinements(), Fn.accessor(Refinement.class, "getPattern"));
        if (list2.isEmpty()) {
            list.add("Activity patterns from domain refinements: none");
        } else {
            list.add("Activity patterns from domain refinements:");
            Iterator iterator = this.sortedStrings(list2).iterator();
            while (iterator.hasNext()) {
                list.add("   " + iterator.next());
            }
        }
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("Load Plan/State From ..."));
        jMenu.add(this.makeMenuItem("Save Plan/State As ..."));
        jMenu.add(this.makeMenuItem("Send Plan"));
        jMenu.add(this.makeMenuItem("Send State"));
        jMenu.addSeparator();
        jMenu.add(this.makeMenuItem("Load Domain From ..."));
        jMenu.add(this.makeMenuItem("Save Domain As ..."));
        jMenu.add(this.makeMenuItem("Send Domain"));
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Reset");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(this.makeMenuItem("Exit"));
        jMenu2.add(this.makeMenuItem("Reset All"));
        jMenu2.add(this.makeMenuItem("Reset All But State"));
        JMenu jMenu3 = new JMenu("New");
        jMenuBar.add(jMenu3);
        jMenu3.add(this.makeMenuItem("New Issue"));
        jMenu3.add(this.makeMenuItem("New Activity"));
        jMenu3.add(this.makeMenuItem("New Constraint"));
        jMenu3.add(this.makeMenuItem("New Annotation"));
        JMenu jMenu4 = new JMenu("Edit");
        jMenuBar.add(jMenu4);
        this.undoMenuItem = this.makeMenuItem("Undo");
        jMenu4.add(this.undoMenuItem);
        jMenuBar.add(this.toolManager.getToolsMenu());
        this.addIp2Tools();
        JMenu jMenu5 = new JMenu("Help");
        jMenuBar.add(jMenu5);
        jMenu5.add(this.makeMenuItem("Help"));
        jMenu5.add(this.makeMenuItem("About " + this.ip2.getAgentTypeName()));
        jMenu5.add(this.makeMenuItem("About Syntax"));
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.testMenu);
        if (this.testMenu.getMenuComponentCount() == 0) {
            this.testMenu.setEnabled(false);
        }
        this.ip2.addTestMenuItems();
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-P2 action:", string);
        if (string.equals("Exit")) {
            if (Util.dialogConfirms(this.ip2.getFrame(), "Are you sure you want to exit?")) {
                this.ip2.exit();
            }
        } else if (string.equals("Reset All")) {
            if (Util.dialogConfirms(this.ip2.getFrame(), "Are you sure you want to reset everything?")) {
                this.ip2.reset();
            }
        } else if (string.equals("Reset All But State")) {
            if (Util.dialogConfirms(this.ip2.getFrame(), "Are you sure you want to reset all but state?")) {
                this.ip2.resetAllButState();
            }
        } else if (string.equals("Load Plan/State From ...")) {
            this.ip2.loadPlan();
        } else if (string.equals("Save Plan/State As ...")) {
            this.ip2.savePlanAs();
        } else if (string.equals("Send Plan")) {
            Plan plan = this.ip2.getModelManager().getPlan();
            Activity activity = new Activity(Lisp.list(LoadPlanHandler.S_LOAD_PLAN, plan));
            this.getSendPanelVisible().initActivity(activity);
        } else if (string.equals("Send State")) {
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.ip2.getModelManager();
            Map map = ip2ModelManager.getWorldStateMap();
            Plan plan = new Plan();
            plan.setWorldState(map);
            Activity activity = new Activity(Lisp.list(LoadStateHandler.S_LOAD_STATE, plan));
            this.getSendPanelVisible().initActivity(activity);
        } else if (string.equals("Load Domain From ...")) {
            DomainParser.loadDomain(this, this.ip2.getDomain());
        } else if (string.equals("Save Domain As ...")) {
            DomainWriter.saveDomain(this, this.ip2.getDomain());
        } else if (string.equals("Send Domain")) {
            Domain domain = this.ip2.getDomain();
            Activity activity = new Activity(Lisp.list(LoadDomainHandler.S_LOAD_DOMAIN, domain));
            this.getSendPanelVisible().initActivity(activity);
        } else if (string.equals("New Issue")) {
            this.issueViewer.getNewItemFromUser();
        } else if (string.equals("New Activity")) {
            this.activityViewer.getNewItemFromUser();
        } else if (string.equals("New Constraint")) {
            this.newConstraint();
        } else if (string.equals("New Annotation")) {
            this.annotationViewer.getNewItemFromUser();
        } else if (string.equals("Undo")) {
            try {
                this.ip2.getIp2ModelManager().undo();
            }
            catch (UndoException.NoFurtherUndo noFurtherUndo) {
                Util.displayAndWait(this, "Cannot undo further.");
            }
        } else if (string.equals("Help")) {
            this.ensureHelpFrame();
        } else if (string.startsWith("About ") && string.endsWith(this.ip2.getAgentTypeName())) {
            this.ensureAboutIP2();
        } else if (string.equals("About Syntax")) {
            this.ensureAboutSyntax();
        } else {
            throw new UnsupportedOperationException("Nothing to do for " + string);
        }
    }

    protected void newConstraint() {
        String string = JOptionPane.showInputDialog(this, (Object)"Enter constraint as pattern=value");
        if (string == null) {
            return;
        }
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (string3.equals("")) {
            string3 = "true";
        }
        LList lList = Lisp.elementsFromString(string2);
        Object object = Lisp.readFromString(string3);
        Constraint constraint = new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(lList, object)));
        this.ip2.getModelManager().addConstraint(constraint);
    }

    public void adjustAgendaItemPopup(AbstractAgendaItemPopupMenu abstractAgendaItemPopupMenu, AgendaItem agendaItem) {
    }

    public static class Ip2AboutFrame
    extends TextAreaFrame {
        public Ip2AboutFrame(String string) {
            super(0, 0, string, new String[]{"Cancel"});
            this.setEditable(false);
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 300);
            this.frame.validate();
        }

        public void setText(String string) {
            Debug.noteln("About text", string);
            super.setText(string);
            this.setCaretPosition(0);
        }
    }

    class Ip2HelpFrame
    extends HelpFrame {
        Ip2HelpFrame(String string) {
            super(string);
            this.setTitle(Ip2Frame.this.ip2.getAgentDisplayName() + " Help");
            this.setIconImage(IconImage.getIconImage("ip2-help-icon.gif"));
        }
    }

    class HTMLViewer
    extends HelpFrame {
        HTMLViewer(String string) {
            super(string);
            this.setup();
        }

        HTMLViewer(URL uRL) {
            super(uRL);
            this.setup();
        }

        protected void setup() {
            this.setTitle(Ip2Frame.this.ip2.getAgentDisplayName() + " HTML Viewer");
            this.setIconImage(IconImage.getIconImage("ip2-help-icon.gif"));
        }
    }
}

