/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ichat.ChatMessage;
import ix.icore.AbstractIXObject;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.ListOfPatternAssignment;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.plan.Plan;
import ix.icore.process.ProcessModelManager;
import ix.iface.domain.DomainParser;
import ix.iface.util.KeyValueTable;
import ix.iface.util.LogoPanel;
import ix.iface.util.ToolController;
import ix.ip2.ActivityHandler;
import ix.ip2.ActivityItem;
import ix.ip2.ActivityTableViewer;
import ix.ip2.ActivityViewTable;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.AnnotationViewTable;
import ix.ip2.AnnotationViewer;
import ix.ip2.CompletionHandler;
import ix.ip2.ConditionHandler;
import ix.ip2.ConnectHandler;
import ix.ip2.ExpandHandler;
import ix.ip2.ForwardingHandler;
import ix.ip2.HandlerAction;
import ix.ip2.InvokeHandler;
import ix.ip2.Ip2Frame;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueItem;
import ix.ip2.IssueTableViewer;
import ix.ip2.IssueViewTable;
import ix.ip2.ItemHandler;
import ix.ip2.LoadDomainHandler;
import ix.ip2.LoadPlanFrame;
import ix.ip2.LoadPlanHandler;
import ix.ip2.LoadStateHandler;
import ix.ip2.NewIp2Frame;
import ix.ip2.PanelController;
import ix.ip2.QueryHandler;
import ix.ip2.SendReportHandler;
import ix.ip2.SetCapabilitiesHandler;
import ix.ip2.ShowURLHandler;
import ix.ip2.StateViewTable;
import ix.ip2.StateViewer;
import ix.ip2.SyncSimulationTimeHandler;
import ix.ip2.TransformToActivityHandler;
import ix.ip2.event.AgendaListener;
import ix.ip2.test.TestElement;
import ix.iplan.IPlanOptionManager;
import ix.ispace.AgentRelationship;
import ix.test.MatchStateHandler;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import ix.util.xml.XMLLoader;
import ix.util.xml.XMLSaver;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Ip2
extends IXAgent {
    protected Domain domain = new Domain();
    protected ProcessModelManager modelManager;
    protected PanelController controller;
    protected IPlanOptionManager optionManager;
    protected List resetHooks = new LinkedList();
    protected Ip2Frame frame;
    boolean classic;
    protected AgendaViewer activityViewer;
    protected AgendaViewer issueViewer;
    protected StateViewer stateViewer;
    protected AnnotationViewer annotationViewer;
    protected String agentTypeName;
    protected String logoLine1 = this.agentTypeName = "I-X Process Panel";
    protected String logoLine2 = "Based on I-X Technology";
    protected String logoImage = "ip2-logo.gif";
    protected boolean showOptions = false;
    private boolean in_reloadViewers = false;

    public Ip2() {
        this.displayName = "Process Panel";
    }

    protected Ip2(boolean bl) {
        super(bl);
        this.displayName = "Process Panel";
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-P2");
        new Ip2().mainStartup(stringArray);
    }

    public String getAgentTypeName() {
        return this.agentTypeName;
    }

    public PanelController getController() {
        return this.controller;
    }

    public ProcessModelManager getModelManager() {
        return this.modelManager;
    }

    public Ip2ModelManager getIp2ModelManager() {
        return (Ip2ModelManager)this.modelManager;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public Plan getPlan() {
        return this.modelManager.getPlan();
    }

    public IPlanOptionManager getOptionManager() {
        return this.optionManager;
    }

    public Ip2Frame getFrame() {
        return this.frame;
    }

    public SortedSet getActivityPatternSyntaxes() {
        TreeSet treeSet = new TreeSet(new KeyValueTable.LexicographicComparator());
        treeSet.addAll(this.controller.getActivityAgenda().getSyntaxList());
        treeSet.addAll(Collect.map(new LinkedList(), this.getDomain().getRefinements(), Fn.accessor(Refinement.class, "getPattern")));
        return treeSet;
    }

    protected ProcessModelManager makeModelManager() {
        return new Ip2ModelManager(this);
    }

    protected PanelController makeController() {
        return new PanelController(this);
    }

    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
        this.logoLine1 = Parameters.getParameter("logo-line-1", this.logoLine1);
        this.logoLine2 = Parameters.getParameter("logo-line-2", this.logoLine2);
        this.logoImage = Parameters.getParameter("logo-image", this.logoImage);
        this.showOptions = Parameters.haveParameter("option-directory") || Parameters.getBoolean("show-options", this.showOptions);
        this.classic = Parameters.getBoolean("classic", false);
    }

    public void startup() {
        this.modelManager = this.makeModelManager();
        this.controller = this.makeController();
        this.controller.connectTo(this.modelManager);
        this.optionManager = new IPlanOptionManager(this);
        this.optionManager.connectYourself();
        this.frame = this.makeIp2Frame();
        Debug.recordMainFrame(this.frame);
        this.activityViewer = this.makeActivityViewer();
        this.issueViewer = this.makeIssueViewer();
        this.stateViewer = this.makeStateViewer();
        this.annotationViewer = this.makeAnnotationViewer();
        this.controller.addActivityListener((AgendaListener)((Object)this.activityViewer));
        this.controller.addIssueListener((AgendaListener)((Object)this.issueViewer));
        this.modelManager.addProcessStatusListener(this.stateViewer);
        this.modelManager.addAnnotationListener(this.annotationViewer);
        this.addHandlers();
        this.addHandlers(Parameters.getList("additional-handlers"));
        this.readDomain(this.domain);
        this.frame.setUp();
        Util.swingAndWait(new Runnable(){

            public void run() {
                Ip2.this.completeStartup();
            }
        });
    }

    protected void completeStartup() {
        this.frame.becomeVisible();
        this.installAgentExtensions();
        this.initOptions();
        this.loadInitialPlan();
    }

    protected void initOptions() {
        if (this.showOptions) {
            this.optionManager.initOptions();
        } else {
            this.optionManager.initOneOption();
        }
    }

    public void reset() {
        this.modelManager.reset();
        this.controller.reset();
        this.resetViewers();
        Util.runHooks("reset", this.resetHooks);
    }

    public void resetViewers() {
        if (this.activityViewer != null) {
            this.activityViewer.reset();
        }
        if (this.issueViewer != null) {
            this.issueViewer.reset();
        }
        if (this.stateViewer != null) {
            this.stateViewer.reset();
        }
        if (this.annotationViewer != null) {
            this.annotationViewer.reset();
        }
        if (this.frame != null) {
            this.frame.validate();
        }
    }

    public void resetAllButState() {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.modelManager;
        ListOfPatternAssignment listOfPatternAssignment = PatternAssignment.mapToAssignments(ip2ModelManager.getWorldStateMap());
        this.reset();
        ip2ModelManager.handleEffects(listOfPatternAssignment);
    }

    public void clearModel() {
        this.modelManager.clear();
        this.controller.clearModel();
    }

    public void clearAllButState() {
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.modelManager;
        ListOfPatternAssignment listOfPatternAssignment = PatternAssignment.mapToAssignments(ip2ModelManager.getWorldStateMap());
        this.clearModel();
        ip2ModelManager.handleEffects(listOfPatternAssignment);
    }

    public void addResetHook(Runnable runnable) {
        this.resetHooks.add(runnable);
    }

    public void exit() {
        System.exit(0);
    }

    protected Ip2Frame makeIp2Frame() {
        return this.classic ? new Ip2Frame(this) : new NewIp2Frame(this);
    }

    public void addAboutInfo(List list) {
    }

    protected AgendaViewer makeActivityViewer() {
        if (this.classic) {
            return new ActivityViewTable(this);
        }
        return (AgendaViewer)this.makeViewer("activity-viewer-class", ActivityTableViewer.class);
    }

    protected AgendaViewer makeIssueViewer() {
        if (this.classic) {
            return new IssueViewTable(this);
        }
        return (AgendaViewer)this.makeViewer("issue-viewer-class", IssueTableViewer.class);
    }

    protected StateViewer makeStateViewer() {
        return (StateViewer)this.makeViewer("state-viewer-class", StateViewTable.class);
    }

    protected AnnotationViewer makeAnnotationViewer() {
        return (AnnotationViewer)this.makeViewer("annotation-viewer-class", AnnotationViewTable.class);
    }

    protected Object makeViewer(String string, Class clazz) {
        Class clazz2 = Parameters.getClass(string, clazz);
        Class[] classArray = new Class[]{Ip2.class};
        try {
            Constructor constructor = clazz2.getConstructor(classArray);
            return constructor.newInstance(this);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new RethrownException(exception, "Cannot instantiate " + string + " class " + clazz2.getName() + " because " + Debug.describeException(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadViewers() {
        try {
            this.in_reloadViewers = true;
            this.do_reloadViewers();
        }
        finally {
            this.in_reloadViewers = false;
        }
    }

    public boolean isReloadingViewers() {
        return this.in_reloadViewers;
    }

    protected void do_reloadViewers() {
        Object object;
        Object object22;
        Debug.noteln("Realoding viewers");
        Ip2 ip2 = this;
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)ip2.getModelManager();
        PanelController panelController = ip2.getController();
        Agenda agenda = panelController.getIssueAgenda();
        List list = agenda.getItems();
        for (Object object22 : list) {
            agenda.fireItemAdded((AgendaItem)object22);
        }
        Agenda agenda2 = panelController.getActivityAgenda();
        object22 = agenda2.getItems();
        Object object3 = object22.iterator();
        while (object3.hasNext()) {
            object = (ActivityItem)object3.next();
            agenda2.fireItemAdded((AgendaItem)object);
        }
        object3 = ip2ModelManager.getWorldStateMap();
        ip2ModelManager.fireStateChange((Map)object3);
        object = ip2ModelManager.getAnnotations();
        if (object != null) {
            for (Map.Entry entry : ((StableHashMap)object).entrySet()) {
                ip2ModelManager.fireSetAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void readDomain(Domain domain) {
        List list = Parameters.getList("domain");
        for (String string : list) {
            try {
                this.readDomain(domain, string);
            }
            catch (Exception exception) {
                Debug.displayException("Problem with domain " + string, exception);
                if (Parameters.isInteractive()) continue;
                throw new RethrownException(exception);
            }
        }
    }

    public void readDomain(Domain domain, String string) {
        Serializable serializable;
        Debug.noteln("Loading a domain from", string);
        URL uRL = XML.toURL(string);
        if (uRL == null) {
            Debug.noteln("Trying " + string + " as file in lib dir");
            serializable = new File(string);
            if (((File)serializable).getParentFile() == null) {
                File file = DomainParser.getLibraryDirectory();
                Debug.noteln("Resolving " + serializable + " against " + file);
                serializable = new File(file, ((File)serializable).getPath());
                string = ((File)serializable).getPath();
                if (((File)serializable).exists()) {
                    try {
                        uRL = ((File)serializable).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.noteException(malformedURLException);
                        throw new ConsistencyException("Unexpected", (Object)malformedURLException);
                    }
                }
            }
            if (uRL == null) {
                throw new IllegalArgumentException("Can't find a domain named " + Strings.quote(string));
            }
        }
        serializable = (Domain)XML.readObject(Domain.class, uRL);
        ((Domain)serializable).checkConsistency();
        domain.takeFrom((Domain)serializable);
    }

    public void loadDomain(Domain domain) {
        domain.checkConsistency();
        this.domain.takeFrom(domain);
    }

    public JPanel makeLogoPanel() {
        ImageIcon imageIcon = null;
        try {
            imageIcon = Parameters.haveParameter("logo-image") ? Util.getImageIcon(this.logoImage) : Util.resourceImageIcon(this.logoImage);
        }
        catch (Exception exception) {
            Debug.displayException(exception);
        }
        return new LogoPanel(this.symbolName, this.logoLine1, this.logoLine2, imageIcon);
    }

    protected void loadInitialPlan() {
        if (Parameters.haveParameter("plan")) {
            List list = Parameters.getList("plan");
            for (String string : list) {
                try {
                    this.loadPlan(string);
                }
                catch (Throwable throwable) {
                    Debug.displayException(throwable);
                    if (Parameters.isInteractive()) continue;
                    throw new RethrownException(throwable);
                }
            }
        }
    }

    public void loadPlan() {
        Plan plan = (Plan)new XMLLoader(this.frame, Plan.class).loadObject();
        if (plan != null) {
            this.loadPlan(plan);
        }
    }

    public void loadPlan(String string) {
        Debug.noteln("Loading a plan from", string);
        Plan plan = (Plan)XML.readObject(Plan.class, string);
        this.loadPlan(plan);
    }

    public void loadPlan(Plan plan) {
        this.modelManager.setPlan(plan);
    }

    public void savePlanAs() {
        Plan plan = this.modelManager.getPlan();
        new XMLSaver(this.frame, Plan.class).saveObject(plan);
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        AbstractIXObject abstractIXObject;
        Object object = inputMessage.getContents();
        if ((object instanceof Issue || object instanceof Activity) && this.controller.canHandleAutomatically((TaskItem)(abstractIXObject = (TaskItem)object))) {
            this.handleReceivedReport((TaskItem)abstractIXObject);
            this.controller.handleAutomatically((TaskItem)abstractIXObject);
            return;
        }
        if (inputMessage.getAnnotation("is-external") != Boolean.TRUE) {
            this.handleInputDirectly(inputMessage);
        } else if (object instanceof ChatMessage) {
            this.handleInputDirectly(inputMessage);
        } else if (object instanceof Report) {
            this.optionManager.handleReportWhenOptions(inputMessage);
        } else {
            abstractIXObject = this.getPlanIfLoadPlanRequest(inputMessage);
            if (abstractIXObject != null) {
                new LoadPlanFrame(this, (Activity)object, (Plan)abstractIXObject);
            } else if (this.optionManager.canTakeInput()) {
                this.handleInputDirectly(inputMessage);
            } else {
                this.optionManager.recordDelayedInput(inputMessage);
            }
        }
    }

    public void handleInputDirectly(IPC.InputMessage inputMessage) {
        super.handleInput(inputMessage);
    }

    private Plan getPlanIfLoadPlanRequest(IPC.InputMessage inputMessage) {
        Activity activity;
        LList lList;
        String string;
        Object object = inputMessage.getContents();
        if (object instanceof Activity && ((string = (lList = (activity = (Activity)object).getPattern()).get(0).toString()).equals("load-plan") || string.equals("load-state")) && lList.get(1) instanceof Plan) {
            Plan plan = (Plan)lList.get(1);
            return plan;
        }
        return null;
    }

    public void handleNewIssue(Issue issue) {
        this.handleReceivedReport(issue);
        IssueItem issueItem = this.controller.addIssue(issue);
        issueItem.setIsNew(true);
    }

    public void handleNewActivity(Activity activity) {
        this.handleReceivedReport(activity);
        ActivityItem activityItem = this.controller.addActivity(activity);
        activityItem.setIsNew(true);
    }

    public void handleNewConstraint(Constraint constraint) {
        this.modelManager.addConstraint(constraint);
    }

    public void handleNewReport(Report report) {
        this.controller.newReport(report);
        List list = report.getConstraints();
        if (list != null) {
            for (Constraint constraint : list) {
                this.handleNewConstraint(constraint);
            }
        }
    }

    public void handleNewChatMessage(ChatMessage chatMessage) {
        this.frame.getChatFrameVisible().newMessage(chatMessage);
    }

    public void addTool(ToolController toolController) {
        this.frame.addTool(toolController);
    }

    public Object ensureTool(String string) {
        if (this.frame == null) {
            throw new IllegalArgumentException("There is no tool named " + Strings.quote(string));
        }
        ToolController toolController = this.frame.toolManager.findToolElseError(string);
        return toolController.ensureTool();
    }

    protected void addTestMenuItems() {
        this.frame.addTestResources(Parameters.getList("test-menu"));
    }

    public void addTest(TestElement testElement) {
        testElement.addToMenu(this.frame);
    }

    protected void addHandlers(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            ItemHandler itemHandler = null;
            try {
                itemHandler = ItemHandler.makeHandler(this, string);
            }
            catch (Exception exception) {
                Debug.displayException("Cannot make a handler of class " + string, exception);
                continue;
            }
            Debug.expect(itemHandler != null);
            this.controller.addHandler(itemHandler);
        }
    }

    protected void addHandlers() {
        this.controller.addItemHandler(new CompletionHandler(this));
        this.controller.addActivityHandler(new ConditionHandler(this));
        this.controller.addIssueHandler(new TransformToActivityHandler(this));
        this.controller.addActivityHandler(new ExpandHandler(this));
        this.controller.addItemHandler(new InvokeHandler(this));
        this.addForwardingHandler("Escalate", AgentRelationship.SUPERIOR, true);
        this.addForwardingHandler("Pass", AgentRelationship.PEER, true);
        this.addForwardingHandler("Delegate", AgentRelationship.SUBORDINATE, true);
        this.controller.addActivityHandler(new ConnectHandler(this));
        this.controller.addActivityHandler(new SetCapabilitiesHandler(this));
        this.controller.addActivityHandler(new AddHandlersHandler());
        this.controller.addActivityHandler(new SendReportHandler());
        this.controller.addActivityHandler(new QueryHandler());
        this.controller.addActivityHandler(new QueryHandler.AnswerHandler());
        this.controller.addActivityHandler(new LoadPlanHandler(this));
        this.controller.addActivityHandler(new LoadStateHandler(this));
        this.controller.addActivityHandler(new LoadDomainHandler(this));
        this.controller.addActivityHandler(new ShowURLHandler(this));
        this.controller.addActivityHandler(new MatchStateHandler(this, "select"));
        this.controller.addActivityHandler(new SyncSimulationTimeHandler(this));
    }

    public void addForwardingHandler(String string, AgentRelationship agentRelationship, boolean bl) {
        this.controller.addItemHandler(new ForwardingHandler(this, string, agentRelationship, bl));
    }

    public class AddHandlersHandler
    extends ActivityHandler {
        Symbol S_ADD_HANDLERS;

        public AddHandlersHandler() {
            super("Add issue or activity handlers");
            this.S_ADD_HANDLERS = Symbol.intern("add-handlers");
        }

        public List getSyntaxList() {
            return (LList)Lisp.readFromString("((add-handlers ?class-name ...))");
        }

        public boolean appliesTo(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            return lList.length() > 1 && lList.get(0) == this.S_ADD_HANDLERS;
        }

        public void addHandlerActions(AgendaItem agendaItem) {
            agendaItem.addAction(new HandlerAction.AutomaticWhenBound(agendaItem, this));
        }

        public void handle(AgendaItem agendaItem) {
            LList lList = (LList)Variable.removeVars(agendaItem.getPattern());
            LList lList2 = lList.cdr();
            Ip2.this.addHandlers(lList2);
            agendaItem.setStatus(Status.COMPLETE);
        }
    }
}

