/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Status;
import ix.icore.Variable;
import ix.ip2.ActionUnreadyReason;
import ix.ip2.AgendaItem;
import ix.ip2.ItemHandler;
import ix.ip2.UnboundVariablesUnreadyReason;
import ix.util.Debug;

public class HandlerAction {
    protected String shortDescription;

    public String getActionDescription() {
        return this.shortDescription;
    }

    public void handle(AgendaItem agendaItem) {
        Debug.noteln("HandlerAction " + this.shortDescription + " handling item " + agendaItem);
        agendaItem.setStatus(Status.COMPLETE);
    }

    public boolean canAlwaysBeTakenNow() {
        return false;
    }

    public boolean isStillValid() {
        return true;
    }

    public boolean isReady() {
        return true;
    }

    public void computeStatus() {
    }

    public ActionUnreadyReason getUnreadyReason() {
        return null;
    }

    public String toString() {
        return "HandlerAction[" + this.shortDescription + "]";
    }

    public static class NotApplicable
    extends Manual {
        public NotApplicable() {
            this.shortDescription = "N/A";
        }
    }

    public static class Manual
    extends HandlerAction {
        public Manual() {
            this.shortDescription = "Done";
        }

        public Manual(String string) {
            this.shortDescription = "Done using " + string;
        }
    }

    public static class AutomaticWhenBound
    extends Automatic {
        AgendaItem item;

        public AutomaticWhenBound(AgendaItem agendaItem, ItemHandler itemHandler) {
            super(itemHandler);
            this.item = agendaItem;
        }

        public AutomaticWhenBound(AgendaItem agendaItem, ItemHandler itemHandler, String string) {
            super(itemHandler, string);
            this.item = agendaItem;
        }

        public boolean isReady() {
            return Variable.isFullyBound(this.item.getPattern());
        }

        public ActionUnreadyReason getUnreadyReason() {
            return new UnboundVariablesUnreadyReason((HandlerAction)this, this.item);
        }
    }

    public static class Automatic
    extends HandlerAction {
        ItemHandler handler;

        public Automatic(ItemHandler itemHandler) {
            this(itemHandler, itemHandler.getActionDescription());
        }

        public Automatic(ItemHandler itemHandler, String string) {
            this.handler = itemHandler;
            this.shortDescription = string;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("Giving item to handler", this.handler);
            this.handler.handle(agendaItem);
        }
    }

    public static class NoAction
    extends HandlerAction {
        public static final String NO_ACTION_DESCRIPTION = "   ";

        public NoAction() {
            this.shortDescription = NO_ACTION_DESCRIPTION;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.noteln("No action for", agendaItem);
            Debug.expect(agendaItem.getHandledBy() == this);
            agendaItem.setHandledBy(null);
        }
    }
}

