/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.ConstraintManager;
import ix.icore.domain.Constraint;
import ix.icore.process.PNode;
import ix.ip2.Ip2ModelManager;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstraintAssociator {
    protected Ip2ModelManager mm;
    protected Set<ConstraintManager> constraintManagers = new LinkedHashSet<ConstraintManager>();
    protected Map<Symbol, List<ConstraintManager>> dispatchTable = new LinkedHashMap<Symbol, List<ConstraintManager>>();

    public ConstraintAssociator(Ip2ModelManager ip2ModelManager) {
        this.mm = ip2ModelManager;
    }

    public void reset() {
        for (ConstraintManager constraintManager : this.constraintManagers) {
            constraintManager.reset();
        }
    }

    public void clear() {
        for (ConstraintManager constraintManager : this.constraintManagers) {
            constraintManager.clear();
        }
    }

    public void addConstraintManager(String string, ConstraintManager constraintManager) {
        this.addConstraintManager(Symbol.intern(string), constraintManager);
    }

    public void addConstraintManager(Symbol symbol, ConstraintManager constraintManager) {
        this.constraintManagers.add(constraintManager);
        List<ConstraintManager> list = this.dispatchTable.get(symbol);
        if (list == null) {
            list = new LinkedList<ConstraintManager>();
            this.dispatchTable.put(symbol, list);
        }
        list.add(constraintManager);
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        Symbol symbol = constraint.getType();
        List<ConstraintManager> list = this.dispatchTable.get(symbol);
        if (list == null) {
            Debug.noteln("Can't handle " + constraint + " at " + pNode);
            return;
        }
        for (ConstraintManager constraintManager : list) {
            constraintManager.addConstraint(pNode, constraint);
        }
    }
}

