/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Variable;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.ToolFrame;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class BindingViewer
implements ActionListener {
    protected IXAgent agent;
    protected Set vars;
    protected Map possibleValues;
    protected JFrame frame;
    protected Container contentPane;
    protected VarPanel varPanel;

    public BindingViewer(IXAgent iXAgent, Set set, Map map) {
        this.agent = iXAgent;
        this.vars = set;
        this.possibleValues = map;
        this.setUpFrame();
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.agent.getAgentDisplayName() + " Variable Binder");
        this.contentPane = this.frame.getContentPane();
        this.varPanel = new VarPanel(this.vars);
        this.contentPane.add((Component)this.varPanel, "Center");
        this.contentPane.add((Component)new ButtonPanel(), "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("BindingViewer action:", string);
        if (string.equals("Bind")) {
            this.handleBindings(this.varPanel.getBindings());
        } else if (string.equals("Finished")) {
            this.frame.setVisible(false);
        } else {
            throw new ConsistencyException("Nothing to do for", string);
        }
    }

    public abstract void handleBindings(Map var1);

    public void resetPossibleValues(Map map) {
        this.possibleValues = map;
        this.varPanel.resetPossibles(map);
        this.frame.validate();
    }

    static class Value {
        Object v;

        Value(Object object) {
            this.v = object;
        }

        Object get() {
            return this.v;
        }

        public String toString() {
            return Lisp.printToString(this.v);
        }
    }

    class ValComboBox
    extends JComboBox {
        public ValComboBox(Variable variable) {
            if (variable.isBound()) {
                Value value = new Value(variable.getValue());
                this.addItem(value);
                this.setSelectedItem(value);
                this.setEnabled(false);
                return;
            }
            this.addItem(" ");
            Set set = (Set)BindingViewer.this.possibleValues.get(variable);
            for (Object e : set) {
                this.addItem(new Value(e));
            }
            this.setSelectedItem(" ");
        }
    }

    class VarPanel
    extends JPanel {
        GridColumn varColumn = new GridColumn("Variable");
        GridColumn valColumn = new GridColumn("Value");
        Map varFields = new HashMap();
        List varList;

        VarPanel(Set set) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.add(this.varColumn);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.valColumn);
            this.varList = new LinkedList(set);
            Collections.sort(this.varList);
            for (Variable variable : this.varList) {
                JTextField jTextField = new JTextField(variable.getName().toString());
                jTextField.setEditable(false);
                this.varColumn.add(jTextField);
                JComponent jComponent = this.makeValField(variable);
                this.varFields.put(variable, jComponent);
                this.valColumn.add(jComponent);
            }
        }

        JComponent makeValField(Variable variable) {
            Set set = (Set)BindingViewer.this.possibleValues.get(variable);
            return set == null ? new JTextField(20) : new ValComboBox(variable);
        }

        void resetPossibles(Map map) {
            for (Variable variable : map.keySet()) {
                JComponent jComponent = (JComponent)this.varFields.get(variable);
                JComponent jComponent2 = this.makeValField(variable);
                this.valColumn.replace(jComponent, jComponent2);
                this.varFields.put(variable, jComponent2);
            }
        }

        Map getBindings() {
            HashMap<Variable, Object> hashMap = new HashMap<Variable, Object>();
            for (Variable variable : this.varList) {
                JComponent jComponent = (JComponent)this.varFields.get(variable);
                Object object = null;
                if (jComponent.isEnabled()) {
                    Object object2;
                    JComponent jComponent2;
                    if (jComponent instanceof JTextField) {
                        jComponent2 = (JTextField)jComponent;
                        object2 = ((JTextComponent)jComponent2).getText();
                        if (!((String)(object2 = ((String)object2).trim())).equals("")) {
                            object = Lisp.readFromString((String)object2);
                            jComponent2.setEnabled(false);
                        }
                    } else {
                        jComponent2 = (ValComboBox)jComponent;
                        object2 = ((JComboBox)jComponent2).getSelectedItem();
                        if (object2 instanceof Value) {
                            object = ((Value)object2).get();
                            ((JComboBox)jComponent2).setEnabled(false);
                        }
                    }
                }
                if (object == null) continue;
                hashMap.put(variable, object);
            }
            return hashMap;
        }
    }

    class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            this.add(this.makeButton("Bind"));
            this.add(this.makeButton("Finished"));
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(BindingViewer.this));
            return jButton;
        }
    }
}

