/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Report;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.Refinement;
import ix.icore.process.event.ProcessStatusEvent;
import ix.icore.process.event.ProcessStatusListener;
import ix.ip2.ActivityAgenda;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaManager;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2ModelManager;
import ix.ip2.IssueItem;
import ix.ip2.ItemHandler;
import ix.ip2.PanelController;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaListener;
import ix.ip2.log.ActivityHandledEvent;
import ix.ip2.log.IssueHandledEvent;
import ix.ip2.log.ItemHandledEvent;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.context.LLQueue;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Agenda
implements AgendaManager,
ProcessStatusListener {
    protected PanelController controller;
    protected LLQueue items = new LLQueue();
    protected List handlers = new LinkedList();
    protected List listeners = new LinkedList();

    public Agenda(PanelController panelController) {
        this.controller = panelController;
    }

    public void reset() {
        this.items.clearCompletely();
    }

    public void clear() {
        this.items.clear();
    }

    public List getItems() {
        return this.items.contents();
    }

    public AgendaItem getItem(Name name) {
        for (AgendaItem agendaItem : this.items) {
            Name name2 = agendaItem.getAbout().getId();
            if (name2 == null || !name2.equals(name)) continue;
            return agendaItem;
        }
        return null;
    }

    public void addItem(AgendaItem agendaItem) {
        this.checkForDuplicateId(agendaItem);
        this.addHandlerActions(agendaItem);
        this.items.add(agendaItem);
        this.fireItemAdded(agendaItem);
    }

    public void addItemsBefore(AgendaItem agendaItem, List list) {
        this.controller.getModelManager().markUndoPoint("Add items before");
        LList lList = this.items.contents();
        LList lList2 = (LList)Collect.insertBeforeFirst(agendaItem, lList, list);
        this.items.setContents(lList2);
        for (AgendaItem agendaItem2 : list) {
            this.checkForDuplicateId(agendaItem2);
            this.addHandlerActions(agendaItem2);
            this.fireItemAdded(agendaItem2);
        }
    }

    private void checkForDuplicateId(AgendaItem agendaItem) {
        TaskItem taskItem = agendaItem.getAbout();
        Name name = taskItem.getId();
        if (name != null && this.getItem(name) != null) {
            String string = Strings.afterLast(".", taskItem.getClass().getName());
            Debug.warn("Adding " + string + " with pattern " + taskItem.getPattern() + " even though there is already another " + string + " with id " + name);
        }
    }

    public void removeItem(AgendaItem agendaItem) {
        this.controller.getModelManager().markUndoPoint("Remove item");
        this.items.remove(agendaItem);
        this.fireItemRemoved(agendaItem);
    }

    public AgendaItem makeItem(String string) {
        return this.makeItem(PatternParser.parse(string));
    }

    public abstract AgendaItem makeItem(LList var1);

    public abstract AgendaItem makeItem(TaskItem var1);

    public boolean canHandleAutomatically(TaskItem taskItem) {
        AgendaItem agendaItem = this.makeItem(taskItem);
        for (ItemHandler itemHandler : this.handlers) {
            if (!itemHandler.isAutomatic() || !itemHandler.appliesTo(agendaItem) || !agendaItem.wantsActionsFrom(itemHandler)) continue;
            return true;
        }
        return false;
    }

    public void handleAutomatically(TaskItem taskItem) {
        AgendaItem agendaItem = this.makeItem(taskItem);
        Ip2ModelManager ip2ModelManager = this.controller.getModelManager();
        agendaItem.setPattern(ip2ModelManager.putVariablesInPattern(agendaItem.getPattern()));
        for (ItemHandler itemHandler : this.handlers) {
            if (!itemHandler.isAutomatic() || !itemHandler.appliesTo(agendaItem) || !agendaItem.wantsActionsFrom(itemHandler)) continue;
            itemHandler.addHandlerActions(agendaItem);
            for (HandlerAction handlerAction : agendaItem.getActions()) {
                if (!handlerAction.isReady()) continue;
                this.handleItemDirectly(agendaItem, handlerAction);
                return;
            }
            agendaItem.clearActions();
        }
        throw new IllegalStateException("Failed to automatically handle " + taskItem);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        for (ItemHandler itemHandler : this.handlers) {
            if (!itemHandler.appliesTo(agendaItem) || !agendaItem.wantsActionsFrom(itemHandler)) continue;
            itemHandler.addHandlerActions(agendaItem);
        }
    }

    public void handleItem(final AgendaItem agendaItem, final HandlerAction handlerAction) {
        Debug.expect(this.items.contains(agendaItem), "Stray item", agendaItem);
        this.controller.getModelManager().undoableTransaction("Handle item: " + handlerAction.getActionDescription(), new Runnable(){

            public void run() {
                Agenda.this.handleItemDirectly(agendaItem, handlerAction);
            }
        });
    }

    protected void handleItemDirectly(AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.expect(agendaItem.hasAction(handlerAction), "Stray action", handlerAction);
        agendaItem.setHandledBy(handlerAction);
        try {
            handlerAction.handle(agendaItem);
        }
        catch (RuntimeException runtimeException) {
            agendaItem.setHandledBy(null);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            agendaItem.setHandledBy(null);
            Debug.noteException(throwable);
            throw new RethrownException(throwable);
        }
        this.logItemHandled(agendaItem, handlerAction);
    }

    void logItemHandled(AgendaItem agendaItem, HandlerAction handlerAction) {
        if (!this.controller.getAgent().getOptionManager().canTakeInput()) {
            return;
        }
        ItemHandledEvent itemHandledEvent = agendaItem instanceof IssueItem ? new IssueHandledEvent() : new ActivityHandledEvent();
        itemHandledEvent.setPattern((LList)Variable.removeVars(agendaItem.getPattern()));
        itemHandledEvent.setAction(handlerAction.getActionDescription());
        this.controller.getAgent().log(itemHandledEvent);
    }

    public void addItemHandler(ItemHandler itemHandler) {
        this.handlers.add(itemHandler);
        for (AgendaItem agendaItem : this.items) {
            if (!itemHandler.appliesTo(agendaItem) || !agendaItem.wantsActionsFrom(itemHandler)) continue;
            itemHandler.addHandlerActions(agendaItem);
        }
    }

    public List getItemHandlers() {
        return this.handlers;
    }

    public List getSyntaxList() {
        LListCollector lListCollector = new LListCollector();
        for (ItemHandler itemHandler : this.handlers) {
            if (itemHandler.isAutomatic()) continue;
            lListCollector.addAll(Collect.ensureList(itemHandler.getSyntaxList()));
        }
        return lListCollector.contents();
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        throw new Error("Attempt to expand " + agendaItem);
    }

    public boolean acceptReport(Report report) {
        for (AgendaItem agendaItem : this.items) {
            if (!agendaItem.wantsReport(report)) continue;
            agendaItem.addReport(report);
            return true;
        }
        return false;
    }

    public boolean wantsReport(Report report) {
        for (AgendaItem agendaItem : this.items) {
            if (agendaItem instanceof ActivityAgenda.OtherReportsActivity || !agendaItem.wantsReport(report)) continue;
            return true;
        }
        return false;
    }

    public void statusUpdate(ProcessStatusEvent processStatusEvent) {
    }

    public void newBindings(ProcessStatusEvent processStatusEvent, Map map) {
        this.fireNewBindings(map);
        this.checkActionValidity();
        this.computeActionStatus();
    }

    public void stateChange(ProcessStatusEvent processStatusEvent, Map map) {
        this.computeActionStatus();
    }

    public void stateDeletion(ProcessStatusEvent processStatusEvent, Map map) {
        this.computeActionStatus();
    }

    public void reconsiderHandler(ItemHandler itemHandler, Object object) {
        for (AgendaItem agendaItem : this.items) {
            if (agendaItem.getHandledBy() != null || !itemHandler.appliesTo(agendaItem)) continue;
            itemHandler.reviseHandlerActions(agendaItem, object);
        }
    }

    public void checkActionValidity(ItemHandler itemHandler, Object object) {
        this.checkActionValidity();
    }

    protected void checkActionValidity() {
        for (AgendaItem agendaItem : this.items) {
            if (agendaItem.getHandledBy() != null) continue;
            this.checkActionValidity(agendaItem);
        }
    }

    protected void checkActionValidity(AgendaItem agendaItem) {
        boolean bl = false;
        Iterator iterator = agendaItem.getActions().iterator();
        while (iterator.hasNext()) {
            HandlerAction handlerAction = (HandlerAction)iterator.next();
            if (handlerAction.isStillValid()) continue;
            Debug.noteln("Removing " + handlerAction + " from " + agendaItem);
            iterator.remove();
            bl = true;
        }
        if (bl) {
            agendaItem.fireHandlerActionsChanged();
        }
    }

    protected void computeActionStatus() {
        for (AgendaItem agendaItem : this.items) {
            this.computeActionStatus(agendaItem);
        }
    }

    protected void computeActionStatus(AgendaItem agendaItem) {
        Status status = agendaItem.getStatus();
        if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
            return;
        }
        boolean bl = false;
        for (HandlerAction handlerAction : agendaItem.getActions()) {
            boolean bl2 = handlerAction.isReady();
            handlerAction.computeStatus();
            if (handlerAction.isReady() == bl2) continue;
            bl = true;
        }
        if (bl) {
            agendaItem.fireHandlerActionsChanged();
        }
    }

    public void addAgendaListener(AgendaListener agendaListener) {
        this.listeners.add(agendaListener);
    }

    public void fireItemAdded(AgendaItem agendaItem) {
        Debug.noteln("fireItemAdded", agendaItem);
        AgendaEvent agendaEvent = new AgendaEvent(this);
        for (AgendaListener agendaListener : this.listeners) {
            agendaListener.itemAdded(agendaEvent, agendaItem);
        }
    }

    public void fireItemRemoved(AgendaItem agendaItem) {
        Debug.noteln("fireItemRemoved", agendaItem);
        AgendaEvent agendaEvent = new AgendaEvent(this);
        for (AgendaListener agendaListener : this.listeners) {
            agendaListener.itemRemoved(agendaEvent, agendaItem);
        }
    }

    public void fireItemHandled(AgendaItem agendaItem, HandlerAction handlerAction) {
        Debug.noteln("fireItemHandled " + agendaItem + " " + handlerAction.getActionDescription());
        AgendaEvent agendaEvent = new AgendaEvent(this);
        for (AgendaListener agendaListener : this.listeners) {
            agendaListener.itemHandled(agendaEvent, agendaItem, handlerAction);
        }
    }

    public void fireNewBindings(Map map) {
        AgendaEvent agendaEvent = new AgendaEvent(this);
        for (AgendaListener agendaListener : this.listeners) {
            agendaListener.newBindings(agendaEvent, map);
        }
    }
}

