/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2ModelManager;
import ix.util.AbstractUndoAction;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;

public class ActivityItem
extends AgendaItem {
    public static Symbol EXPANSION_REFINEMENT_NAME = Symbol.intern("expansion-refinement-name");

    public ActivityItem(Activity activity) {
        super(activity);
    }

    public ActivityItem(ActivityItem activityItem, Activity activity) {
        super(activityItem, activity);
    }

    protected PNode makePNode(PNode pNode, LList lList) {
        return new ActivityItem((ActivityItem)pNode, new Activity(lList));
    }

    public void setRefinement(Refinement refinement) {
        super.setRefinement(refinement);
        if (refinement.getName() != null) {
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)this.getModelManager();
            if (ip2ModelManager != null) {
                ip2ModelManager.saveUndoAction(new UndoSetRefinement());
            }
            this.getAbout().setAnnotation(EXPANSION_REFINEMENT_NAME, refinement.getName());
        }
    }

    public String getExpansionRefinementName() {
        return (String)this.getAbout().getAnnotation(EXPANSION_REFINEMENT_NAME);
    }

    class UndoSetRefinement
    extends AbstractUndoAction {
        UndoSetRefinement() {
            super("set expansion refinement name");
        }

        public void undo() {
            if (ActivityItem.this.getExpansionRefinementName() != null) {
                ActivityItem.this.getAbout().removeAnnotation(EXPANSION_REFINEMENT_NAME);
            }
        }
    }
}

