/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.IXMetalTheme;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.table.TableColumn;

public class IFUtil {
    private IFUtil() {
    }

    public static void adjustLookAndFeel() {
        Debug.noteln("Setting Metal look and feel theme.");
        Class clazz = Util.classForNameElseNull("javax.swing.plaf.metal.OceanTheme");
        Debug.noteln("Ocean = " + clazz);
        MetalTheme metalTheme = clazz != null ? (MetalTheme)Util.makeInstance(Util.classForNameElseNull("ix.iface.util.IXOceanTheme")) : new IXMetalTheme();
        Debug.noteln("Using metal theme", metalTheme);
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        Debug.noteln("Initial look and feel", UIManager.getLookAndFeel());
        String string = UIManager.getCrossPlatformLookAndFeelClassName();
        Debug.noteln("Using look and feel class", string);
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            throw new RethrownException(exception);
        }
    }

    TableColumn findColumn(JTable jTable, String string) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (!tableColumn.getHeaderValue().equals(string)) continue;
            return tableColumn;
        }
        throw new ConsistencyException("Can't find column", string);
    }

    public static JButton makeButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(CatchingActionListener.listener(actionListener));
        return jButton;
    }

    public static JButton makeButton(String string, boolean bl, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(CatchingActionListener.listener(actionListener));
        jButton.setEnabled(bl);
        return jButton;
    }

    public static JMenuItem makeMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(actionListener));
        return jMenuItem;
    }

    public static JMenuItem makeMenuItem(String string, boolean bl, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(actionListener));
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    public static void addMenuBarItem(JFrame jFrame, String string, JMenuItem jMenuItem) {
        JMenu jMenu = IFUtil.ensureMenuBarMenu(jFrame, string);
        jMenu.add(jMenuItem);
    }

    public static JMenu ensureMenuBarMenu(JFrame jFrame, String string) {
        JMenu jMenu;
        int n;
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        Component[] componentArray = jMenuBar.getComponents();
        for (n = 0; n < componentArray.length && componentArray[n] instanceof JMenu; ++n) {
            jMenu = (JMenu)componentArray[n];
            if (!jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        jMenu = new JMenu(string);
        jMenuBar.add((Component)jMenu, n);
        return jMenu;
    }

    public static JMenu getMenuBarMenu(JMenuBar jMenuBar, String string, boolean bl) {
        Component[] componentArray = jMenuBar.getComponents();
        for (int i = 0; i < componentArray.length && componentArray[i] instanceof JMenu; ++i) {
            JMenu jMenu = (JMenu)componentArray[i];
            if (!jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        if (bl) {
            throw new IllegalStateException("Could not find a menu bar menu named " + Strings.quote(string));
        }
        return null;
    }
}

