/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.util.ConsistencyException;
import ix.util.Debug;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class CheckTable {
    protected ViewJTable table;
    protected ViewTableModel model;

    public CheckTable(String string, Object[] objectArray, Object[] objectArray2) {
        this.model = new ViewTableModel(string, objectArray, objectArray2);
        this.table = new ViewJTable(this.model);
    }

    public JTable getJTable() {
        return this.table;
    }

    public Object[] getSelectedValues() {
        return this.model.getSelectedValues().toArray();
    }

    public void clearSelections() {
        this.model.clearSelections();
    }

    protected class ViewTableModel
    extends AbstractTableModel {
        final int KEY_COL = 0;
        final int VAL_COL = 1;
        final String[] columnName;
        final Boolean[] isSelected;
        final Object[] items;

        public ViewTableModel(String string, Object[] objectArray, Object[] objectArray2) {
            this.columnName = new String[]{"", string};
            this.items = objectArray;
            this.isSelected = new Boolean[objectArray.length];
            Arrays.fill((Object[])this.isSelected, Boolean.FALSE);
            if (objectArray2 != null) {
                List<Object> list = Arrays.asList(objectArray2);
                for (int i = 0; i < this.isSelected.length; ++i) {
                    this.isSelected[i] = list.contains(objectArray[i]);
                }
            }
        }

        public String getColumnName(int n) {
            return this.columnName[n];
        }

        public int getColumnCount() {
            return this.columnName.length;
        }

        public int getRowCount() {
            return this.items.length;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.isSelected[n];
                }
                case 1: {
                    return this.items[n];
                }
            }
            throw new ConsistencyException("Bogus column " + n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            Debug.expect(n2 == 0, "attempt to edit", new Integer(n2));
            this.isSelected[n] = (Boolean)object;
        }

        public List getSelectedValues() {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.items.length);
            for (int i = 0; i < this.isSelected.length; ++i) {
                if (!this.isSelected[i].booleanValue()) continue;
                arrayList.add(this.items[i]);
            }
            return arrayList;
        }

        public void clearSelections() {
            Arrays.fill((Object[])this.isSelected, Boolean.FALSE);
        }
    }

    protected class ViewJTable
    extends JTable {
        public ViewJTable(TableModel tableModel) {
            super(tableModel);
            this.getTableHeader().setReorderingAllowed(false);
            this.setCellSelectionEnabled(false);
            this.setPreferredColumnWidths();
            this.setPreferredScrollableViewportSize(this.getReasonableSize());
        }

        protected void setPreferredColumnWidths() {
            this.getColumnModel().getColumn(CheckTable.this.model.KEY_COL).setPreferredWidth(12);
            this.getColumnModel().getColumn(CheckTable.this.model.KEY_COL).setMaxWidth(12);
            this.getColumnModel().getColumn(CheckTable.this.model.VAL_COL).setPreferredWidth(400);
        }

        protected Dimension getReasonableSize() {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getPreferredSize();
            double d = Math.min(dimension.getWidth() - 200.0, dimension2.getWidth());
            double d2 = Math.min(dimension.getHeight() - 200.0, dimension2.getHeight());
            return new Dimension((int)d, (int)d2);
        }
    }
}

