/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.tree;

import ix.iface.ui.tree.EditableTreeModel;
import ix.iface.ui.tree.IXTree;
import ix.iface.ui.tree.IXTreeNode;
import ix.util.Debug;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EditableTree
extends IXTree
implements ClipboardOwner {
    Clipboard clips = new Clipboard("Tree Clipboard");
    TreePath path = null;
    boolean isModified = false;
    HashMap nodeMap;

    public EditableTree() {
    }

    public EditableTree(EditableTreeModel editableTreeModel) {
        super(editableTreeModel);
    }

    public void setSelectedObject(Object object) {
        this.clearSelection();
        IXTreeNode iXTreeNode = ((EditableTreeModel)this.getModel()).findTreeNode(object);
        if (iXTreeNode != null) {
            this.setSelectionPath(new TreePath(iXTreeNode.getPath()));
        }
    }

    public void showUserNode(Object object) {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            Object object2 = treePath.getLastPathComponent();
            if (object2 != null && object2 instanceof IXTreeNode) {
                this.showUserNode(object, ((IXTreeNode)object2).getUserObject());
            } else {
                this.showUserNode(object, null);
            }
        }
    }

    public void showUserNode(Object object, Object object2) {
        try {
            EditableTreeModel editableTreeModel = (EditableTreeModel)this.getModel();
            if (editableTreeModel.isUserRoot(object)) {
                this.showRoot();
                return;
            }
            Collection collection = editableTreeModel.findTreeNodes(object);
            if (collection != null) {
                while (collection.contains(null)) {
                    collection.remove(null);
                }
            }
            if (collection == null || collection.size() == 0) {
                this.showRoot();
                return;
            }
            Collection collection2 = editableTreeModel.findTreeNodes(object2);
            if (collection2 != null) {
                while (collection2.contains(null)) {
                    collection2.remove(null);
                }
            }
            IXTreeNode iXTreeNode = null;
            if (collection.size() != 1 && collection2 != null && collection2.size() > 0) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && iXTreeNode == null) {
                    try {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iterator.next();
                        if (defaultMutableTreeNode == null) continue;
                        Iterator iterator2 = collection2.iterator();
                        while (iterator2.hasNext() && iXTreeNode == null) {
                            if (!defaultMutableTreeNode.isNodeAncestor((TreeNode)iterator2.next())) continue;
                            iXTreeNode = (IXTreeNode)((Object)defaultMutableTreeNode);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (iXTreeNode == null) {
                try {
                    iXTreeNode = (IXTreeNode)collection.iterator().next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (iXTreeNode == null) {
                this.showRoot();
            } else {
                this.showPath(iXTreeNode.getPath());
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    protected void showRoot() {
        try {
            EditableTreeModel editableTreeModel = (EditableTreeModel)this.getModel();
            if (editableTreeModel.getRoot() != null) {
                this.showPath(((IXTreeNode)editableTreeModel.getRoot()).getPath());
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    private void showPath(TreeNode[] treeNodeArray) {
        this.showPath(new TreePath(treeNodeArray));
    }

    private void showPath(TreePath treePath) {
        this.scrollPathToVisible(treePath);
        this.setSelectionPath(treePath);
    }

    public IXTreeNode newTreeNode(Object object) {
        EditableTreeModel editableTreeModel = (EditableTreeModel)this.getModel();
        return editableTreeModel.newIXTreeNode(object);
    }

    public Object makeUserObject(String string) {
        EditableTreeModel editableTreeModel = (EditableTreeModel)this.getModel();
        return editableTreeModel.makeUserObject(string);
    }

    public Object makeUserObject(String string, List list) {
        EditableTreeModel editableTreeModel = (EditableTreeModel)this.getModel();
        return editableTreeModel.makeUserObject(string, list);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        Debug.noteln("Tree lost ownership of clipboard", this);
    }
}

