/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXButPanel;
import ix.iface.ui.JPropertiesEditor;
import ix.iface.ui.JPropertiesManager;
import ix.iface.ui.ThingEditorPanel;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public abstract class JPreferencesDialog
extends JDialog
implements MouseListener,
JPropertiesEditor {
    public JFrame frame;
    public JPanel prefsPanel;
    public HashSet booleanKeys = new HashSet();
    public HashMap keyComponents = new HashMap();
    protected JPropertiesManager manager;
    private HashSet listeners = new HashSet();

    public JPreferencesDialog(JFrame jFrame, JPropertiesManager jPropertiesManager) {
        super(jFrame);
        this.frame = jFrame;
        this.manager = jPropertiesManager;
        this.setTitle(this.frame.getTitle() + " - Preferences");
        this.setModal(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(248, 94);
        this.setVisible(false);
        this.prefsPanel = new JPanel();
        Object[] objectArray = new String[]{"Close", "Apply", "Save", "Default", "Reload"};
        IXButPanel iXButPanel = new IXButPanel(this, 0, objectArray);
        this.getContentPane().add(this.prefsPanel);
        this.getContentPane().add((Component)iXButPanel, "South");
        this.makeComponents();
        this.pack();
        this.setSize(this.getWidth(), this.getHeight() + 1);
        this.validate();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setComponentsFromProperties(this.manager.getProperties());
        }
        super.setVisible(bl);
    }

    public void getPropertiesFromComponents(boolean bl) {
        this.getPropertiesFromComponents(this.manager.getProperties(), bl);
    }

    public void setComponentsFromProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            List list = (List)this.keyComponents.get(string);
            if (list != null && list.size() != 0) {
                if (JPropertiesManager.isBooleanProperty(string, string2)) {
                    Component component = (Component)list.iterator().next();
                    this.setBooleanComponent(string, component, string2);
                    continue;
                }
            }
            this.setComponentFromProperty(string, list, string2);
        }
    }

    public void getPropertiesFromComponents(Properties properties, boolean bl) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.manager.isEditable(string)) continue;
            String string2 = properties.getProperty(string);
            List list = (List)this.keyComponents.get(string);
            if (list != null && list.size() != 0) {
                String string3;
                if (JPropertiesManager.isBooleanProperty(string, string2)) {
                    Component component = (Component)list.iterator().next();
                    string3 = this.getPropertyFromBooleanComponent(string, component);
                } else {
                    string3 = this.getPropertyFromComponent(string, list);
                }
                if (string2.equals(string3)) continue;
                properties.setProperty(string, string3);
                if (!bl) continue;
                this.firePropertyChanged(string, string2, string3);
                continue;
            }
            Debug.noteln("JPD: no properties to get for", string);
        }
    }

    private void applyPreferences() {
        this.getPropertiesFromComponents(this.manager.getProperties(), true);
    }

    private void savePreferences() {
        this.getPropertiesFromComponents(false);
        this.manager.saveProperties();
    }

    void closePreferences() {
        try {
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnabledComponents(String string, boolean bl) {
        this.setEnabledComponents(string, (List)this.keyComponents.get(string), bl);
    }

    protected void setEnabledComponents(String string, List list, boolean bl) {
        if (list == null) {
            Debug.noteln("no components for", string);
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                this.setEnabledComponent((Component)iterator.next(), bl);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
    }

    protected void setEnabledComponent(Component component, boolean bl) {
        component.setEnabled(bl);
    }

    protected Component makeBooleanComponent(String string, String string2) {
        boolean bl = new Boolean(string2);
        return new JCheckBox(string, bl);
    }

    protected void setBooleanComponent(String string, Component component, String string2) {
        boolean bl = new Boolean(string2);
        JCheckBox jCheckBox = (JCheckBox)component;
        jCheckBox.setSelected(bl);
    }

    protected String getPropertyFromBooleanComponent(String string, Component component) {
        JCheckBox jCheckBox = (JCheckBox)component;
        if (jCheckBox != null) {
            return new Boolean(jCheckBox.isSelected()).toString();
        }
        return "";
    }

    public Component makeInputComponent(Container container, String string, String string2, String string3, String string4) {
        return this.makeInputComponent(container, string, string2, string3, string4, 2);
    }

    public Component makeInputComponent(Container container, String string, String string2, String string3, String string4, int n) {
        JTextField jTextField = new JTextField(string3);
        jTextField.setActionCommand(string);
        jTextField.setToolTipText(string4);
        jTextField.setHorizontalAlignment(n);
        ThingEditorPanel thingEditorPanel = new ThingEditorPanel((EventListener)this, string2, jTextField);
        container.add(thingEditorPanel);
        return jTextField;
    }

    protected void makeRadioComponent(String string, String string2, List list, String string3) {
        String string4 = this.manager.getProperty(string);
        Box box = new Box(1);
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>();
        box.add(new JLabel(string2));
        Box box2 = new Box(1);
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next().toString();
            JRadioButton jRadioButton = new JRadioButton(string5);
            jRadioButton.setActionCommand(string5);
            jRadioButton.setToolTipText(string5 + " " + string3);
            buttonGroup.add(jRadioButton);
            jRadioButton.setSelected(string5.equals(string4));
            box2.add(jRadioButton);
            arrayList.add(jRadioButton);
        }
        box.add(box2);
        this.prefsPanel.add(Box.createHorizontalGlue());
        this.prefsPanel.add(box);
        this.keyComponents.put(string, arrayList);
    }

    protected void makeCheckBoxComponent(String string, String string2, List list, String string3) {
        String string4 = this.manager.getProperty(string);
        Box box = new Box(1);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        box.add(new JLabel(string2));
        Box box2 = new Box(1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next().toString();
            JCheckBox jCheckBox = new JCheckBox(string5);
            jCheckBox.setActionCommand(string5);
            jCheckBox.setToolTipText(string5 + " " + string3);
            box2.add(jCheckBox);
            arrayList.add(jCheckBox);
        }
        box.add(box2);
        this.prefsPanel.add(Box.createHorizontalGlue());
        this.prefsPanel.add(box);
        this.keyComponents.put(string, arrayList);
        this.setComponentFromProperty(string, arrayList, string4);
    }

    public abstract void makeComponents();

    public abstract boolean setComponentFromProperty(String var1, List var2, String var3);

    public abstract String getPropertyFromComponent(String var1, List var2);

    public abstract void localCommandClicked(String var1);

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (!AbstractButton.class.isInstance(component)) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        String string = abstractButton.getActionCommand();
        if (string.equals("Close")) {
            this.closePreferences();
        } else if (string.equals("Default")) {
            Properties properties = new Properties();
            this.manager.setDefaultProperties(properties);
            this.setComponentsFromProperties(properties);
        } else if (string.equals("Apply")) {
            this.applyPreferences();
        } else if (string.equals("Save")) {
            this.savePreferences();
        } else if (string.equals("Reload")) {
            Properties properties = new Properties();
            this.manager.loadProperties(properties);
            this.setComponentsFromProperties(properties);
        } else if (string.equals("Cancel")) {
            this.setComponentsFromProperties(this.manager.getProperties());
            this.closePreferences();
        } else {
            this.localCommandClicked(string);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void setPropertyChangeListeners(HashSet hashSet) {
        this.listeners = hashSet;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public void firePropertyChanged(String string, String string2, String string3) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, string2, string3);
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }
}

