/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.HTMLPanel;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.ToolFrame;
import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class HTMLFrame
extends ToolFrame
implements ActionListener {
    private URL home;
    protected final HTMLPanel htmlPanel;

    public HTMLFrame() {
        this.setupFrame();
        this.htmlPanel = new HTMLPanel();
        this.addHTML();
    }

    public HTMLFrame(URL uRL) {
        this.setupFrame();
        this.htmlPanel = new HTMLPanel(uRL);
        this.addHTML();
        this.home = this.htmlPanel.currentURL();
    }

    public HTMLFrame(URL uRL, String string) {
        this(uRL);
        this.setTitle(string);
    }

    public HTMLFrame(String string) {
        this.setupFrame();
        this.htmlPanel = new HTMLPanel(string);
        this.addHTML();
        this.home = this.htmlPanel.currentURL();
    }

    public HTMLFrame(String string, String string2) {
        this(string);
        this.setTitle(string2);
    }

    protected void setupFrame() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(550, 650);
        CatchingActionListener catchingActionListener = new CatchingActionListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setActionCommand("close");
        jMenuItem.addActionListener(catchingActionListener);
        JMenuItem jMenuItem2 = new JMenuItem("Forward to previous page");
        jMenuItem2.setActionCommand("forward");
        jMenuItem2.addActionListener(catchingActionListener);
        JMenuItem jMenuItem3 = new JMenuItem("Back to previous page");
        jMenuItem3.setActionCommand("back");
        jMenuItem3.addActionListener(catchingActionListener);
        JMenuItem jMenuItem4 = new JMenuItem("Home");
        jMenuItem4.setActionCommand("home");
        jMenuItem4.addActionListener(catchingActionListener);
        JMenuItem jMenuItem5 = new JMenuItem("Set current page as home");
        jMenuItem5.setActionCommand("setHome");
        jMenuItem5.addActionListener(catchingActionListener);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
    }

    private void addHTML() {
        this.getContentPane().add("Center", this.htmlPanel);
    }

    public boolean back() {
        return this.htmlPanel.back();
    }

    public boolean forward() {
        return this.htmlPanel.forward();
    }

    public void setCurrentPageAsHome() {
        URL uRL = this.htmlPanel.currentURL();
        if (uRL != null) {
            this.home = uRL;
        } else {
            UIUtil.warning(this, "HTMLFrame: No current page - home unchanged.");
        }
    }

    public boolean displayURL(URL uRL) {
        if (uRL != null) {
            return this.htmlPanel.displayURL(uRL);
        }
        Debug.noteln("HTMLFrame: No URL given");
        return false;
    }

    private boolean displayHome() {
        if (this.home != null) {
            return this.htmlPanel.displayURL(this.home);
        }
        UIUtil.warning(this, "No home page found");
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        if (string == "close") {
            this.setVisible(false);
        } else if (string == "home") {
            this.displayHome();
        } else if (string == "setHome") {
            this.setCurrentPageAsHome();
        } else if (string == "back") {
            this.back();
        } else if (string == "forward") {
            this.forward();
        } else {
            String string2 = ((AbstractButton)object).getText();
            if (string2 == "" || string2 == null) {
                string2 = string;
            }
            UIUtil.notImplemented(this, string2);
        }
    }
}

