/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXButPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import ix.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public abstract class AbstractEditorPanel
extends JPanel
implements IXEditorPanel {
    public boolean isBordered = false;
    public IXButPanel butPanel;
    protected JScrollPane scrollPan = null;
    public JLabel nameLabel;
    public TitledBorder border;
    public JComponent itemComponent;
    protected ImageIcon minIcon;
    protected ImageIcon deminIcon;
    protected ImageIcon xDeminIcon;
    protected ImageIcon xMinIcon;
    protected JButton minBut;
    protected JButton deminBut;
    private Dimension oldDim = null;
    GridBagConstraints oldGBC = null;

    public AbstractEditorPanel(boolean bl) {
        super(new GridBagLayout());
        this.makePanel(bl);
    }

    public AbstractEditorPanel(boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.isBordered = bl2;
        this.makePanel(bl);
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, boolean bl2, JComponent jComponent) {
        this(bl2, bl);
        this.makePanelComponent(eventListener, jComponent);
        this.setLabel(string);
        this.setName(string);
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, JComponent jComponent) {
        this(eventListener, bl, string, false, jComponent);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, boolean bl, JComponent jComponent) {
        this(eventListener, false, string, bl, jComponent);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, JComponent jComponent) {
        this(eventListener, string, false, jComponent);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, boolean bl, String[] stringArray) {
        this(bl);
        this.setLabel(string);
        this.makeButtons(eventListener, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, String[] stringArray) {
        this(eventListener, string, false, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, boolean bl2, JComponent jComponent, String[] stringArray) {
        this(eventListener, bl, string, bl2, jComponent);
        this.makeButtons(eventListener, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, boolean bl, String string, JComponent jComponent, String[] stringArray) {
        this(eventListener, bl, string, false, jComponent, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, boolean bl, JComponent jComponent, String[] stringArray) {
        this(eventListener, string, bl, jComponent);
        this.makeButtons(eventListener, stringArray);
    }

    public AbstractEditorPanel(EventListener eventListener, String string, JComponent jComponent, String[] stringArray) {
        this(eventListener, string, false, jComponent, stringArray);
    }

    private void makePanel(boolean bl) {
        if (this.isBordered) {
            this.border = BorderFactory.createTitledBorder("some label");
            this.setBorder(this.border);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.nameLabel = new JLabel("some label");
            this.add((Component)this.nameLabel, gridBagConstraints);
            if (bl) {
                this.makeSizeIcons();
            }
        }
    }

    private void makeSizeIcons() {
        try {
            this.minIcon = Util.resourceImageIcon("ide-symbol-minimise.gif");
            this.deminIcon = Util.resourceImageIcon("ide-symbol-deminimise.gif");
            this.xDeminIcon = Util.resourceImageIcon("ide-symbol-xdeminimise.gif");
            this.xMinIcon = Util.resourceImageIcon("ide-symbol-xminimise.gif");
            this.minBut = new JButton(this.minIcon);
            this.deminBut = new JButton(this.deminIcon);
            this.minBut.setToolTipText("Minimise component");
            this.deminBut.setToolTipText("De-minimise component");
            this.minBut.setActionCommand("minimise");
            this.deminBut.setActionCommand("deminimise");
            final JPopupMenu jPopupMenu = new JPopupMenu();
            final JPopupMenu jPopupMenu2 = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("de-minimise component");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractEditorPanel.this.deMinimise();
                }
            });
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("minimise component");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractEditorPanel.this.minimise();
                }
            });
            jPopupMenu2.add(jMenuItem);
            jPopupMenu2.addSeparator();
            jMenuItem = new JMenuItem("smaller");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractEditorPanel.this.smaller();
                }
            });
            jPopupMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("larger");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractEditorPanel.this.larger();
                }
            });
            jPopupMenu2.add(jMenuItem);
            this.minBut.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu2.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        AbstractEditorPanel.this.minimise();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu2.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.deminBut.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        AbstractEditorPanel.this.deMinimise();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            Dimension dimension = new Dimension(this.minIcon.getIconWidth() + 5, this.minIcon.getIconHeight() + 3);
            this.minBut.setMinimumSize(dimension);
            this.minBut.setMaximumSize(dimension);
            this.minBut.setPreferredSize(dimension);
            this.deminBut.setMinimumSize(dimension);
            this.deminBut.setMaximumSize(dimension);
            this.deminBut.setPreferredSize(dimension);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.add((Component)this.minBut, gridBagConstraints);
            this.add((Component)this.deminBut, gridBagConstraints);
            this.deminBut.setVisible(false);
        }
        catch (Exception exception) {
            Debug.noteln("AEdPan: cannot make buttons to change size");
        }
    }

    protected void makePanelComponent(EventListener eventListener, JComponent jComponent) {
        GridBagConstraints gridBagConstraints;
        boolean bl = false;
        int n = 1;
        if (JTextField.class.isInstance(jComponent)) {
            bl = true;
            n = 2;
        } else if (JCheckBox.class.isInstance(jComponent)) {
            bl = true;
            n = 0;
        } else if (jComponent instanceof IXButPanel) {
            if (((IXButPanel)jComponent).getOrientation() != 1) {
                bl = true;
            }
            n = 0;
        }
        if (this.isBordered) {
            gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 2.0, 1.0, 18, n, new Insets(0, 2, 0, 2), 1, 0);
        } else if (bl) {
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.add((Component)this.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 18, n, new Insets(0, 2, 0, 2), 1, 0);
        } else {
            gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 2.0, 1.0, 17, n, new Insets(0, 2, 0, 2), 1, 0);
        }
        if (AbstractEditorPanel.isScrollItem(jComponent)) {
            this.scrollPan = new JScrollPane();
            this.scrollPan.getViewport().add(jComponent);
            this.add((Component)this.scrollPan, gridBagConstraints);
        } else {
            this.add((Component)jComponent, gridBagConstraints);
        }
        JComponent jComponent2 = null;
        if (jComponent instanceof JScrollPane) {
            this.scrollPan = (JScrollPane)jComponent;
            try {
                jComponent2 = (JComponent)((JScrollPane)jComponent).getViewport().getComponent(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.itemComponent = jComponent2 == null ? jComponent : jComponent2;
        this.addComponentListener(eventListener);
    }

    private void makeButtons(EventListener eventListener, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.butPanel = new IXButPanel(eventListener, stringArray);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0);
            this.add((Component)this.butPanel, gridBagConstraints);
        }
    }

    public void addComponentListener(EventListener eventListener) {
        UIUtil.addListener(this.itemComponent, eventListener);
    }

    public void setLabel(String string) {
        if (this.isBordered) {
            this.border.setTitle(string);
        } else {
            this.nameLabel.setText(string);
        }
    }

    public JComponent getItemComponent() {
        return this.itemComponent;
    }

    public boolean isListItem() {
        return AbstractEditorPanel.isListItem(this.itemComponent);
    }

    public static boolean isListItem(JComponent jComponent) {
        return jComponent instanceof JList || jComponent instanceof JComboBox || jComponent instanceof JTable;
    }

    public static boolean isScrollItem(JComponent jComponent) {
        return jComponent instanceof JList || jComponent instanceof JTextArea || jComponent instanceof JTable;
    }

    public String getName() {
        return this.nameLabel.getText();
    }

    public void setEnabled(boolean bl) {
        if (this.butPanel != null) {
            this.butPanel.setEnabled(bl);
        }
    }

    public void minimise() {
        this.oldDim = this.getPreferredSize();
        if (this.scrollPan != null) {
            this.scrollPan.setVisible(false);
        } else {
            this.itemComponent.setVisible(false);
        }
        if (this.butPanel != null) {
            this.butPanel.setVisible(false);
        }
        this.minBut.setVisible(false);
        this.deminBut.setVisible(true);
        this.adviseMinimise();
        this.setPreferredSize(new Dimension((int)this.oldDim.getWidth(), this.nameLabel.getHeight()));
        this.revalidate();
        this.adjustMinParent(this.getParent());
    }

    public void deMinimise() {
        if (this.scrollPan != null) {
            this.scrollPan.setVisible(true);
        } else {
            this.itemComponent.setVisible(true);
        }
        if (this.butPanel != null) {
            this.butPanel.setVisible(true);
        }
        this.minBut.setVisible(true);
        this.deminBut.setVisible(false);
        this.adviseMinimise();
        this.setPreferredSize(this.oldDim);
        this.revalidate();
        this.adjustDeMinParent(this.getParent());
    }

    public void smaller() {
        Dimension dimension = this.getPreferredSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight() - dimension.getHeight() / 3.0;
        dimension.setSize(d, d2);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.adjustParent(this.getParent());
    }

    public void larger() {
        Dimension dimension = this.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight() + dimension.getHeight() / 2.0;
        dimension.setSize(d, d2);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.adjustParent(this.getParent());
    }

    private void adjustMinParent(Container container) {
        try {
            LayoutManager layoutManager = container.getLayout();
            if (layoutManager instanceof GridBagLayout) {
                GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this);
                this.oldGBC = (GridBagConstraints)gridBagConstraints.clone();
                gridBagConstraints.fill = 2;
                gridBagConstraints.weighty = 0.0;
                gridBagLayout.setConstraints(this, gridBagConstraints);
            }
            this.adjustParent(container);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adjustDeMinParent(Container container) {
        try {
            LayoutManager layoutManager = container.getLayout();
            if (layoutManager instanceof GridBagLayout) {
                GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
                gridBagLayout.setConstraints(this, this.oldGBC);
            }
            this.adjustParent(container);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adjustParent(Container container) {
        container.doLayout();
        container.validate();
        container.repaint();
    }

    public void adviseMinimise() {
        if (!this.isMinimisable()) {
            return;
        }
        if (this.isMinimised()) {
            if (this.hasData()) {
                this.adviseMinToMax();
            } else {
                this.adviseMinOk();
            }
        } else if (!this.hasData()) {
            this.adviseMaxToMin();
        } else {
            this.adviseMaxOk();
        }
    }

    private void adviseMaxOk() {
        if (this.minBut != null) {
            this.minBut.setIcon(this.minIcon);
            this.paintImmediately(this.minBut.getBounds());
        }
    }

    private void adviseMaxToMin() {
        this.adviseMaxOk();
    }

    private void adviseMinOk() {
        if (this.deminBut != null) {
            this.deminBut.setIcon(this.deminIcon);
            this.deminBut.repaint();
        }
    }

    private void adviseMinToMax() {
        if (this.deminBut != null) {
            this.deminBut.setIcon(this.xDeminIcon);
            this.deminBut.repaint();
        }
    }

    public boolean isMinimised() {
        if (this.scrollPan != null) {
            return !this.scrollPan.isVisible();
        }
        JComponent jComponent = this.getItemComponent();
        if (jComponent != null) {
            return !jComponent.isVisible();
        }
        return true;
    }

    public boolean isMinimisable() {
        return this.minBut != null && (this.minBut.isVisible() || this.deminBut.isVisible());
    }

    public boolean hasData() {
        Object object = this.getData();
        return !UIUtil.isEmptyThing(object);
    }

    public void dataSet(Object object) {
        this.adviseMinimise();
    }

    public abstract Object getData();

    public abstract void setData(Object var1);

    public abstract void removeData();

    public abstract boolean setRenderer(ListCellRenderer var1);
}

