/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.plan;

import ix.icore.Annotations;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.AbstractPlanItem;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanVariable;
import ix.icore.plan.inspect.PlanInspector;
import ix.icore.plan.inspect.TaskItemVisitor;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.iface.util.KeyValueTable;
import ix.ip2.Ip2ModelManager;
import ix.iplan.IPlanOptionManager;
import ix.util.DeepCopier;
import ix.util.PatternParser;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.TopologicalSorter;
import ix.util.Util;
import ix.util.WithCleanup;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class TextPlanWriter {
    protected File outputFile = null;
    protected Writer out = null;
    protected int indent = 0;
    protected int indentStep = 3;

    public TextPlanWriter(File file) {
        this.outputFile = file;
    }

    public TextPlanWriter(Writer writer) {
        this.out = writer;
    }

    public void writePlan(final Plan plan) throws IOException {
        if (this.out != null) {
            this.outPlan(plan);
            return;
        }
        this.out = new BufferedWriter(new FileWriter(this.outputFile));
        Util.run(new WithCleanup(){

            public void body() throws IOException {
                TextPlanWriter.this.outPlan(plan);
                TextPlanWriter.this.out.flush();
            }

            public void cleanup() throws IOException {
                TextPlanWriter.this.out.close();
            }
        });
    }

    void outPlan(Plan plan) {
        this.outputTableView(plan);
        this.outputTimeline(plan);
    }

    void outputTableView(Plan plan) {
        if (plan.getPlanIssues() != null) {
            this.outIssues(plan);
        }
        if (plan.getPlanNodes() != null) {
            this.outActivities(plan);
        }
        if (plan.getPlanNodes() != null) {
            this.outActivitiesInFull(plan);
        }
        if (plan.getWorldState() != null) {
            this.outWorldState(plan);
        }
        if (plan.getAnnotations() != null) {
            this.outAnnotations(plan);
        }
    }

    void outIssues(Plan plan) {
        this.outTitle("Issues");
        PlanInspector planInspector = new PlanInspector(plan).setIsAutoRecursive(false);
        planInspector.walkIssues(new TIVisitor(planInspector));
    }

    void outActivities(Plan plan) {
        this.outTitle("Activities");
        PlanInspector planInspector = new PlanInspector(plan).setIsAutoRecursive(false);
        planInspector.walkActivities(new TIVisitor(planInspector));
    }

    public static Object removePlanVars(Object object) {
        return new DeepCopier(){

            public Object copy(Object object) {
                if (object instanceof PlanVariable) {
                    PlanVariable planVariable = (PlanVariable)object;
                    return Symbol.intern(this.varName(planVariable));
                }
                return super.copy(object);
            }

            String varName(PlanVariable planVariable) {
                String string = Strings.afterFirst("var-", planVariable.getId().toString());
                return planVariable.getName() + "/" + string;
            }
        }.copy(object);
    }

    void outActivitiesInFull(Plan plan) {
        this.outTitle("Activities in Full");
        PlanInspector planInspector = new PlanInspector(plan).setIsAutoRecursive(false);
        planInspector.walkActivities(new TIVisitor(planInspector){

            void outTaskItem(TaskItem taskItem) {
                AbstractPlanItem abstractPlanItem = this.inspector.toPlanItem(taskItem);
                TextPlanWriter.this.outln(TextPlanWriter.this.activityId(abstractPlanItem) + " " + this.patternSentence(taskItem));
                Annotations annotations = taskItem.getAnnotations();
                if (annotations != null) {
                    TextPlanWriter.this.outMap(annotations);
                }
                TextPlanWriter.this.newline();
            }
        });
    }

    String activityId(AbstractPlanItem abstractPlanItem) {
        String string = abstractPlanItem.getId().toString();
        String string2 = Strings.afterFirst("node-", string);
        List<String> list = Strings.breakAt("-", string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)Lisp.readFromString(iterator.next());
            linkedList.add("" + (l + 1L));
        }
        return Strings.joinWith("-", linkedList);
    }

    void outWorldState(Plan plan) {
        TreeMap treeMap = new TreeMap(new KeyValueTable.PatternObjectComparator());
        treeMap.putAll(PatternAssignment.assignmentsToMap(plan.getWorldState()));
        this.outTitle("World State");
        for (Map.Entry entry : treeMap.entrySet()) {
            this.indent(this.indentStep);
            this.out(PatternParser.unparse((LList)entry.getKey()));
            this.out(" = ");
            this.out(entry.getValue());
            this.newline();
        }
    }

    void outAnnotations(Plan plan) {
        this.outTitle("Annotations");
        this.outMap(plan.getAnnotations());
    }

    void outMap(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!Lisp.isFullyPrintable(k) || !Lisp.isFullyPrintable(v)) continue;
            this.indent();
            this.out("   " + Lisp.printToString(k) + " = ");
            if (this.isTextBlock(v)) {
                this.newline();
                this.outTextBlock(3, (String)v);
                continue;
            }
            this.out(Lisp.printToString(v));
            this.newline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outputTimeline(Plan plan) {
        this.outTitle("Timeline");
        try {
            this.indent += this.indentStep;
            this.do_outputTimeline(plan);
        }
        finally {
            this.indent -= this.indentStep;
        }
    }

    void do_outputTimeline(Plan plan) {
        IPlanOptionManager.ModelHolder modelHolder = IPlanOptionManager.ModelHolder.newInstance();
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)modelHolder.getModelManager();
        TopologicalSorter topologicalSorter = new TopologicalSorter(){

            protected Collection getChildren(Object object) {
                return ((PNodeEnd)object).getSuccessors();
            }
        };
        modelHolder.loadPlan(plan);
        List list = ip2ModelManager.getNodeEnds();
        List list2 = topologicalSorter.sort(list);
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            PNodeEnd pNodeEnd = (PNodeEnd)listIterator.next();
            if (listIterator.hasNext()) {
                if (((PNodeEnd)listIterator.next()).getNode() == pNodeEnd.getNode()) {
                    this.outln(this.patternSentence(pNodeEnd.getNode()));
                    continue;
                }
                listIterator.previous();
            }
            this.outln(pNodeEnd.getEnd() + " " + this.patternSentence(pNodeEnd.getNode()));
        }
    }

    String patternSentence(PNode pNode) {
        LList lList = (LList)Variable.removeVars(pNode.getPattern());
        return PatternParser.unparse(lList);
    }

    void out(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
    }

    void out(Object object) {
        this.out(Lisp.printToString(object));
    }

    void indent() {
        this.out(Strings.repeat(this.indent, " "));
    }

    void indent(int n) {
        this.out(Strings.repeat(n, " "));
    }

    void newline() {
        this.out("\n");
    }

    void outln(String string) {
        this.indent();
        this.out(string);
        this.newline();
    }

    void outTitle(String string) {
        this.newline();
        this.out(string);
        this.newline();
        this.out(Strings.repeat(string.length(), "-"));
        this.newline();
        this.newline();
    }

    boolean isTextBlock(Object object) {
        return object instanceof String && ((String)object).indexOf("\n") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outTextBlock(int n, String string) {
        try {
            this.indent += n;
            String[] stringArray = Strings.toArray(Strings.breakIntoLines(string));
            stringArray[0] = "\"" + stringArray[0];
            int n2 = stringArray.length - 1;
            stringArray[n2] = stringArray[n2] + "\"";
            for (int i = 0; i < stringArray.length; ++i) {
                this.indent();
                this.outln(stringArray[i]);
            }
        }
        finally {
            this.indent -= n;
        }
    }

    class TIVisitor
    implements TaskItemVisitor {
        PlanInspector inspector;

        TIVisitor(PlanInspector planInspector) {
            this.inspector = planInspector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(TaskItem taskItem, TaskItem taskItem2, List list) {
            this.outTaskItem(taskItem);
            if (!list.isEmpty()) {
                try {
                    TextPlanWriter.this.indent += TextPlanWriter.this.indentStep;
                    this.inspector.walkTaskItemChildren(taskItem, this);
                }
                finally {
                    TextPlanWriter.this.indent -= TextPlanWriter.this.indentStep;
                }
            }
        }

        String patternSentence(TaskItem taskItem) {
            LList lList = (LList)TextPlanWriter.removePlanVars(taskItem.getPattern());
            return PatternParser.unparse(lList);
        }

        void outTaskItem(TaskItem taskItem) {
            TextPlanWriter.this.outln(this.patternSentence(taskItem));
        }
    }
}

