/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.plan;

import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.Plan;
import ix.icore.plan.inspect.PlanInspector;
import ix.icore.plan.inspect.TaskItemVisitor;
import ix.iface.util.KeyValueTable;
import ix.util.Debug;
import ix.util.PatternParser;
import ix.util.RethrownException;
import ix.util.lisp.LList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HtmlPlanWriter {
    File outputFile;
    Writer out;
    LinkedList tagContext;

    public HtmlPlanWriter(File file) {
        this.outputFile = file;
    }

    public void writePlan(Plan plan) throws IOException {
        this.out = new BufferedWriter(new FileWriter(this.outputFile));
        this.tagContext = new LinkedList();
        this.outTag("html");
        this.outln("");
        this.outTag("body", "bgcolor=\"#ffffff\"");
        this.outln("");
        this.outPlan(plan);
        this.outln("");
        this.closeTag("body");
        this.outln("");
        this.closeTag("html");
        this.outln("");
        this.out.flush();
    }

    void outPlan(Plan plan) {
        if (plan.getPlanIssues() != null) {
            this.outIssues(plan);
        }
        if (plan.getPlanNodes() != null) {
            this.outActivities(plan);
        }
        if (plan.getWorldState() != null) {
            this.outWorldState(plan);
        }
        if (plan.getAnnotations() != null) {
            this.outAnnotations(plan);
        }
    }

    void outIssues(Plan plan) {
        this.tagln("h2", "Issues");
        this.outTag("ul");
        this.outln("");
        PlanInspector planInspector = new PlanInspector(plan).setIsAutoRecursive(false);
        planInspector.walkIssues(new TIVisitor(planInspector));
        this.closeTag("ul");
        this.outln("");
    }

    void outActivities(Plan plan) {
        this.tagln("h2", "Activities");
        this.outTag("ul");
        this.outln("");
        PlanInspector planInspector = new PlanInspector(plan).setIsAutoRecursive(false);
        planInspector.walkActivities(new TIVisitor(planInspector));
        this.closeTag("ul");
        this.outln("");
    }

    void outTaskItem(TaskItem taskItem) {
        LList lList = (LList)Variable.removeVars(taskItem.getPattern());
        String string = PatternParser.unparse(lList);
        this.outTag("li");
        this.out(string);
        this.closeTag("li");
        this.outln("");
    }

    void outWorldState(Plan plan) {
        TreeMap treeMap = new TreeMap(new KeyValueTable.PatternObjectComparator());
        treeMap.putAll(PatternAssignment.assignmentsToMap(plan.getWorldState()));
        this.tagln("h2", "State");
        for (Map.Entry entry : treeMap.entrySet()) {
            this.out(PatternParser.unparse((LList)entry.getKey()));
            this.out(" = ");
            this.out(entry.getValue());
            this.outln("<br />");
        }
    }

    void outAnnotations(Plan plan) {
        this.tagln("h2", "Annotations");
    }

    void outTag(String string) {
        this.out("<" + string + ">");
        this.tagContext.addFirst(string);
    }

    void outTag(String string, String string2) {
        this.out("<" + string + " " + string2 + ">");
        this.tagContext.addFirst(string);
    }

    void closeTag(String string) {
        Debug.expectEquals(this.tagContext.removeFirst(), string, "Closing the wrong tag");
        this.out("</" + string + ">");
    }

    void tagln(String string, String string2) {
        this.outTag(string);
        this.out(string2);
        this.closeTag(string);
        this.outln("");
    }

    void out(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
    }

    void out(Object object) {
        this.out(object.toString());
    }

    void outln(String string) {
        this.out(string);
        this.out("\n");
    }

    class TIVisitor
    implements TaskItemVisitor {
        PlanInspector inspector;

        TIVisitor(PlanInspector planInspector) {
            this.inspector = planInspector;
        }

        public void visit(TaskItem taskItem, TaskItem taskItem2, List list) {
            HtmlPlanWriter.this.outTaskItem(taskItem);
            if (!list.isEmpty()) {
                HtmlPlanWriter.this.outTag("ul");
                this.inspector.walkTaskItemChildren(taskItem, this);
                HtmlPlanWriter.this.closeTag("ul");
                HtmlPlanWriter.this.outln("");
            }
        }
    }
}

