/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfNodeSpec;
import ix.icore.domain.LinkedListOfRefinement;
import ix.icore.domain.ListOfRefinement;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ChecklistParser {
    ListOfRefinement refinements = new LinkedListOfRefinement();
    Gensym.Generator nameGen = new Gensym.Generator();
    URL url;
    BufferedReader in;
    LineParser lp;
    static Line EOF = new Line(-1, Collections.EMPTY_LIST);

    public ChecklistParser(URL uRL) throws IOException {
        this.url = uRL;
        this.in = new BufferedReader(Util.openURLReader(uRL));
        this.lp = new LineParser(this.in);
    }

    public Domain readDomain() throws IOException {
        while (this.parseRefinement()) {
        }
        Domain domain = new Domain();
        domain.setName(this.nameFromURL(this.url));
        if (!this.refinements.isEmpty()) {
            domain.setRefinements(this.refinements);
        }
        return domain;
    }

    private String nameFromURL(URL uRL) {
        return Strings.beforeFirst(".", Strings.afterLast("/", uRL.getPath()));
    }

    boolean parseRefinement() throws IOException {
        Line line;
        while ((line = this.lp.nextLine()).isEmpty() && line != EOF) {
        }
        if (line == EOF) {
            return false;
        }
        LList lList = LList.newLList(line.words);
        Refinement refinement = new Refinement(this.makeRefinementName(lList), lList);
        this.refinements.add(refinement);
        Line line2 = this.lp.nextLine();
        if (line2.indent <= line.indent) {
            this.lp.pushLine(line2);
            return true;
        }
        LinkedListOfNodeSpec linkedListOfNodeSpec = new LinkedListOfNodeSpec();
        int n = line2.indent;
        int n2 = 1;
        while (line2.indent == n) {
            LList lList2 = LList.newLList(line2.words);
            linkedListOfNodeSpec.add(new NodeSpec(n2++, lList2));
            Line line3 = this.lp.nextLine();
            this.lp.pushLine(line3);
            if (line3.indent > n) {
                this.lp.pushLine(line2);
                boolean bl = this.parseRefinement();
                Debug.expect(bl, "failed to make nested refinement for line", line2);
            }
            line2 = this.lp.nextLine();
        }
        if (!linkedListOfNodeSpec.isEmpty()) {
            refinement.setNodes(linkedListOfNodeSpec);
        }
        this.lp.pushLine(line2);
        return true;
    }

    String makeRefinementName(List list) {
        return this.nameGen.nextString(list.get(0).toString());
    }

    static class LineParser {
        private BufferedReader in;
        private LinkedList pushedLines = new LinkedList();

        LineParser(BufferedReader bufferedReader) {
            this.in = bufferedReader;
        }

        Line nextLine() throws IOException {
            if (!this.pushedLines.isEmpty()) {
                return (Line)this.pushedLines.removeFirst();
            }
            String string = this.in.readLine();
            if (string == null) {
                return EOF;
            }
            int n = 0;
            List<String> list = Strings.breakAt(" ", string);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (String string2 : list) {
                if (string2.equals("")) {
                    if (!linkedList.isEmpty()) continue;
                    ++n;
                    continue;
                }
                linkedList.add(this.makeWord(string2));
            }
            return new Line(n, linkedList);
        }

        void pushLine(Line line) {
            this.pushedLines.addFirst(line);
        }

        private Object makeWord(String string) {
            return Symbol.intern(string);
        }
    }

    static class Line {
        int indent;
        List words;

        Line(int n, List list) {
            this.indent = n;
            this.words = list;
            Debug.noteln("Parsed", this);
        }

        boolean isEmpty() {
            return this.words.isEmpty();
        }

        public String toString() {
            return "Line[" + this.indent + " " + this.words + "]";
        }
    }
}

