/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.process;

import ix.icore.ConstraintManager;
import ix.icore.Variable;
import ix.icore.domain.Constrainer;
import ix.icore.domain.Constraint;
import ix.icore.process.PNode;
import ix.icore.process.ProcessModelManager;
import ix.icore.process.event.ProcessStatusEvent;
import ix.icore.process.event.ProcessStatusListener;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.context.ContextAnnotatedObject;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.SimpleMatcher;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPMM
extends ContextAnnotatedObject
implements ProcessModelManager {
    private List processStatusListeners = new LinkedList();

    public void addConstraints(PNode pNode, List list) {
        Debug.noteln("PMM adding constraints for node", pNode);
        for (Constraint constraint : list) {
            Debug.noteln("--- adding ", constraint);
            this.addConstraint(pNode, constraint);
        }
    }

    public void addConstraints(List list) {
        Debug.noteln("PMM adding top-level constraints");
        for (Constrainer constrainer : list) {
            Debug.noteln("--- adding ", constrainer);
            this.addConstraint(constrainer);
        }
    }

    public void registerConstraintManager(Symbol symbol, Symbol symbol2, ConstraintManager constraintManager) {
    }

    public ConstraintManager getConstraintManager(Symbol symbol, Symbol symbol2) {
        return null;
    }

    public ConstraintManager getConstraintManager(Constraint constraint) {
        return null;
    }

    public LList putVariablesInPattern(LList lList) {
        return (LList)SimpleMatcher.emptyEnv.instantiateTree(lList, new MakeVarIfUnbound());
    }

    protected abstract void addSentinel(Sentinel var1);

    protected abstract void removeSentinel(Sentinel var1);

    protected abstract List getSentinels();

    protected void runSentinels() {
        LinkedList<Sentinel> linkedList = null;
        for (Sentinel sentinel : this.getSentinels()) {
            if (!sentinel.isReady()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Sentinel>();
            }
            linkedList.add(sentinel);
            sentinel.run();
        }
        if (linkedList != null) {
            this.getSentinels().removeAll(linkedList);
        }
    }

    public void addProcessStatusListener(ProcessStatusListener processStatusListener) {
        Debug.noteln("Adding process status listener", processStatusListener);
        this.processStatusListeners.add(processStatusListener);
    }

    public void fireStatusUpdate() {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        for (ProcessStatusListener processStatusListener : this.processStatusListeners) {
            processStatusListener.statusUpdate(processStatusEvent);
        }
    }

    public void fireNewBindings(Map map) {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        for (ProcessStatusListener processStatusListener : this.processStatusListeners) {
            processStatusListener.newBindings(processStatusEvent, map);
        }
    }

    public void fireStateChange(Map map) {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        for (ProcessStatusListener processStatusListener : this.processStatusListeners) {
            processStatusListener.stateChange(processStatusEvent, map);
        }
    }

    public void fireStateDeletion(Map map) {
        ProcessStatusEvent processStatusEvent = new ProcessStatusEvent(this);
        for (ProcessStatusListener processStatusListener : this.processStatusListeners) {
            processStatusListener.stateDeletion(processStatusEvent, map);
        }
    }

    protected static interface Sentinel
    extends Runnable {
        public boolean isReady();
    }

    private class MakeVarIfUnbound
    implements Function1 {
        Map varEnv;

        MakeVarIfUnbound() {
            this.varEnv = AbstractPMM.this.getVarEnv();
        }

        public Object funcall(Object object) {
            Variable variable = (Variable)this.varEnv.get(object);
            if (variable == null) {
                variable = new Variable(object);
                this.varEnv.put(object, variable);
            }
            return variable;
        }
    }
}

