/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.icore.Variable;
import ix.icore.domain.LinkedListOfPatternAssignment;
import ix.icore.domain.ListOfPatternAssignment;
import ix.util.Function1;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatternAssignment
implements Serializable {
    public static final Symbol S_TRUE = Symbol.intern("true");
    public static final Symbol S_FALSE = Symbol.intern("false");
    protected LList pattern;
    protected Object value;

    public PatternAssignment() {
    }

    public PatternAssignment(LList lList, Object object) {
        this.pattern = lList;
        this.setValue(object);
    }

    public PatternAssignment(LList lList) {
        this(lList, S_TRUE);
    }

    public PatternAssignment(Map.Entry entry) {
        this((LList)entry.getKey(), entry.getValue());
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object instanceof List && !(object instanceof LList) ? LList.LListify((List)object) : object;
    }

    public PatternAssignment instantiate(MatchEnv matchEnv, Function1 function1) {
        LList lList = (LList)matchEnv.instantiateTree(this.pattern, function1);
        Object object = matchEnv.instantiateTree(this.value, function1);
        return new PatternAssignment(lList, object);
    }

    public Set getVariables() {
        Set set = Variable.varsIn(this.pattern);
        set.addAll(Variable.varsIn(this.value));
        return set;
    }

    public int hashCode() {
        return 31 * this.pattern.hashCode() + this.value.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) return false;
        PatternAssignment patternAssignment = (PatternAssignment)object;
        if (!this.getPattern().equals(patternAssignment.getPattern())) return false;
        if (!this.getValue().equals(patternAssignment.getValue())) return false;
        return true;
    }

    public String toString() {
        String string = Lisp.printToString(this.pattern);
        String string2 = Lisp.printToString(this.value);
        return "p=v[" + string + "=" + string2 + "]";
    }

    public static Map assignmentsToMap(Collection collection) {
        HashMap<LList, Object> hashMap = new HashMap<LList, Object>();
        for (PatternAssignment patternAssignment : collection) {
            hashMap.put(patternAssignment.getPattern(), patternAssignment.getValue());
        }
        return hashMap;
    }

    public static ListOfPatternAssignment mapToAssignments(Map map) {
        LinkedListOfPatternAssignment linkedListOfPatternAssignment = new LinkedListOfPatternAssignment();
        for (Map.Entry entry : map.entrySet()) {
            linkedListOfPatternAssignment.add(new PatternAssignment(entry));
        }
        return linkedListOfPatternAssignment;
    }
}

