/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.AbstractIXObject;
import ix.icore.HasStatus;
import ix.icore.IXAgent;
import ix.icore.Priority;
import ix.icore.Sendable;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.icore.log.HistoryEvent;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.IPC;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class TaskItem
extends AbstractIXObject
implements Serializable,
Cloneable,
Sendable,
HasStatus {
    protected LList pattern;
    protected Status status = Status.BLANK;
    protected Priority priority = null;
    protected Name id;
    protected Name senderId;
    protected Name ref;
    protected YesNo reportBack;
    protected String shortDescription;
    protected Set patternVars;
    protected static final Symbol HISTORY = Symbol.intern("history");
    public static Symbol S_FORWARDED_TO = Symbol.intern("forwarded-to");

    protected TaskItem() {
    }

    protected TaskItem(LList lList) {
        this();
        this.setPattern(lList);
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
        this.shortDescription = PatternParser.unparse(lList);
        this.patternVars = Variable.varsIn(lList);
    }

    public Object getVerb() {
        return this.pattern.car();
    }

    public LList getParameters() {
        return this.pattern.cdr();
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Set getPatternVars() {
        return this.patternVars;
    }

    public Set getUnboundVars() {
        return Variable.unboundVarsIn(this.patternVars);
    }

    public boolean isGround() {
        return this.getUnboundVars().isEmpty();
    }

    public Name getId() {
        return this.id;
    }

    public void setId(Name name) {
        Debug.expect(this.id == null, "Resetting id");
        this.id = name;
    }

    public void ensureId() {
        if (this.id == null) {
            this.id = this.generateId();
        }
    }

    public abstract Name generateId();

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void computeStatus() {
        throw new UnsupportedOperationException();
    }

    public Priority getPriority() {
        return this.priority == null ? Priority.NORMAL : this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public boolean priorityWasSet() {
        return this.priority != null;
    }

    public Name getSenderId() {
        return this.senderId;
    }

    public void setSenderId(Name name) {
        this.senderId = name;
    }

    public Name getRef() {
        return this.ref;
    }

    public void setRef(Name name) {
        this.ref = name;
    }

    public YesNo getReportBack() {
        return this.reportBack;
    }

    public void setReportBack(YesNo yesNo) {
        this.reportBack = yesNo;
    }

    public List getHistory() {
        return (List)this.getAnnotation(HISTORY);
    }

    public void setHistory(List list) {
        if (list == null && this.getHistory() != null) {
            this.removeAnnotation(HISTORY);
        } else {
            this.setAnnotation(HISTORY, list);
        }
    }

    public void addHistoryEvent(HistoryEvent historyEvent) {
        LinkedList<HistoryEvent> linkedList;
        if (historyEvent.getDate() == null) {
            historyEvent.setDate(new Date());
        }
        if ((linkedList = this.getHistory()) == null) {
            linkedList = new LinkedList<HistoryEvent>();
            this.setHistory(linkedList);
        }
        linkedList.add(historyEvent);
    }

    public void forwardTo(Object object, boolean bl) {
        Name name = Name.valueOf(IXAgent.getAgent().getAgentIPCName());
        this.ensureId();
        try {
            TaskItem taskItem = (TaskItem)this.clone();
            if (!Gensym.usingUniquePrefix()) {
                taskItem.id = null;
            }
            taskItem.setPattern((LList)Variable.removeVars(this.getPattern()));
            taskItem.setSenderId(name);
            taskItem.setReportBack(YesNo.valueOf(bl));
            taskItem.setRef(this.id);
            IPC.sendObject(object, taskItem);
            if (Gensym.usingUniquePrefix()) {
                this.setForwardedTo(Name.valueOf(object));
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Can't clone " + this);
        }
    }

    public Name getForwardedTo() {
        return (Name)this.getAnnotation(S_FORWARDED_TO);
    }

    public void setForwardedTo(Name name) {
        this.setAnnotation(S_FORWARDED_TO, name);
    }

    public Object clone() throws CloneNotSupportedException {
        TaskItem taskItem = (TaskItem)super.clone();
        return taskItem;
    }
}

