/*
 * Decompiled with CFR 0.152.
 */
package ix.icore;

import ix.icore.AbstractIXObject;
import ix.icore.Priority;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.Symbol;
import java.io.Serializable;
import java.util.List;

public class Report
extends AbstractIXObject
implements Serializable,
Cloneable,
Sendable {
    protected String text;
    protected ReportType reportType;
    protected Priority priority = Priority.NORMAL;
    protected Name senderId;
    protected Name ref;
    private static final Symbol S_CONSTRAINTS = Symbol.intern("constraints");

    public Report() {
    }

    public Report(String string) {
        this.text = string;
    }

    public Report(ReportType reportType, String string) {
        this.reportType = reportType;
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public ReportType getReportType() {
        ReportType reportType = this.reportType;
        if (reportType != null) {
            return reportType;
        }
        String string = this.getText().trim().toLowerCase();
        Debug.noteln("Setting report-type from report text", Util.quote(string));
        reportType = !string.startsWith("done") ? ReportType.PROGRESS : (string.indexOf("no solutions") > -1 ? ReportType.FAILURE : (string.indexOf("failure") > -1 ? ReportType.FAILURE : ReportType.SUCCESS));
        this.setReportType(reportType);
        return reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Name getSenderId() {
        return this.senderId;
    }

    public void setSenderId(Name name) {
        this.senderId = name;
    }

    public Name getRef() {
        return this.ref;
    }

    public void setRef(Name name) {
        this.ref = name;
    }

    public boolean isCompletion() {
        return this.getReportType() == ReportType.SUCCESS || this.getReportType() == ReportType.FAILURE;
    }

    public boolean isSuccess() {
        return this.getReportType() == ReportType.SUCCESS;
    }

    public boolean isFailure() {
        return this.getReportType() == ReportType.FAILURE;
    }

    public boolean isProgress() {
        return this.getReportType() == ReportType.PROGRESS;
    }

    public List getConstraints() {
        return (List)this.getAnnotation(S_CONSTRAINTS);
    }

    public void setConstraints(List list) {
        this.setAnnotation(S_CONSTRAINTS, list);
    }

    public void addConstraint(Constraint constraint) {
        if (this.getConstraints() == null) {
            this.setConstraints(new LinkedListOfConstraint());
        }
        this.getConstraints().add(constraint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "report[" + this.text + "]";
    }
}

