/*
 * Decompiled with CFR 0.152.
 */
package ix.http;

import ix.http.HttpCommunicationStrategy;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.ipc.ServiceAddress;
import ix.util.lisp.Lisp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpNameServer {
    public static String DEFAULT_ADDRESS = "localhost:5555";
    HttpCommunicationStrategy strategy;
    Map nameToAddrMap = new Hashtable();

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        new HttpNameServer().start();
    }

    void start() {
        ServiceAddress serviceAddress = new ServiceAddress(Parameters.getParameter("name-server", DEFAULT_ADDRESS));
        this.strategy = new NSCommStrategy(serviceAddress.getPort());
        this.strategy.setupServer("name-server", null);
    }

    Object handleRequest(Object object) {
        Debug.noteln("NS request:", object);
        if (this.isLookupMessage(object)) {
            List list = (List)object;
            String string = (String)list.get(1);
            ServiceAddress serviceAddress = (ServiceAddress)this.nameToAddrMap.get(string);
            if (serviceAddress == null) {
                return "unknown";
            }
            return serviceAddress;
        }
        if (this.isRegisterMessage(object)) {
            List list = (List)object;
            String string = (String)list.get(1);
            ServiceAddress serviceAddress = (ServiceAddress)list.get(2);
            this.nameToAddrMap.put(string, serviceAddress);
            return "OK";
        }
        throw new IllegalArgumentException("Invalid name-server request: " + object);
    }

    public static Object makeRegisterMessage(String string, ServiceAddress serviceAddress) {
        return Lisp.list("register", string, serviceAddress);
    }

    public static Object makeLookupMessage(String string) {
        return Lisp.list("lookup", string);
    }

    public boolean isRegisterMessage(Object object) {
        return this.hasForm(object, Lisp.list("register", String.class, ServiceAddress.class));
    }

    public boolean isLookupMessage(Object object) {
        return this.hasForm(object, Lisp.list("lookup", String.class));
    }

    private boolean hasForm(Object object, List list) {
        if (!(object instanceof List)) {
            return false;
        }
        Iterator iterator = ((List)object).iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e = iterator2.next();
            if (e instanceof String) {
                if (e.equals(iterator.next())) continue;
                return false;
            }
            if (e instanceof Class) {
                if (((Class)e).isInstance(iterator.next())) continue;
                return false;
            }
            throw new ConsistencyException("Bad hasForm syntax: " + list);
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    class NSCommStrategy
    extends HttpCommunicationStrategy {
        NSCommStrategy(int n) {
            super(n);
        }

        public Object handleInput(Object object) {
            return HttpNameServer.this.handleRequest(object);
        }

        void registerWithNameServer() {
        }
    }
}

