/*
 * Decompiled with CFR 0.152.
 */
package ix.http;

import ix.http.HttpNameServer;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.ipc.ServiceAddress;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;

public class HttpCommunicationStrategy
implements IPC.CommunicationStrategy {
    Map nameToAddrMap = new Hashtable();
    URL nameServerURL = null;
    String thisAgentsName = null;
    IPC.MessageListener messageListener;
    int listenPort = -1;

    public HttpCommunicationStrategy() {
    }

    public HttpCommunicationStrategy(int n) {
        this.listenPort = n;
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        this.thisAgentsName = (String)object;
        this.messageListener = messageListener;
        ServiceAddress serviceAddress = new ServiceAddress(Parameters.getParameter("name-server", HttpNameServer.DEFAULT_ADDRESS));
        this.nameServerURL = this.makeMessageURL(serviceAddress);
        HttpServer httpServer = new HttpServer();
        SocketListener socketListener = new SocketListener();
        int n = this.listenPort;
        if (n < 0) {
            n = Parameters.getInt("port", n);
        }
        if (n > 0) {
            socketListener.setPort(n);
        }
        try {
            socketListener.open();
            this.listenPort = socketListener.getPort();
            Debug.noteln("Server port:", this.listenPort);
        }
        catch (IOException iOException) {
            throw new RethrownException("Cannot get a port for the HTTP server. ", iOException);
        }
        httpServer.addListener((HttpListener)socketListener);
        HttpContext httpContext = new HttpContext();
        httpContext.setContextPath("/");
        httpContext.setResourceBase("/tmp");
        httpContext.setAttribute("communication-strategy", (Object)this);
        httpServer.addContext(httpContext);
        ServletHandler servletHandler = new ServletHandler();
        httpContext.addHandler((HttpHandler)servletHandler);
        servletHandler.addServlet("CommServlet", "/message", "ix.http.HttpCommunicationStrategy$CommServlet");
        httpContext.addHandler((HttpHandler)new ResourceHandler());
        try {
            httpServer.start();
        }
        catch (Throwable throwable) {
            throw new RethrownException("Couldn't start the HTTP server. ", throwable);
        }
        this.registerWithNameServer();
    }

    void registerWithNameServer() {
        ServiceAddress serviceAddress = new ServiceAddress(this.getHostName(), this.listenPort);
        Object object = HttpNameServer.makeRegisterMessage(this.thisAgentsName, serviceAddress);
        Object object2 = this.requestObject(this.nameServerURL, object);
    }

    String getHostName() {
        try {
            return Util.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RethrownException(unknownHostException);
        }
    }

    public void sendObject(Object object, Object object2) {
        Object object3 = this.requestObject((String)object, object2);
        Debug.expectEquals("OK", object3, "Invalid response from " + object + ". ");
    }

    public Object requestObject(String string, Object object) {
        return this.requestObject(this.getAddress(string), object);
    }

    public Object requestObject(URL uRL, Object object) {
        try {
            return this.do_requestObject(uRL, object);
        }
        catch (IOException iOException) {
            throw new RethrownException("Trouble requesting from " + uRL + ". ", iOException);
        }
    }

    protected Object do_requestObject(URL uRL, Object object) throws IOException {
        Debug.noteln("Sending to", uRL);
        Debug.noteln("Contents:", object);
        byte[] byArray = this.encodeForSend(object);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
        httpURLConnection.setRequestProperty("Content-Type", "application/xml; charset=UTF-8");
        httpURLConnection.setRequestProperty("Host", uRL.getHost() + ":" + uRL.getPort());
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
        Debug.noteln("");
        Debug.noteln("Response:");
        Debug.noteln(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        Debug.noteln("");
        Debug.noteln("Reply Headers:");
        for (Map.Entry<String, List<String>> object22 : httpURLConnection.getHeaderFields().entrySet()) {
            Debug.noteln(object22.getKey() + ": " + object22.getValue());
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        String string = httpURLConnection.getContentEncoding();
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        int n = httpURLConnection.getContentLength();
        String string2 = "";
        if (n < 0) {
            Debug.noteln("No contet length; will read everything.");
            string2 = HttpCommunicationStrategy.readAllLines(inputStreamReader);
            ((Reader)inputStreamReader).close();
        } else {
            string2 = HttpCommunicationStrategy.readText(inputStreamReader, n);
            ((Reader)inputStreamReader).close();
            if (string2 == null) {
                throw new RuntimeException("EOF");
            }
        }
        Debug.noteln("");
        Debug.noteln("Reply:");
        Debug.noteln(string2);
        return this.decodeReceived(string2);
    }

    public byte[] encodeForSend(Object object) {
        Document document = XML.objectToDocument(object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
            xMLOutputter.output(document, (Writer)outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Object decodeReceived(String string) {
        return XML.objectFromXML(string);
    }

    URL getAddress(Object object) {
        URL uRL = (URL)this.nameToAddrMap.get(object);
        if (uRL == null) {
            uRL = this.askNameServer(object);
            this.nameToAddrMap.put(object, uRL);
        }
        return uRL;
    }

    URL askNameServer(Object object) {
        String string = object.toString();
        Object object2 = HttpNameServer.makeLookupMessage(string);
        ServiceAddress serviceAddress = Util.mustBe(ServiceAddress.class, this.requestObject(this.nameServerURL, object2));
        return this.makeMessageURL(serviceAddress);
    }

    public Object handleInput(Object object) {
        this.messageListener.messageReceived(new IPC.BasicInputMessage(object));
        return "OK";
    }

    URL makeMessageURL(ServiceAddress serviceAddress) {
        try {
            return new URL("http", serviceAddress.getHost(), serviceAddress.getPort(), "/message");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RethrownException("Can't make a URL from " + serviceAddress + ". ", malformedURLException);
        }
    }

    static String readText(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = reader.read(cArray, n3, n2);
            if (n4 == -1) {
                return null;
            }
            n2 -= n4;
            n3 += n4;
        }
        return new String(cArray);
    }

    static String readAllLines(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }

    public static class CommServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            Debug.noteln("HTTP request URI:", httpServletRequest.getRequestURI());
            ServletContext servletContext = this.getServletConfig().getServletContext();
            HttpCommunicationStrategy httpCommunicationStrategy = (HttpCommunicationStrategy)servletContext.getAttribute("communication-strategy");
            int n = httpServletRequest.getContentLength();
            if (n == -1) {
                httpServletResponse.sendError(411);
                return;
            }
            BufferedReader bufferedReader = httpServletRequest.getReader();
            String string = HttpCommunicationStrategy.readText(bufferedReader, n);
            bufferedReader.close();
            if (string == null) {
                httpServletResponse.sendError(400, "Not enough data.");
                return;
            }
            Debug.noteln("Recieved:", string);
            Object object = httpCommunicationStrategy.decodeReceived(string);
            int n2 = 200;
            Object object2 = null;
            try {
                object2 = httpCommunicationStrategy.handleInput(object);
            }
            catch (Throwable throwable) {
                Debug.displayException("Problem handling " + object, throwable);
                object2 = Debug.describeException(throwable);
                n2 = 500;
            }
            byte[] byArray = httpCommunicationStrategy.encodeForSend(object2);
            httpServletResponse.setStatus(n2);
            httpServletResponse.setContentType("application/xml; charset=UTF-8");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }
}

