/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import iglobe.util.ReportRequestParticipantTask;
import ix.iglobe.test.shared.IGlobeCallback;
import ix.iglobe.test.shared.IGlobeIXAgent;
import ix.util.ColorGenerator;
import ix.util.Debug;
import ix.util.Strings;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RescuePlanner
extends CMAgent
implements MessageConstants {
    public static final String TYPE = "IX-rescue planner";
    static ColorGenerator colorGen = new ColorGenerator();
    protected IGlobeIXAgent ixAgent = null;
    protected DirectoryService.Shell dirShell;
    protected Map<String, ReportRequestParticipantTask> plansCallback = new HashMap<String, ReportRequestParticipantTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AgentInfo ai, int initState) {
        int rgb;
        super.init(ai, initState);
        this.logger.fine("Test Rescue Planner started");
        URL domain = this.getClass().getClassLoader().getResource("domain-library/phase1.lsp");
        ColorGenerator colorGenerator = colorGen;
        synchronized (colorGenerator) {
            rgb = colorGen.nextRGB();
        }
        String[] argv = new String[]{"-domain=" + domain, "-step-limit=500", "-background-color=0x" + Integer.toHexString(rgb)};
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        try {
            this.dirShell.register((ElementaryEntity)this, new LinkedList<String>((Collection)Arrays.asList(TYPE)));
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
        this.setIdleTask(new RescuePlannerIdleTask(this));
        try {
            this.ixAgent = this.startSeparateAgent("ix.iglobe.test.IGlobeIp2", argv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    IGlobeIXAgent startSeparateAgent(String className, String[] argv) throws Exception {
        URL ixJar = this.jarURL("ix.jar");
        URL iglobeJar = this.jarURL("iglobe.jar");
        URL[] urls = new URL[]{iglobeJar, ixJar};
        ClassLoader parent = this.getClass().getClassLoader();
        IXAgentClassLoader loader = new IXAgentClassLoader(urls, parent);
        Class<?> c = ((ClassLoader)loader).loadClass(className);
        Constructor<?> cons = c.getConstructor(new Class[0]);
        IGlobeIXAgent agent = (IGlobeIXAgent)cons.newInstance(new Object[0]);
        Class[] sig = new Class[]{argv.getClass()};
        Method m = c.getMethod("mainStartup", sig);
        m.invoke((Object)agent, new Object[]{argv});
        agent.setIGlobeCallback(new AcrossCallback());
        return agent;
    }

    URL jarURL(String jarName) throws MalformedURLException {
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        for (String p : Strings.breakAt((String)pathSeparator, (String)classPath)) {
            String nameOnly = Strings.afterLast((String)fileSeparator, (String)p);
            if (!nameOnly.equals(jarName)) continue;
            Debug.noteln((String)"Found jar", (Object)p);
            return new File(p).toURL();
        }
        throw new IllegalStateException("Can't find " + jarName);
    }

    protected class RescuePlannerIdleTask
    extends Task
    implements MessageConstants {
        public RescuePlannerIdleTask(ConversationUnit cu) {
            super(cu);
        }

        protected void handleIncomingMessage(Message m) {
            if (m.getPerformative().equals("REQUEST")) {
                ReportRequestParticipantTask reportRequestParticipantTask = new ReportRequestParticipantTask(this, m){

                    protected void processRequest(Message requestMessage) {
                        RescueTask rt = (RescueTask)requestMessage.getContent();
                        ((RescuePlannerIdleTask)RescuePlannerIdleTask.this).RescuePlanner.this.plansCallback.put(rt.getId(), this);
                        ((RescuePlannerIdleTask)RescuePlannerIdleTask.this).RescuePlanner.this.ixAgent.newTask(rt);
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AcrossCallback
    implements IGlobeCallback {
        @Override
        public void exit() {
        }

        @Override
        public void generateTask() {
        }

        @Override
        public void generateTask(List<String> unavailableResources) {
        }

        @Override
        public void noPlan(RescueTask task) {
            ReportRequestParticipantTask rrpt = RescuePlanner.this.plansCallback.get(task.getId());
            rrpt.sendInformResult(null);
        }

        @Override
        public void takePlan(RescuePlan plan, RescueTask task) {
            ReportRequestParticipantTask rrpt = RescuePlanner.this.plansCallback.get(task.getId());
            rrpt.sendInformResult(plan);
        }
    }

    public static class IXAgentClassLoader
    extends URLClassLoader {
        public IXAgentClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isSharedClass(name)) {
                return super.loadClass(name, resolve);
            }
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        boolean isSharedClass(String name) {
            return !name.startsWith("ix.") || name.indexOf(".shared.") > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IGLobeServices
    implements IGlobeCallback {
        TaskGenerator taskGenerator = new TaskGenerator();

        IGLobeServices() {
        }

        @Override
        public void generateTask() {
            RescuePlanner.this.ixAgent.newTask(this.taskGenerator.nextTask());
        }

        @Override
        public void generateTask(List<String> unavailableResources) {
            RescueTask task = this.taskGenerator.nextTask();
            task.setUnavailableResources(unavailableResources);
            RescuePlanner.this.ixAgent.newTask(task);
        }

        @Override
        public void takePlan(RescuePlan plan, RescueTask task) {
            Debug.noteln((String)"Received a plan for", (Object)task);
            RescuePlanner.this.ixAgent.viewPlan(plan);
        }

        @Override
        public void noPlan(RescueTask task) {
            Debug.noteln((String)"No plan for", (Object)task);
        }

        @Override
        public void exit() {
            RescuePlanner.this.kill();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TaskGenerator {
        Random random = new Random();
        String[] locations = new String[]{"London", "Edinburgh", "Prague"};
        int minInjured = 1;
        int maxInjured = 3;

        TaskGenerator() {
        }

        RescueTask nextTask() {
            RescueTask task = new RescueTask();
            task.setLocation(this.randomth(this.locations));
            task.setNumberInjured(this.between(this.minInjured, this.maxInjured));
            return task;
        }

        private <T> T randomth(T ... values) {
            return values[this.random.nextInt(values.length)];
        }

        private int between(int low, int high) {
            int delta = high - low;
            return low + this.random.nextInt(delta + 1);
        }
    }
}

