/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import iglobe.plan.AbstractActivity;
import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescueActivity;
import iglobe.plan.RescuePlan;
import iglobe.plan.TransportActivity;
import ix.icore.Variable;
import ix.icore.domain.End;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.ip2.Ip2;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RescuePlanMaker {
    protected Ip2 ip2;
    protected ActivityItem root;
    protected List<RescueActivity> activities = new LinkedList<RescueActivity>();
    protected List<PlanConstraint> constraints = new LinkedList<PlanConstraint>();
    protected Map<ActivityItem, RescueActivity> activityTranslation = new LinkedHashMap<ActivityItem, RescueActivity>();
    Gensym.Generator nameGen = new Gensym.Generator();

    public RescuePlanMaker(Ip2 ip2, ActivityItem root) {
        this.ip2 = ip2;
        this.root = root;
    }

    public RescuePlan makeRescuePlan() {
        RescuePlan plan = new RescuePlan();
        this.createRescueActivities();
        this.collectConstraints();
        if (!this.activities.isEmpty()) {
            plan.setActivities(this.activities);
        }
        if (!this.constraints.isEmpty()) {
            plan.setConstraints(this.constraints);
        }
        return plan;
    }

    void createRescueActivities() {
        this.mapActivityTree(this.root, "activity");
    }

    void mapActivityTree(ActivityItem root, String baseId) {
        String id = this.nameGen.nextString(baseId);
        RescueActivity act = this.makeRescueActivity(root, id);
        Debug.noteln((String)"ACT", (Object)act);
        this.activities.add(act);
        this.activityTranslation.put(root, act);
        for (ActivityItem child : root.getChildren()) {
            this.mapActivityTree(child, id);
        }
    }

    RescueActivity makeRescueActivity(ActivityItem item, String id) {
        LList pattern = (LList)Variable.removeVars((Object)item.getPattern());
        String description = Lisp.elementsToString((LList)pattern);
        String verb = pattern.get(0).toString();
        RescueActivity act = verb.equals("transport") ? this.makeTransportActivity(pattern) : new AbstractActivity();
        act.setId(id);
        act.setDescription(description);
        return act;
    }

    TransportActivity makeTransportActivity(LList pattern) {
        TransportActivity act = new TransportActivity();
        LList syntax = Lisp.elementsFromString((String)"transport ?number ?resource ?location");
        MatchEnv env = SimpleMatcher.mustMatch((Object)syntax, (Object)pattern);
        Long n = (Long)this.matchValue(env, "?number", Long.class);
        Symbol resource = (Symbol)this.matchValue(env, "?resource", Symbol.class);
        Symbol location = (Symbol)this.matchValue(env, "?location", Symbol.class);
        act.setAmount(n.intValue());
        act.setResource(resource.toString());
        act.setDestination(location.toString());
        return act;
    }

    Object matchValue(MatchEnv env, String var, Class c) {
        Object value = env.get((Object)Symbol.intern((String)var));
        return Util.mustBe((Class)c, (Object)value);
    }

    void collectConstraints() {
        for (Map.Entry<ActivityItem, RescueActivity> e : this.activityTranslation.entrySet()) {
            ActivityItem item = e.getKey();
            RescueActivity act = e.getValue();
            PNodeEnd itemBegin = item.getBegin();
            for (PNodeEnd pre : itemBegin.getPredecessors()) {
                ActivityItem preItem;
                if (pre.getEnd() != End.END || !(preItem = (ActivityItem)pre.getNode()).isDescendentOf((PNode)this.root)) continue;
                RescueActivity preAct = this.activityTranslation.get(preItem);
                Debug.expect((preAct != null ? 1 : 0) != 0, (String)"Can't find", (Object)preItem);
                OrderConstraint ord = new OrderConstraint();
                ord.setFromId(preAct.getId());
                ord.setToId(act.getId());
                this.constraints.add(ord);
            }
        }
    }
}

