/*
 * Decompiled with CFR 0.152.
 */
package ix.iglobe.test;

import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.process.PNode;
import ix.iface.util.IFUtil;
import ix.iglobe.test.RescuePlanMaker;
import ix.iglobe.test.shared.IGlobeCallback;
import ix.iglobe.test.shared.IGlobeIXAgent;
import ix.ip2.AbstractAgendaItemPopupMenu;
import ix.ip2.ActivityItem;
import ix.ip2.AgendaItem;
import ix.ip2.Ip2;
import ix.ip2.Ip2Frame;
import ix.ip2.NewIp2Frame;
import ix.iplan.IPlanOptionManager;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import ix.util.xml.XMLTreeViewFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGlobeIp2
extends Ip2
implements IGlobeIXAgent {
    IGlobeCallback callback;
    boolean handleAutomatically = false;
    Map<Name, RescueTask> activityIdToTask = new LinkedHashMap<Name, RescueTask>();
    XMLTreeViewFrame treeViewer = new XMLTreeViewFrame((IXAgent)this, "Rescue Plan");

    public IGlobeIp2() {
        this.logoLine1 = "I-Globe I-X Process Panel";
        this.logoImage = "ip2-logo.gif";
    }

    public static void main(String[] argv) {
        Util.printGreeting((String)"I-Globe I-P2");
        new IGlobeIp2().mainStartup(argv);
    }

    @Override
    public void setIGlobeCallback(IGlobeCallback callback) {
        this.callback = callback;
    }

    @Override
    public void newTask(RescueTask task) {
        Debug.noteln((String)"New rescue task", (Object)task);
        Symbol verb = Symbol.intern((String)"deal-with-accident");
        Symbol location = Symbol.intern((String)task.getLocation());
        int numberInjured = task.getNumberInjured();
        Cons pattern = Lisp.list((Object)verb, (Object)new Long(numberInjured), (Object)location);
        Activity act = new Activity((LList)pattern);
        act.ensureId();
        this.activityIdToTask.put(act.getId(), task);
        ActivityItem node = this.controller.addActivity(act);
        node.setIsNew(true);
        List<String> unavailableResources = task.getUnavailableResources();
        if (unavailableResources != null) {
            List<Constraint> constraints = this.makeUnavailableResourceConstraints(unavailableResources);
            this.getIp2ModelManager().addConstraints((PNode)node, constraints);
        }
        if (this.handleAutomatically) {
            this.planFor(node, task);
        }
    }

    @Override
    public void schedulingFailure(RescueTask task) {
        Debug.noteln((String)"Scheduling failure for", (Object)task);
        this.newTask(task);
    }

    @Override
    public void viewPlan(RescuePlan plan) {
        this.treeViewer.editObject((Object)plan);
        this.treeViewer.setVisible(true);
    }

    public void exit() {
        this.frame.dispose();
        this.callback.exit();
    }

    List<Constraint> makeUnavailableResourceConstraints(List<String> unavailableResources) {
        LinkedList<Constraint> result = new LinkedList<Constraint>();
        for (String r : unavailableResources) {
            PatternAssignment pv = new PatternAssignment((LList)Lisp.list((Object)Symbol.intern((String)r)), (Object)new Long(0L));
            Constraint c = new Constraint("resource", "overall", (List)Lisp.list((Object)pv));
            result.add(c);
        }
        return result;
    }

    void planFor(ActivityItem item, RescueTask task) {
        IPlanOptionManager optMan = this.getOptionManager();
        if (!optMan.plan()) {
            this.callback.noPlan(task);
            return;
        }
        Name actId = item.getAbout().getId();
        ActivityItem inPlan = (ActivityItem)this.controller.getActivityAgenda().getItem(actId);
        RescuePlanMaker planMaker = new RescuePlanMaker(this, inPlan);
        RescuePlan p = planMaker.makeRescuePlan();
        this.callback.takePlan(p, task);
    }

    protected Ip2Frame makeIp2Frame() {
        ModifiedIp2Frame frame = new ModifiedIp2Frame(this);
        int rgb = Parameters.getInt((String)"background-color", (int)0);
        if (rgb != 0) {
            Color c = new Color(rgb);
            JComponent content = (JComponent)frame.getContentPane();
            content.setBorder(BorderFactory.createLineBorder(c, 3));
        }
        frame.addTest("Generate rescue task", new ActionListener((Ip2Frame)frame){
            private final /* synthetic */ Ip2Frame val$frame;
            {
                this.val$frame = ip2Frame;
            }

            public void actionPerformed(ActionEvent e) {
                String unavailable = JOptionPane.showInputDialog((Component)this.val$frame, (Object)"Enter unavailable resources separated by commas");
                if (unavailable == null) {
                    return;
                }
                if (unavailable.equals("")) {
                    IGlobeIp2.this.callback.generateTask();
                } else {
                    IGlobeIp2.this.callback.generateTask(Strings.breakAt((String)",", (String)unavailable));
                }
            }
        });
        frame.addTest("Set to automatic", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AbstractButton button = (AbstractButton)event.getSource();
                String command = event.getActionCommand();
                if (command.endsWith("automatic")) {
                    IGlobeIp2.this.handleAutomatically = true;
                    button.setText("Set to manual");
                } else if (command.endsWith("manual")) {
                    IGlobeIp2.this.handleAutomatically = false;
                    button.setText("Set to automatic");
                } else {
                    throw new ConsistencyException("Invalid test action", (Object)command);
                }
            }
        });
        return frame;
    }

    class ModifiedIp2Frame
    extends NewIp2Frame {
        ModifiedIp2Frame(Ip2 ip2) {
            super(ip2);
        }

        public void adjustAgendaItemPopup(AbstractAgendaItemPopupMenu menu, AgendaItem item) {
            if (item.getLevel() == 0 && item instanceof ActivityItem) {
                if (!item.getChildren().isEmpty()) {
                    JMenuItem sendItem = IFUtil.makeMenuItem((String)"Send to HUMRED", (ActionListener)new SendSubtreeHandler((ActivityItem)item));
                    menu.add(sendItem);
                }
                JMenuItem noPlanItem = IFUtil.makeMenuItem((String)"Tell HUMRED no plan was found", (ActionListener)new SendNoPlanHandler((ActivityItem)item));
                menu.add(noPlanItem);
            }
        }
    }

    class SendSubtreeHandler
    implements ActionListener {
        ActivityItem item;

        SendSubtreeHandler(ActivityItem item) {
            this.item = item;
        }

        public void actionPerformed(ActionEvent event) {
            RescuePlanMaker planMaker = new RescuePlanMaker(IGlobeIp2.this, this.item);
            RescuePlan plan = planMaker.makeRescuePlan();
            Debug.noteln((String)"Plan", (Object)XML.objectToXMLString((Object)plan));
            RescueTask task = IGlobeIp2.this.activityIdToTask.get(this.item.getAbout().getId());
            IGlobeIp2.this.callback.takePlan(plan, task);
        }
    }

    class SendNoPlanHandler
    implements ActionListener {
        ActivityItem item;

        SendNoPlanHandler(ActivityItem item) {
            this.item = item;
        }

        public void actionPerformed(ActionEvent event) {
            RescueTask task = IGlobeIp2.this.activityIdToTask.get(this.item.getAbout().getId());
            IGlobeIp2.this.callback.noPlan(task);
        }
    }
}

