/*
 * Decompiled with CFR 0.152.
 */
package iglobe.plan;

import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescuePlan;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueActivity
implements Serializable {
    protected String id;
    protected String description;

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public RescueActivity getParent(RescuePlan plan) {
        String parentId = RescueActivity.beforeLast("-", this.getId());
        if (parentId.indexOf("-") < 0) {
            return null;
        }
        RescueActivity parent = plan.getActivity(parentId);
        if (parent != null) {
            return parent;
        }
        throw new IllegalArgumentException("Activity " + this.getId() + " has no parent.");
    }

    private static String beforeLast(String separator, String s) {
        int i = s.lastIndexOf(separator);
        return i == -1 ? s : s.substring(0, i);
    }

    public Set<RescueActivity> getPredecessors(RescuePlan plan) {
        LinkedHashSet<RescueActivity> result = new LinkedHashSet<RescueActivity>();
        for (PlanConstraint c : plan.getConstraints()) {
            OrderConstraint ord;
            if (!(c instanceof OrderConstraint) || !(ord = (OrderConstraint)c).getToId().equals(this.id)) continue;
            result.add(plan.getActivity(ord.getFromId()));
        }
        return result;
    }
}

