/*
 * Decompiled with CFR 0.152.
 */
package examples.agent.task;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.Query;

public class FRPTask
extends TimeoutTask {
    Message m;
    private final CMAgent owner;

    public FRPTask(CMAgent owner, Message m) {
        super(owner, 5000);
        this.m = m;
        this.owner = owner;
        Message re = m.getReply();
        re.setPerformative("AGREE");
        re.setContent(this.toString());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            owner.logWarning("Problem with sending message: " + ex);
        }
        re.release();
        Message qm = Message.newInstance("REQUEST", m.getReceiver(), Address.getLocalServiceAddress(this.getConversationManager().getContainer(), m.getContent().toString()));
        Query q = new Query();
        q.setParam("name");
        q.setValue(".*");
        qm.setContent(q);
        try {
            this.sendMessage(qm);
        }
        catch (InvisibleContainerException ex) {
            owner.logWarning("Problem with sending message: " + ex);
        }
        qm.release();
    }

    protected synchronized void timeout() {
        Message re = this.m.getReply();
        re.setPerformative("FAILURE");
        re.setContent(this.toString());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.logWarning("Problem with sending message: " + ex);
        }
        re.release();
        this.cancelTask();
    }

    protected synchronized void handleIncomingMessage(Message m) {
        Message re = this.m.getReply();
        re.setContent(m.getContent());
        if (m.getContent() instanceof Query) {
            re.setPerformative("DONE");
        } else {
            re.setPerformative("FAILURE");
        }
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.logWarning("Problem with sending message: " + ex);
        }
        re.release();
        m.release();
        this.cancelTask();
    }

    public void cancelTask() {
        if (this.m != null) {
            this.m.release();
            this.m = null;
        }
        super.cancelTask();
    }
}

