/*
 * Decompiled with CFR 0.152.
 */
package examples.agent.send;

import aglobe.container.transport.Address;
import aglobe.container.transport.AddressPanel;
import aglobe.ontology.Message;
import aglobe.util.FileUtils;
import aglobe.util.gui.RememberPositionJFrame;
import examples.agent.send.SendAgent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SendAgentGUI
extends RememberPositionJFrame {
    private SendAgent owner = null;
    private Set<Object> ontologies = new HashSet<Object>();
    final JFileChooser fc = new JFileChooser(new File(String.valueOf(System.getProperty("user.home")) + "\\My Documents\\Moje\\Inaccessibility\\Source\\msg"));
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel leftPanel = new JPanel();
    private JPanel rightPanel = new JPanel();
    private AddressPanel senderPanel = new AddressPanel("Sender");
    private AddressPanel receiverPanel = new AddressPanel("Receiver");
    private JLabel jLabel1 = new JLabel();
    private JTextField performativeTextField = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JTextField protocolTextField = new JTextField();
    private JLabel jLabel4 = new JLabel();
    private JComboBox ontologyCombo = new JComboBox();
    private JLabel jLabel5 = new JLabel();
    private JTextField convidTextField = new JTextField();
    private JLabel jLabel6 = new JLabel();
    private JLabel jLabel7 = new JLabel();
    private JTextField inreplytoTextField = new JTextField();
    private JTextField replywithTextField = new JTextField();
    private JLabel jLabel8 = new JLabel();
    private JTextField reasonTextField = new JTextField();
    private Border border1;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea contentTextArea = new JTextArea();
    private Border border2;
    private JButton sendButton = new JButton();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private Border border3;
    private TitledBorder titledBorder1;
    private JTextArea incomingTextArea = new JTextArea();
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JMenuItem jMenuItem1 = new JMenuItem();
    JButton clearButton = new JButton();

    public SendAgentGUI(SendAgent _owner) {
        super(_owner);
        try {
            this.owner = _owner;
            this.jbInit();
            this.fc.setFileFilter(new FileUtils.FileFilter(new String[]{"xml", "txt"}, "Text files (*.xml,*.txt)"));
            if (this.owner != null) {
                Address a = this.owner.getAddress();
                this.senderPanel.setAddress(a);
                this.receiverPanel.setHost(a.getHost());
                this.receiverPanel.setPort(a.getPort());
                this.receiverPanel.setContainerName(a.getContainerName());
            }
            this.addOntology("java.lang.String");
            this.addOntology("atg.ontology.Query");
            this.addOntology("atg.ontology.Command");
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(124, 124, 124), new Color(178, 178, 178));
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(115, 114, 105), new Color(165, 163, 151));
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
        this.titledBorder1 = new TitledBorder(this.border3, "Incoming Messages");
        this.leftPanel.setLayout(this.gridBagLayout1);
        this.rightPanel.setLayout(this.borderLayout1);
        this.jLabel1.setText("Performative:");
        this.performativeTextField.setText("REQUEST");
        this.performativeTextField.setColumns(20);
        this.jLabel2.setText("Content:");
        this.jLabel3.setText("Protocol:");
        this.protocolTextField.setColumns(20);
        this.jLabel4.setText("Ontology:");
        this.jLabel5.setText("Conv. ID:");
        this.convidTextField.setColumns(20);
        this.jLabel6.setText("In Reply To:");
        this.jLabel7.setText("Reply With:");
        this.inreplytoTextField.setColumns(20);
        this.replywithTextField.setColumns(20);
        this.jLabel8.setText("Reason:");
        this.reasonTextField.setColumns(20);
        this.contentTextArea.setText("Hello World!");
        this.contentTextArea.setColumns(20);
        this.contentTextArea.setRows(5);
        this.jScrollPane1.setBorder(this.border2);
        this.ontologyCombo.setEditable(true);
        this.sendButton.setText("Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendAgentGUI.this.sendButton_actionPerformed(e);
            }
        });
        this.jScrollPane2.setBorder(this.titledBorder1);
        this.incomingTextArea.setEditable(false);
        this.incomingTextArea.setText("Incoming messages:");
        this.incomingTextArea.setColumns(20);
        this.incomingTextArea.setLineWrap(true);
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic(70);
        this.jMenuItem1.setMnemonic('X');
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(88, 8, false));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendAgentGUI.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.clearButton.setText("Clear incoming log");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendAgentGUI.this.clearButton_actionPerformed(e);
            }
        });
        this.jScrollPane1.getViewport().add((Component)this.contentTextArea, null);
        this.jScrollPane2.getViewport().add((Component)this.incomingTextArea, null);
        this.rightPanel.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.add((Component)this.leftPanel, "left");
        this.jSplitPane1.add((Component)this.rightPanel, "right");
        this.jMenuBar1.add(this.fileMenu);
        this.fileMenu.add(this.jMenuItem1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.leftPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.performativeTextField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.1, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.protocolTextField, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.ontologyCombo, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel5, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.convidTextField, new GridBagConstraints(1, 6, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel6, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel7, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.inreplytoTextField, new GridBagConstraints(1, 7, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.replywithTextField, new GridBagConstraints(1, 8, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jLabel8, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.reasonTextField, new GridBagConstraints(1, 9, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.receiverPanel, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.senderPanel, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.jScrollPane1, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.sendButton, new GridBagConstraints(0, 10, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.leftPanel.add((Component)this.clearButton, new GridBagConstraints(0, 11, 2, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setJMenuBar(this.jMenuBar1);
    }

    void sendButton_actionPerformed(ActionEvent e) {
        this.addOntology(this.ontologyCombo.getSelectedItem());
        Message m = Message.newInstance(this.performativeTextField.getText(), this.senderPanel.getAddress(), this.receiverPanel.getAddress());
        try {
            String s = this.ontologyCombo.getSelectedItem().toString();
            ClassLoader cl = this.owner.getClass().getClassLoader();
            Class<?> cc = cl.loadClass(s);
            Method unm = cc.getMethod("unmarshal", InputStream.class);
            ByteArrayInputStream incont = new ByteArrayInputStream(this.contentTextArea.getText().getBytes());
            m.setContent(unm.invoke(null, incont));
            incont.close();
        }
        catch (Exception ex) {
            m.setContent(this.contentTextArea.getText());
        }
        m.setProtocol(this.protocolTextField.getText());
        m.setConversationID(this.convidTextField.getText());
        m.setInReplyTo(this.inreplytoTextField.getText());
        m.setReplyWith(this.replywithTextField.getText());
        m.setReason(this.reasonTextField.getText());
        this.owner.send(m);
        m.release();
    }

    private void addOntology(Object s) {
        if (this.ontologies.add(s)) {
            this.ontologyCombo.addItem(s);
        }
    }

    public void logMessage(Message msg) {
        final String msgStr = msg.toString();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SendAgentGUI.this.incomingTextArea.append("\nMessage: ======\n" + msgStr);
            }
        });
    }

    public void logString(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SendAgentGUI.this.incomingTextArea.append("\n" + s);
            }
        });
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.owner.exit();
    }

    public void clearButton_actionPerformed(ActionEvent e) {
        this.incomingTextArea.setText("Incoming messages:");
    }
}

