/*
 * Decompiled with CFR 0.152.
 */
package examples.agent.multicast;

import aglobe.container.agent.Agent;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import examples.agent.multicast.MulticastSenderGUI;
import java.util.LinkedHashSet;

public class MulticastSender
extends Agent {
    public static final String MULTICAST_TESTER = "MULTICAST_TESTER";
    public MulticastSenderGUI gui;
    private DirectoryService.Shell dirShell;
    private LinkedHashSet<Address> receivers = new LinkedHashSet();

    public void init(AgentInfo ai, int initState) {
        this.gui = new MulticastSenderGUI(this);
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.dirShell == null) {
            this.logSevere("Cannot find directory service.");
            this.stop();
            return;
        }
        this.dirShell.subscribe(new DirectoryListener(){

            public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
            }

            public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
            }

            public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
                DirectoryRecord[] directoryRecordArray = records;
                int n = 0;
                int n2 = directoryRecordArray.length;
                while (n < n2) {
                    DirectoryRecord elem = directoryRecordArray[n];
                    MulticastSender.this.receivers.add(elem.address);
                    ++n;
                }
            }

            public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
                DirectoryRecord[] directoryRecordArray = records;
                int n = 0;
                int n2 = directoryRecordArray.length;
                while (n < n2) {
                    DirectoryRecord elem = directoryRecordArray[n];
                    MulticastSender.this.receivers.remove(elem.address);
                    ++n;
                }
            }

            public void addEvent(Runnable e) {
                MulticastSender.this.addEvent(e);
            }
        }, MULTICAST_TESTER);
    }

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    void sendMulticastMessage() {
        if (this.receivers.size() == 0) {
            this.logWarning("No receivers");
            return;
        }
        Message m = Message.newInstance("INFORM", this.getAddress(), this.receivers);
        m.setContent("Multicast test message");
        try {
            this.sendMessage(m);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
        m.release();
    }
}

