/*
 * Decompiled with CFR 0.152.
 */
package examples.agent.migrating;

import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.container.transport.ContainerRecord;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.VisibilityUpdate;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.service.link.LinkNeighbourListener;
import aglobe.service.link.LinkService;
import examples.agent.migrating.MigratingAgentGUI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigratingAgent
extends Agent
implements GISTopicListener {
    private static final long serialVersionUID = -3565777661595L;
    public MigratingAgentGUI gui;
    private GISClientService.Shell gisShell;
    private transient LinkService.Shell linkShell;
    private LinkedList<ContainerRecord> allContainers = new LinkedList();
    private LinkedList<ContainerRecord> visibleContainer = new LinkedList();
    private Integer lock = new Integer(0);
    private transient boolean wantMigrate;
    private boolean migrating;
    private Address destinationAddress;
    private transient LinkedList<ContainerRecord> linkVisible;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.linkVisible = new LinkedList();
        if (this.gui == null) {
            try {
                this.gui = new MigratingAgentGUI(this);
            }
            catch (Exception ex) {
                this.logWarning("Cannot create GUI due to: " + ex);
            }
        }
        if (this.gui != null) {
            this.gui.setTitle("Migrating Agent - " + this.getContainer().getContainerName() + ":" + ai.getReadableName());
        }
        if (initState != 4) {
            this.destinationAddress = null;
            if (this.gui != null) {
                this.gui.hostComboBox.removeAllItems();
                for (ContainerRecord item : this.allContainers) {
                    if (item.address.isSameContainer(this.getAddress())) continue;
                    this.gui.hostComboBox.addItem(item.name);
                }
                this.gui.cardLayout1.first(this.gui.jPanel3);
            }
        } else {
            this.wantMigrate = true;
            if (this.gui != null) {
                this.gui.cardLayout1.last(this.gui.jPanel3);
            }
        }
        this.migrating = false;
        if (this.gui != null) {
            this.gui.init();
            this.gui.setVisible(true);
        }
        if (this.gisShell == null) {
            this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
            if (this.gisShell != null) {
                this.gisShell.subscribeTopic("VISIBILITY_UPDATES", this);
            }
        }
        if (this.gisShell == null) {
            this.linkShell = (LinkService.Shell)this.getContainer().getServiceManager().getService(this, "container/link");
            if (this.linkShell == null) {
                this.logWarning("MigratingAgent runs only on a client or link container!");
                this.kill();
            } else {
                this.linkShell.subscribeNeighbour(new LinkNeighbourListener(){

                    public void handleRegister(Address containerAddress) {
                        MigratingAgent.this.linkVisible.add(new ContainerRecord(containerAddress));
                        MigratingAgent.this.newVisibleUpdateSet(MigratingAgent.this.linkVisible);
                    }

                    public void handleDeregister(Address containerAddress) {
                        MigratingAgent.this.linkVisible.remove(new ContainerRecord(containerAddress));
                        MigratingAgent.this.newVisibleUpdateSet(MigratingAgent.this.linkVisible);
                    }

                    public void addEvent(Runnable e) {
                        MigratingAgent.this.addEvent(e);
                    }
                });
            }
        }
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message: " + m.toString());
        m.release();
    }

    public void migrate(final String containerName) {
        this.addEvent(new Runnable(){

            public void run() {
                for (final ContainerRecord item : MigratingAgent.this.allContainers) {
                    if (!item.name.equals(containerName)) continue;
                    if (MigratingAgent.this.gui != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                (this).MigratingAgent.this.gui.textLabel.setText("Moving to " + item.name);
                                (this).MigratingAgent.this.gui.cardLayout1.last((this).MigratingAgent.this.gui.jPanel3);
                            }
                        });
                    }
                    MigratingAgent.this.wantMigrate = true;
                    MigratingAgent.this.destinationAddress = item.address;
                    break;
                }
                if (MigratingAgent.this.wantMigrate) {
                    MigratingAgent.this.tryMigrate(MigratingAgent.this.destinationAddress);
                }
            }
        });
    }

    private void tryMigrate(Address dest) {
        try {
            for (ContainerRecord item : this.visibleContainer) {
                if (!item.address.isSameContainer(dest)) continue;
                this.migrating = true;
                this.migrate(dest);
                break;
            }
        }
        catch (Exception ex) {
            this.logWarning("Migrate Warning " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelMigrate() {
        Integer n = this.lock;
        synchronized (n) {
            if (!this.migrating) {
                this.wantMigrate = false;
                if (this.gui != null) {
                    this.gui.cardLayout1.first(this.gui.jPanel3);
                }
            }
        }
    }

    public void exit() {
        this.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newVisibleUpdateSet(List<ContainerRecord> newSet) {
        LinkedList<ContainerRecord> added = new LinkedList<ContainerRecord>(newSet);
        added.removeAll(this.allContainers);
        for (ContainerRecord item : added) {
            if (this.gisShell != null && item.address.isSameContainer(this.gisShell.getServerAddress())) continue;
            Iterator j = this.allContainers.iterator();
            while (j.hasNext()) {
                ContainerRecord k = (ContainerRecord)j.next();
                if (!k.name.equals(item.name)) continue;
                j.remove();
            }
            this.allContainers.addLast(item);
            if (this.gui == null || item.name.equalsIgnoreCase(this.getContainer().getContainerName())) continue;
            this.gui.addDestination(item.name);
        }
        this.visibleContainer.clear();
        this.visibleContainer.addAll(newSet);
        Integer n = this.lock;
        synchronized (n) {
            if (this.wantMigrate) {
                this.tryMigrate(this.destinationAddress);
            }
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("VISIBILITY_UPDATES")) {
            VisibilityUpdate gi = (VisibilityUpdate)content;
            LinkedList<ContainerRecord> containers = new LinkedList<ContainerRecord>();
            for (Address item : gi.getVisibleContainerAddress()) {
                ContainerRecord cr = new ContainerRecord(item);
                containers.add(cr);
            }
            this.newVisibleUpdateSet(containers);
            return;
        }
        this.logWarning("Unexpected incoming topic: " + topic);
    }

    @Override
    protected void finish() {
        if (this.linkShell != null) {
            this.linkShell.dispose();
            this.linkShell = null;
        }
    }
}

