/*
 * Decompiled with CFR 0.152.
 */
package examples.agent.directory;

import aglobe.container.ElementaryEntity;
import aglobe.container.agent.Agent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import examples.agent.directory.DirectoryAgentGUI;
import java.util.HashSet;

public class DirectoryAgent
extends Agent
implements DirectoryListener {
    public DirectoryAgentGUI gui;
    private DirectoryService.Shell directory;

    public void init(AgentInfo ai, int initState) {
        try {
            this.gui = new DirectoryAgentGUI(this);
            this.gui.setTitle("Directory Agent: " + this.getAddress().toString());
            this.gui.pack();
            this.gui.setVisible(true);
        }
        catch (Exception ex) {
            this.logWarning("Cannot create GUI due to: " + ex);
        }
        this.directory = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
    }

    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected incoming message: " + m);
        m.release();
    }

    private String convertArrayToString(Object[] ar) {
        String retVal = "";
        int i = 0;
        while (i < ar.length) {
            retVal = String.valueOf(retVal) + "[" + ar[i].toString() + "]";
            ++i;
        }
        return retVal;
    }

    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (this.gui != null) {
            this.gui.addToListenerLog("New register:\nContainer: " + containerName + "\nFilter: " + matchingFilter + "\nRecords: " + this.convertArrayToString(records));
        }
    }

    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (this.gui != null) {
            this.gui.addToListenerLog("Deregister:\nContainer: " + containerName + "\nFilter: " + matchingFilter + "\nRecords: " + this.convertArrayToString(records));
        }
    }

    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (this.gui != null) {
            this.gui.addToListenerLog("Visible:\nContainer: " + containerName + "\nFilter: " + matchingFilter + "\nRecords: " + this.convertArrayToString(records));
        }
    }

    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (this.gui != null) {
            this.gui.addToListenerLog("Invisible:\nContainer: " + containerName + "\nFilter: " + matchingFilter + "\nRecords: " + this.convertArrayToString(records));
        }
    }

    void register(String text) {
        block4: {
            if (this.directory != null) {
                if (this.gui != null) {
                    this.gui.addToListenerLog("Register: " + text);
                }
                HashSet<String> add = new HashSet<String>();
                add.add(text);
                try {
                    this.directory.register((ElementaryEntity)this, add);
                }
                catch (DirectoryException ex) {
                    if (this.gui == null) break block4;
                    this.gui.addToListenerLog("Register exception: " + ex);
                }
            }
        }
    }

    void deregister(String text) {
        block4: {
            if (this.directory != null) {
                if (this.gui != null) {
                    this.gui.addToListenerLog("Deregister: " + text);
                }
                HashSet<String> add = new HashSet<String>();
                add.add(text);
                try {
                    this.directory.deregister(add);
                }
                catch (DirectoryException ex) {
                    if (this.gui == null) break block4;
                    this.gui.addToListenerLog("Deregister exception: " + ex);
                }
            }
        }
    }

    void subscribe(String text) {
        if (this.directory != null) {
            if (this.gui != null) {
                this.gui.addToListenerLog("Subscribe: " + text);
            }
            this.directory.subscribe(this, text);
        }
    }

    void unsubscribe(String text) {
        if (this.directory != null) {
            if (this.gui != null) {
                this.gui.addToListenerLog("Unsubscribe: " + text);
            }
            this.directory.unsubscribe(this, text);
        }
    }
}

