/*
 * Decompiled with CFR 0.152.
 */
package aglobex.web.server;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.ontology.Message;
import aglobex.web.server.HttpsServer;
import aglobex.web.server.ImageRequestListener;
import aglobex.web.server.WebRequestListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class WebServerService
extends Service {
    public static final String SERVICENAME = "web/server";
    protected HttpsServer httpsServer;

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    protected void handleIncomingMessage(Message m) {
        this.logSevere("Unexpected incoming message: " + m);
        m.release();
    }

    public void startService() {
    }

    public void initWebServer() {
        this.httpsServer = new HttpsServer(this);
    }

    public void stopService() {
    }

    public class Shell
    extends ServiceShell {
        transient WebServerService theservice;
        private transient boolean postInit;

        public Shell() {
            this.theservice = null;
            this.postInit = false;
        }

        private Shell(ElementaryEntity shellOwner, WebServerService _theservice) {
            super(shellOwner);
            this.theservice = null;
            this.postInit = false;
            this.theservice = _theservice;
        }

        public void dispose() {
            super.dispose();
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public void setContainer(AgentContainer container) throws Exception {
            ServiceShell ss = container.getServiceManager().getService(null, WebServerService.SERVICENAME);
            if (ss == null || !(ss instanceof Shell)) {
                throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the WebServer Service");
            }
            this.theservice = ((Shell)ss).theservice;
            this.postInit = true;
        }

        public void postInit() {
            if (!this.postInit) {
                return;
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
        }

        public boolean registerWebPage(String key, WebRequestListener listener) {
            return WebServerService.this.httpsServer.registerWebPage(this.shellOwner, key, true, listener);
        }

        public boolean registerWebPage(String key, boolean addSorted, WebRequestListener listener) {
            return WebServerService.this.httpsServer.registerWebPage(this.shellOwner, key, addSorted, listener);
        }

        public boolean deregisterWebPage(String key) {
            return WebServerService.this.httpsServer.deregisterWebPage(this.shellOwner, key);
        }

        public String registerImage(ImageRequestListener listener) {
            return WebServerService.this.httpsServer.registerImage(this.shellOwner, listener);
        }

        public boolean deregisterImage(String key) {
            return WebServerService.this.httpsServer.deregisterImage(this.shellOwner, key);
        }
    }
}

